/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobSASPermission;
import com.microsoft.azure.storage.blob.ContainerSASPermission;
import com.microsoft.azure.storage.blob.IPRange;
import com.microsoft.azure.storage.blob.SASProtocol;
import com.microsoft.azure.storage.blob.SASQueryParameters;
import com.microsoft.azure.storage.blob.SharedKeyCredentials;
import com.microsoft.azure.storage.blob.Utility;
import java.security.InvalidKeyException;
import java.time.OffsetDateTime;

public final class ServiceSASSignatureValues {
    public String version = "2017-07-29";
    public SASProtocol protocol;
    public OffsetDateTime startTime;
    public OffsetDateTime expiryTime;
    public String permissions;
    public IPRange ipRange;
    public String containerName;
    public String blobName;
    public String identifier;
    public String cacheControl;
    public String contentDisposition;
    public String contentEncoding;
    public String contentLanguage;
    public String contentType;

    public SASQueryParameters generateSASQueryParameters(SharedKeyCredentials sharedKeyCredentials) {
        String verifiedPermissions;
        if (sharedKeyCredentials == null) {
            throw new IllegalArgumentException("SharedKeyCredentials cannot be null.");
        }
        String resource = "c";
        if (Utility.isNullOrEmpty(this.blobName)) {
            verifiedPermissions = ContainerSASPermission.parse(this.permissions).toString();
        } else {
            verifiedPermissions = BlobSASPermission.parse(this.permissions).toString();
            resource = "b";
        }
        String stringToSign = String.join((CharSequence)"\n", verifiedPermissions, this.startTime == null ? "" : Utility.ISO8601UTCDateFormatter.format(this.startTime), this.expiryTime == null ? "" : Utility.ISO8601UTCDateFormatter.format(this.expiryTime), this.getCanonicalName(sharedKeyCredentials.getAccountName()), this.identifier, this.ipRange == null ? IPRange.DEFAULT.toString() : this.ipRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version, this.cacheControl, this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentType);
        String signature = null;
        try {
            signature = sharedKeyCredentials.computeHmac256(stringToSign);
        }
        catch (InvalidKeyException e) {
            throw new Error(e);
        }
        return new SASQueryParameters(this.version, null, null, this.protocol, this.startTime, this.expiryTime, this.ipRange, this.identifier, resource, this.permissions, signature);
    }

    private String getCanonicalName(String accountName) {
        StringBuilder canonicalName = new StringBuilder("/blob");
        canonicalName.append('/').append(accountName).append('/').append(this.containerName);
        if (!Utility.isNullOrEmpty(this.blobName)) {
            canonicalName.append("/").append(this.blobName);
        }
        return canonicalName.toString();
    }
}

