/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.CommonRestResponse;
import com.microsoft.azure.storage.blob.IProgressReceiver;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.Utility;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;

public class TransferManager {
    public static Single<CommonRestResponse> uploadFileToBlockBlob(FileChannel file, BlockBlobURL blockBlobURL, int blockLength, UploadToBlockBlobOptions options) {
        Utility.assertNotNull("file", file);
        Utility.assertNotNull("blockBlobURL", blockBlobURL);
        Utility.assertInBounds("blockLength", blockLength, 1L, 0x6400000L);
        UploadToBlockBlobOptions optionsReal = options == null ? UploadToBlockBlobOptions.DEFAULT : options;
        try {
            if (file.size() < 0x10000000L) {
                return TransferManager.doSingleShotUpload((Flowable<ByteBuffer>)Flowable.just((Object)file.map(FileChannel.MapMode.READ_ONLY, 0L, file.size())), file.size(), blockBlobURL, optionsReal);
            }
            int numBlocks = TransferManager.calculateNumBlocks(file.size(), blockLength);
            return Observable.range((int)0, (int)numBlocks).map(i -> {
                int count = Math.min(blockLength, (int)(file.size() - (long)(i * blockLength)));
                return file.map(FileChannel.MapMode.READ_ONLY, i * blockLength, count);
            }).collectInto(new ArrayList(numBlocks), ArrayList::add).flatMap(blocks -> TransferManager.uploadByteBuffersToBlockBlob(blocks, blockBlobURL, optionsReal));
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    static int calculateNumBlocks(long dataSize, int blockLength) {
        int numBlocks = StrictMath.toIntExact(dataSize / (long)blockLength);
        if (dataSize % (long)blockLength != 0L) {
            ++numBlocks;
        }
        return numBlocks;
    }

    public static Single<CommonRestResponse> uploadByteBufferToBlockBlob(ByteBuffer data, BlockBlobURL blockBlobURL, int blockLength, UploadToBlockBlobOptions options) {
        UploadToBlockBlobOptions optionsReal;
        Utility.assertNotNull("data", data);
        Utility.assertNotNull("blockBlobURL", blockBlobURL);
        Utility.assertInBounds("blockLength", blockLength, 1L, 0x6400000L);
        UploadToBlockBlobOptions uploadToBlockBlobOptions = optionsReal = options == null ? UploadToBlockBlobOptions.DEFAULT : options;
        if (data.remaining() < 0x10000000) {
            return TransferManager.doSingleShotUpload((Flowable<ByteBuffer>)Flowable.just((Object)data), data.remaining(), blockBlobURL, optionsReal);
        }
        int numBlocks = TransferManager.calculateNumBlocks(data.remaining(), blockLength);
        return Observable.range((int)0, (int)numBlocks).map(i -> {
            int count = Math.min(blockLength, data.remaining() - i * blockLength);
            ByteBuffer block = data.duplicate();
            block.position(i * blockLength);
            block.limit(i * blockLength + count);
            return block;
        }).collectInto(new ArrayList(numBlocks), ArrayList::add).flatMap(blocks -> TransferManager.uploadByteBuffersToBlockBlob(blocks, blockBlobURL, optionsReal));
    }

    public static Single<CommonRestResponse> uploadByteBuffersToBlockBlob(Iterable<ByteBuffer> data, BlockBlobURL blockBlobURL, UploadToBlockBlobOptions options) {
        Utility.assertNotNull("data", data);
        Utility.assertNotNull("blockBlobURL", blockBlobURL);
        UploadToBlockBlobOptions optionsReal = options == null ? UploadToBlockBlobOptions.DEFAULT : options;
        long size = 0L;
        int numBlocks = 0;
        for (ByteBuffer b : data) {
            size += (long)b.remaining();
            ++numBlocks;
        }
        if (size <= 0x10000000L) {
            return TransferManager.doSingleShotUpload((Flowable<ByteBuffer>)Flowable.fromIterable(data), size, blockBlobURL, optionsReal);
        }
        if (numBlocks > 50000) {
            throw new IllegalArgumentException("The total blocks for this upload exceeds the maximum allowable limit.");
        }
        return Observable.fromIterable(data).concatMapEager(blockData -> {
            if (blockData.remaining() > 0x6400000) {
                throw new IllegalArgumentException("Block data should not exceed BlockBlobURL.MAX_PUT_BLOCK_BYTES");
            }
            String blockId = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
            return blockBlobURL.stageBlock(blockId, (Flowable<ByteBuffer>)Flowable.just((Object)blockData), blockData.remaining(), optionsReal.accessConditions.getLeaseAccessConditions()).map(x -> blockId).toObservable();
        }, optionsReal.parallelism, 1).collectInto(new ArrayList(numBlocks), ArrayList::add).flatMap(ids -> blockBlobURL.commitBlockList((List<String>)ids, optionsReal.httpHeaders, optionsReal.metadata, optionsReal.accessConditions)).map(CommonRestResponse::createFromPutBlockListResponse);
    }

    private static Single<CommonRestResponse> doSingleShotUpload(Flowable<ByteBuffer> data, long size, BlockBlobURL blockBlobURL, UploadToBlockBlobOptions options) {
        options.progressReceiver;
        return blockBlobURL.upload(data, size, options.httpHeaders, options.metadata, options.accessConditions).map(CommonRestResponse::createFromPutBlobResponse);
    }

    public static class UploadToBlockBlobOptions {
        public static final UploadToBlockBlobOptions DEFAULT = new UploadToBlockBlobOptions(null, null, null, null, null);
        private IProgressReceiver progressReceiver;
        private BlobHTTPHeaders httpHeaders;
        private Metadata metadata;
        private BlobAccessConditions accessConditions;
        private int parallelism;

        public UploadToBlockBlobOptions(IProgressReceiver progressReceiver, BlobHTTPHeaders httpHeaders, Metadata metadata, BlobAccessConditions accessConditions, Integer parallelism) {
            if (parallelism == null) {
                this.parallelism = 5;
            } else {
                if (parallelism <= 0) {
                    throw new IllegalArgumentException("Parallelism must be > 0");
                }
                this.parallelism = parallelism;
            }
            this.progressReceiver = progressReceiver;
            this.httpHeaders = httpHeaders;
            this.metadata = metadata;
            this.accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        }
    }
}

