/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.rest.v2.DateTimeRfc1123;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="Blobs-CreateSnapshot-Headers")
public final class BlobsCreateSnapshotHeaders {
    @JsonProperty(value="x-ms-snapshot")
    private String snapshot;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;

    public String snapshot() {
        return this.snapshot;
    }

    public BlobsCreateSnapshotHeaders withSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public BlobsCreateSnapshotHeaders withETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime lastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.dateTime();
    }

    public BlobsCreateSnapshotHeaders withLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public BlobsCreateSnapshotHeaders withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public BlobsCreateSnapshotHeaders withVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime date() {
        if (this.date == null) {
            return null;
        }
        return this.date.dateTime();
    }

    public BlobsCreateSnapshotHeaders withDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

