/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.azure.storage.blob.models.BlobType;
import com.microsoft.azure.storage.blob.models.CopyStatusType;
import com.microsoft.azure.storage.blob.models.LeaseDurationType;
import com.microsoft.azure.storage.blob.models.LeaseStateType;
import com.microsoft.azure.storage.blob.models.LeaseStatusType;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.annotations.HeaderCollection;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="Blobs-GetProperties-Headers")
public final class BlobsGetPropertiesHeaders {
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="x-ms-blob-type")
    private BlobType blobType;
    @JsonProperty(value="x-ms-copy-completion-time")
    private DateTimeRfc1123 copyCompletionTime;
    @JsonProperty(value="x-ms-copy-status-description")
    private String copyStatusDescription;
    @JsonProperty(value="x-ms-copy-id")
    private String copyId;
    @JsonProperty(value="x-ms-copy-progress")
    private String copyProgress;
    @JsonProperty(value="x-ms-copy-source")
    private String copySource;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType copyStatus;
    @JsonProperty(value="x-ms-incremental-copy")
    private Boolean isIncrementalCopy;
    @JsonProperty(value="x-ms-copy-destination-snapshot")
    private String destinationSnapshot;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType leaseState;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long blobSequenceNumber;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="x-ms-blob-committed-block-count")
    private Integer blobCommittedBlockCount;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean isServerEncrypted;
    @JsonProperty(value="x-ms-access-tier")
    private String accessTier;
    @JsonProperty(value="x-ms-access-tier-inferred")
    private Boolean accessTierInferred;
    @JsonProperty(value="x-ms-archive-status")
    private String archiveStatus;

    public OffsetDateTime lastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.dateTime();
    }

    public BlobsGetPropertiesHeaders withLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public BlobsGetPropertiesHeaders withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BlobType blobType() {
        return this.blobType;
    }

    public BlobsGetPropertiesHeaders withBlobType(BlobType blobType) {
        this.blobType = blobType;
        return this;
    }

    public OffsetDateTime copyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.dateTime();
    }

    public BlobsGetPropertiesHeaders withCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String copyStatusDescription() {
        return this.copyStatusDescription;
    }

    public BlobsGetPropertiesHeaders withCopyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public String copyId() {
        return this.copyId;
    }

    public BlobsGetPropertiesHeaders withCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public String copyProgress() {
        return this.copyProgress;
    }

    public BlobsGetPropertiesHeaders withCopyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public String copySource() {
        return this.copySource;
    }

    public BlobsGetPropertiesHeaders withCopySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public CopyStatusType copyStatus() {
        return this.copyStatus;
    }

    public BlobsGetPropertiesHeaders withCopyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public Boolean isIncrementalCopy() {
        return this.isIncrementalCopy;
    }

    public BlobsGetPropertiesHeaders withIsIncrementalCopy(Boolean isIncrementalCopy) {
        this.isIncrementalCopy = isIncrementalCopy;
        return this;
    }

    public String destinationSnapshot() {
        return this.destinationSnapshot;
    }

    public BlobsGetPropertiesHeaders withDestinationSnapshot(String destinationSnapshot) {
        this.destinationSnapshot = destinationSnapshot;
        return this;
    }

    public LeaseDurationType leaseDuration() {
        return this.leaseDuration;
    }

    public BlobsGetPropertiesHeaders withLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaseStateType leaseState() {
        return this.leaseState;
    }

    public BlobsGetPropertiesHeaders withLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseStatusType leaseStatus() {
        return this.leaseStatus;
    }

    public BlobsGetPropertiesHeaders withLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public BlobsGetPropertiesHeaders withContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public BlobsGetPropertiesHeaders withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public BlobsGetPropertiesHeaders withETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] contentMD5() {
        return this.contentMD5;
    }

    public BlobsGetPropertiesHeaders withContentMD5(byte[] contentMD5) {
        this.contentMD5 = contentMD5;
        return this;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public BlobsGetPropertiesHeaders withContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public BlobsGetPropertiesHeaders withContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public BlobsGetPropertiesHeaders withContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public BlobsGetPropertiesHeaders withCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public Long blobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobsGetPropertiesHeaders withBlobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public BlobsGetPropertiesHeaders withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public BlobsGetPropertiesHeaders withVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime date() {
        if (this.date == null) {
            return null;
        }
        return this.date.dateTime();
    }

    public BlobsGetPropertiesHeaders withDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String acceptRanges() {
        return this.acceptRanges;
    }

    public BlobsGetPropertiesHeaders withAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public Integer blobCommittedBlockCount() {
        return this.blobCommittedBlockCount;
    }

    public BlobsGetPropertiesHeaders withBlobCommittedBlockCount(Integer blobCommittedBlockCount) {
        this.blobCommittedBlockCount = blobCommittedBlockCount;
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public BlobsGetPropertiesHeaders withIsServerEncrypted(Boolean isServerEncrypted) {
        this.isServerEncrypted = isServerEncrypted;
        return this;
    }

    public String accessTier() {
        return this.accessTier;
    }

    public BlobsGetPropertiesHeaders withAccessTier(String accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public Boolean accessTierInferred() {
        return this.accessTierInferred;
    }

    public BlobsGetPropertiesHeaders withAccessTierInferred(Boolean accessTierInferred) {
        this.accessTierInferred = accessTierInferred;
        return this;
    }

    public String archiveStatus() {
        return this.archiveStatus;
    }

    public BlobsGetPropertiesHeaders withArchiveStatus(String archiveStatus) {
        this.archiveStatus = archiveStatus;
        return this;
    }
}

