/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.azure.storage.blob.models.LeaseDurationType;
import com.microsoft.azure.storage.blob.models.LeaseStateType;
import com.microsoft.azure.storage.blob.models.LeaseStatusType;
import com.microsoft.azure.storage.blob.models.PublicAccessType;
import com.microsoft.rest.v2.DateTimeRfc1123;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="ContainerProperties")
public final class ContainerProperties {
    @JsonProperty(value="Last-Modified", required=true)
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="Etag", required=true)
    private String etag;
    @JsonProperty(value="LeaseStatus")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="LeaseState")
    private LeaseStateType leaseState;
    @JsonProperty(value="LeaseDuration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="PublicAccess")
    private PublicAccessType publicAccess;

    public OffsetDateTime lastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.dateTime();
    }

    public ContainerProperties withLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public ContainerProperties withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public LeaseStatusType leaseStatus() {
        return this.leaseStatus;
    }

    public ContainerProperties withLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public LeaseStateType leaseState() {
        return this.leaseState;
    }

    public ContainerProperties withLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseDurationType leaseDuration() {
        return this.leaseDuration;
    }

    public ContainerProperties withLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public PublicAccessType publicAccess() {
        return this.publicAccess;
    }

    public ContainerProperties withPublicAccess(PublicAccessType publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }
}

