/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.azure.storage.blob.models.PublicAccessType;
import com.microsoft.rest.v2.DateTimeRfc1123;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="Containers-GetAccessPolicy-Headers")
public final class ContainersGetAccessPolicyHeaders {
    @JsonProperty(value="x-ms-blob-public-access")
    private PublicAccessType blobPublicAccess;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;

    public PublicAccessType blobPublicAccess() {
        return this.blobPublicAccess;
    }

    public ContainersGetAccessPolicyHeaders withBlobPublicAccess(PublicAccessType blobPublicAccess) {
        this.blobPublicAccess = blobPublicAccess;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public ContainersGetAccessPolicyHeaders withETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime lastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.dateTime();
    }

    public ContainersGetAccessPolicyHeaders withLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public ContainersGetAccessPolicyHeaders withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ContainersGetAccessPolicyHeaders withVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime date() {
        if (this.date == null) {
            return null;
        }
        return this.date.dateTime();
    }

    public ContainersGetAccessPolicyHeaders withDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

