/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.azure.storage.blob.models.CopyStatusType;
import com.microsoft.rest.v2.DateTimeRfc1123;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="PageBlobs-CopyIncremental-Headers")
public final class PageBlobsCopyIncrementalHeaders {
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    @JsonProperty(value="x-ms-copy-id")
    private String copyId;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType copyStatus;

    public String eTag() {
        return this.eTag;
    }

    public PageBlobsCopyIncrementalHeaders withETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime lastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.dateTime();
    }

    public PageBlobsCopyIncrementalHeaders withLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public PageBlobsCopyIncrementalHeaders withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public PageBlobsCopyIncrementalHeaders withVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime date() {
        if (this.date == null) {
            return null;
        }
        return this.date.dateTime();
    }

    public PageBlobsCopyIncrementalHeaders withDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String copyId() {
        return this.copyId;
    }

    public PageBlobsCopyIncrementalHeaders withCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public CopyStatusType copyStatus() {
        return this.copyStatus;
    }

    public PageBlobsCopyIncrementalHeaders withCopyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }
}

