/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage.blob.implementation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.azure.storage.blob.models.ListBlobsIncludeItem;
import java.util.ArrayList;
import java.util.List;

/**
 * A wrapper around List&lt;ListBlobsIncludeItem&gt; which provides top-level metadata for serialization.
 */
@JacksonXmlRootElement(localName = "ListBlobsIncludeItem")
public final class ListBlobsIncludeItemWrapper {
    @JacksonXmlProperty(localName = "ListBlobsIncludeItem")
    private final List<ListBlobsIncludeItem> listBlobsIncludeItem;

    /**
     * Creates an instance of ListBlobsIncludeItemWrapper.
     *
     * @param listBlobsIncludeItem the list.
     */
    @JsonCreator
    public ListBlobsIncludeItemWrapper(@JsonProperty("ListBlobsIncludeItem") List<ListBlobsIncludeItem> listBlobsIncludeItem) {
        this.listBlobsIncludeItem = listBlobsIncludeItem;
    }

    /**
     * Get the List&lt;ListBlobsIncludeItem&gt; contained in this wrapper.
     *
     * @return the List&lt;ListBlobsIncludeItem&gt;.
     */
    public List<ListBlobsIncludeItem> items() {
        return listBlobsIncludeItem;
    }
}
