/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/**
 * Additional parameters for a set of operations.
 */
@JacksonXmlRootElement(localName = "lease-access-conditions")
public final class LeaseAccessConditions {
    /**
     * If specified, the operation only succeeds if the resource's lease is
     * active and matches this ID.
     */
    @JsonProperty(value = "LeaseId")
    private String leaseId;

    /**
     * Get the leaseId value.
     *
     * @return the leaseId value.
     */
    public String leaseId() {
        return this.leaseId;
    }

    /**
     * Set the leaseId value.
     *
     * @param leaseId the leaseId value to set.
     * @return the LeaseAccessConditions object itself.
     */
    public LeaseAccessConditions withLeaseId(String leaseId) {
        this.leaseId = leaseId;
        return this;
    }
}
