/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.rest.v2.DateTimeRfc1123;
import java.time.OffsetDateTime;

/**
 * Additional parameters for a set of operations.
 */
@JacksonXmlRootElement(localName = "modified-access-conditions")
public final class ModifiedAccessConditions {
    /**
     * Specify this header value to operate only on a blob if it has been
     * modified since the specified date/time.
     */
    @JsonProperty(value = "IfModifiedSince")
    private DateTimeRfc1123 ifModifiedSince;

    /**
     * Specify this header value to operate only on a blob if it has not been
     * modified since the specified date/time.
     */
    @JsonProperty(value = "IfUnmodifiedSince")
    private DateTimeRfc1123 ifUnmodifiedSince;

    /**
     * Specify an ETag value to operate only on blobs with a matching value.
     */
    @JsonProperty(value = "IfMatch")
    private String ifMatch;

    /**
     * Specify an ETag value to operate only on blobs without a matching value.
     */
    @JsonProperty(value = "IfNoneMatch")
    private String ifNoneMatch;

    /**
     * Get the ifModifiedSince value.
     *
     * @return the ifModifiedSince value.
     */
    public OffsetDateTime ifModifiedSince() {
        if (this.ifModifiedSince == null) {
            return null;
        }
        return this.ifModifiedSince.dateTime();
    }

    /**
     * Set the ifModifiedSince value.
     *
     * @param ifModifiedSince the ifModifiedSince value to set.
     * @return the ModifiedAccessConditions object itself.
     */
    public ModifiedAccessConditions withIfModifiedSince(OffsetDateTime ifModifiedSince) {
        if (ifModifiedSince == null) {
            this.ifModifiedSince = null;
        } else {
            this.ifModifiedSince = new DateTimeRfc1123(ifModifiedSince);
        }
        return this;
    }

    /**
     * Get the ifUnmodifiedSince value.
     *
     * @return the ifUnmodifiedSince value.
     */
    public OffsetDateTime ifUnmodifiedSince() {
        if (this.ifUnmodifiedSince == null) {
            return null;
        }
        return this.ifUnmodifiedSince.dateTime();
    }

    /**
     * Set the ifUnmodifiedSince value.
     *
     * @param ifUnmodifiedSince the ifUnmodifiedSince value to set.
     * @return the ModifiedAccessConditions object itself.
     */
    public ModifiedAccessConditions withIfUnmodifiedSince(OffsetDateTime ifUnmodifiedSince) {
        if (ifUnmodifiedSince == null) {
            this.ifUnmodifiedSince = null;
        } else {
            this.ifUnmodifiedSince = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this;
    }

    /**
     * Get the ifMatch value.
     *
     * @return the ifMatch value.
     */
    public String ifMatch() {
        return this.ifMatch;
    }

    /**
     * Set the ifMatch value.
     *
     * @param ifMatch the ifMatch value to set.
     * @return the ModifiedAccessConditions object itself.
     */
    public ModifiedAccessConditions withIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    /**
     * Get the ifNoneMatch value.
     *
     * @return the ifNoneMatch value.
     */
    public String ifNoneMatch() {
        return this.ifNoneMatch;
    }

    /**
     * Set the ifNoneMatch value.
     *
     * @param ifNoneMatch the ifNoneMatch value to set.
     * @return the ModifiedAccessConditions object itself.
     */
    public ModifiedAccessConditions withIfNoneMatch(String ifNoneMatch) {
        this.ifNoneMatch = ifNoneMatch;
        return this;
    }
}
