/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.models.BlockBlobCommitBlockListResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobUploadResponse;
import com.microsoft.rest.v2.RestResponse;
import java.time.OffsetDateTime;

public final class CommonRestResponse {
    private BlockBlobUploadResponse uploadBlobResponse = null;
    private BlockBlobCommitBlockListResponse commitBlockListResponse = null;

    static CommonRestResponse createFromPutBlobResponse(BlockBlobUploadResponse response) {
        CommonRestResponse commonRestResponse = new CommonRestResponse();
        commonRestResponse.uploadBlobResponse = response;
        return commonRestResponse;
    }

    static CommonRestResponse createFromPutBlockListResponse(BlockBlobCommitBlockListResponse response) {
        CommonRestResponse commonRestResponse = new CommonRestResponse();
        commonRestResponse.commitBlockListResponse = response;
        return commonRestResponse;
    }

    private CommonRestResponse() {
    }

    public int statusCode() {
        if (this.uploadBlobResponse != null) {
            return this.uploadBlobResponse.statusCode();
        }
        return this.commitBlockListResponse.statusCode();
    }

    public String eTag() {
        if (this.uploadBlobResponse != null) {
            return this.uploadBlobResponse.headers().eTag();
        }
        return this.commitBlockListResponse.headers().eTag();
    }

    public OffsetDateTime lastModified() {
        if (this.uploadBlobResponse != null) {
            return this.uploadBlobResponse.headers().lastModified();
        }
        return this.commitBlockListResponse.headers().lastModified();
    }

    public String requestId() {
        if (this.uploadBlobResponse != null) {
            return this.uploadBlobResponse.headers().requestId();
        }
        return this.commitBlockListResponse.headers().requestId();
    }

    public OffsetDateTime date() {
        if (this.uploadBlobResponse != null) {
            return this.uploadBlobResponse.headers().date();
        }
        return this.commitBlockListResponse.headers().date();
    }

    public String version() {
        if (this.uploadBlobResponse != null) {
            return this.uploadBlobResponse.headers().version();
        }
        return this.commitBlockListResponse.headers().version();
    }

    public RestResponse response() {
        if (this.uploadBlobResponse != null) {
            return this.uploadBlobResponse;
        }
        return this.commitBlockListResponse;
    }
}

