/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.HTTPGetterInfo;
import com.microsoft.azure.storage.blob.ReliableDownloadOptions;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.BlobDownloadHeaders;
import com.microsoft.rest.v2.RestResponse;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public final class DownloadResponse {
    private final HTTPGetterInfo info;
    private final RestResponse<BlobDownloadHeaders, Flowable<ByteBuffer>> rawResponse;
    private final Function<HTTPGetterInfo, Single<DownloadResponse>> getter;

    public DownloadResponse(RestResponse<BlobDownloadHeaders, Flowable<ByteBuffer>> response, HTTPGetterInfo info, Function<HTTPGetterInfo, Single<DownloadResponse>> getter) {
        Utility.assertNotNull("getter", getter);
        Utility.assertNotNull("info", info);
        Utility.assertNotNull("info.eTag", info.eTag());
        this.rawResponse = response;
        this.info = info;
        this.getter = getter;
    }

    public Flowable<ByteBuffer> body(ReliableDownloadOptions options) {
        ReliableDownloadOptions optionsReal;
        ReliableDownloadOptions reliableDownloadOptions = optionsReal = options == null ? new ReliableDownloadOptions() : options;
        if (optionsReal.maxRetryRequests() == 0) {
            return (Flowable)this.rawResponse.body();
        }
        return ((Flowable)this.rawResponse.body()).doOnNext(buffer -> {
            this.info.withOffset(this.info.offset() + (long)buffer.remaining());
            if (this.info.count() != null) {
                this.info.withCount(this.info.count() - (long)buffer.remaining());
            }
        }).onErrorResumeNext(throwable -> this.tryContinueFlowable((Throwable)throwable, 0, optionsReal));
    }

    private Flowable<ByteBuffer> tryContinueFlowable(Throwable t, int retryCount, ReliableDownloadOptions options) {
        if (retryCount > options.maxRetryRequests() || !(t instanceof IOException)) {
            return Flowable.error((Throwable)t);
        }
        try {
            return ((Single)this.getter.apply((Object)this.info)).flatMapPublisher(response -> {
                ReliableDownloadOptions newOptions = new ReliableDownloadOptions().withMaxRetryRequests(0);
                return response.body(newOptions).doOnNext(buffer -> {
                    this.info.withOffset(this.info.offset() + (long)buffer.remaining());
                    if (this.info.count() != null) {
                        this.info.withCount(this.info.count() - (long)buffer.remaining());
                    }
                }).onErrorResumeNext(t2 -> this.tryContinueFlowable((Throwable)t2, retryCount + 1, options));
            });
        }
        catch (Exception e) {
            return Flowable.error((Throwable)e);
        }
    }

    public int statusCode() {
        return this.rawResponse.statusCode();
    }

    public BlobDownloadHeaders headers() {
        return (BlobDownloadHeaders)this.rawResponse.headers();
    }

    public Map<String, String> rawHeaders() {
        return this.rawResponse.rawHeaders();
    }

    public RestResponse<BlobDownloadHeaders, Flowable<ByteBuffer>> rawResponse() {
        return this.rawResponse;
    }
}

