/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

public final class IPRange {
    public static final IPRange DEFAULT = new IPRange();
    private String ipMin;
    private String ipMax;

    public String ipMin() {
        return this.ipMin;
    }

    public IPRange withIpMin(String ipMin) {
        this.ipMin = ipMin;
        return this;
    }

    public String ipMax() {
        return this.ipMax;
    }

    public IPRange withIpMax(String ipMax) {
        this.ipMax = ipMax;
        return this;
    }

    public String toString() {
        if (this.ipMin == null) {
            return "";
        }
        this.ipMax = this.ipMax == null ? this.ipMin : this.ipMax;
        StringBuilder str = new StringBuilder(this.ipMin);
        if (!this.ipMin.equals(this.ipMax)) {
            str.append('-');
            str.append(this.ipMax);
        }
        return str.toString();
    }

    public static IPRange parse(String rangeStr) {
        String[] addrs = rangeStr.split("-");
        IPRange range = new IPRange();
        range.ipMin = addrs[0];
        if (addrs.length > 1) {
            range.ipMax = addrs[1];
        }
        return range;
    }
}

