/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.LoggingOptions;
import com.microsoft.azure.storage.blob.RequestRetryOptions;
import com.microsoft.azure.storage.blob.TelemetryOptions;
import com.microsoft.rest.v2.http.HttpClient;
import com.microsoft.rest.v2.http.HttpPipelineLogLevel;
import com.microsoft.rest.v2.http.HttpPipelineLogger;
import java.util.Locale;
import java.util.logging.Logger;

public final class PipelineOptions {
    private HttpClient client;
    private HttpPipelineLogger logger;
    private RequestRetryOptions requestRetryOptions = RequestRetryOptions.DEFAULT;
    private LoggingOptions loggingOptions = LoggingOptions.DEFAULT;
    private TelemetryOptions telemetryOptions = TelemetryOptions.DEFAULT;

    public HttpClient client() {
        return this.client;
    }

    public PipelineOptions withClient(HttpClient client) {
        this.client = client;
        return this;
    }

    public HttpPipelineLogger logger() {
        return this.logger;
    }

    public PipelineOptions withLogger(HttpPipelineLogger logger) {
        this.logger = logger;
        return this;
    }

    public RequestRetryOptions requestRetryOptions() {
        return this.requestRetryOptions;
    }

    public PipelineOptions withRequestRetryOptions(RequestRetryOptions requestRetryOptions) {
        this.requestRetryOptions = requestRetryOptions;
        return this;
    }

    public LoggingOptions loggingOptions() {
        return this.loggingOptions;
    }

    public PipelineOptions withLoggingOptions(LoggingOptions loggingOptions) {
        this.loggingOptions = loggingOptions;
        return this;
    }

    public TelemetryOptions telemetryOptions() {
        return this.telemetryOptions;
    }

    public PipelineOptions withTelemetryOptions(TelemetryOptions telemetryOptions) {
        this.telemetryOptions = telemetryOptions;
        return this;
    }

    public PipelineOptions() {
        this.logger = new HttpPipelineLogger(){

            public HttpPipelineLogLevel minimumLogLevel() {
                return HttpPipelineLogLevel.OFF;
            }

            public void log(HttpPipelineLogLevel logLevel, String s, Object ... objects) {
                if (logLevel == HttpPipelineLogLevel.INFO) {
                    Logger.getGlobal().info(String.format(Locale.ROOT, s, objects));
                } else if (logLevel == HttpPipelineLogLevel.WARNING) {
                    Logger.getGlobal().warning(String.format(Locale.ROOT, s, objects));
                } else if (logLevel == HttpPipelineLogLevel.ERROR) {
                    Logger.getGlobal().severe(String.format(Locale.ROOT, s, objects));
                }
            }
        };
    }
}

