/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.RequestRetryOptions;
import com.microsoft.rest.v2.http.HttpHeaders;
import com.microsoft.rest.v2.http.HttpMethod;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.http.UnexpectedLengthException;
import com.microsoft.rest.v2.http.UrlBuilder;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class RequestRetryFactory
implements RequestPolicyFactory {
    private final RequestRetryOptions requestRetryOptions;

    public RequestRetryFactory(RequestRetryOptions requestRetryOptions) {
        this.requestRetryOptions = requestRetryOptions == null ? RequestRetryOptions.DEFAULT : requestRetryOptions;
    }

    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new RequestRetryPolicy(next, this.requestRetryOptions);
    }

    private final class RequestRetryPolicy
    implements RequestPolicy {
        private final RequestPolicy nextPolicy;
        private final RequestRetryOptions requestRetryOptions;

        private RequestRetryPolicy(RequestPolicy nextPolicy, RequestRetryOptions requestRetryOptions) {
            this.nextPolicy = nextPolicy;
            this.requestRetryOptions = requestRetryOptions;
        }

        public Single<HttpResponse> sendAsync(HttpRequest httpRequest) {
            boolean considerSecondary = (httpRequest.httpMethod().equals((Object)HttpMethod.GET) || httpRequest.httpMethod().equals((Object)HttpMethod.HEAD)) && this.requestRetryOptions.secondaryHost() != null;
            return this.attemptAsync(httpRequest, 1, considerSecondary, 1);
        }

        private void logf(String s, Object ... args) {
        }

        private Single<HttpResponse> attemptAsync(HttpRequest httpRequest, int primaryTry, boolean considerSecondary, int attempt) {
            long delayMs;
            boolean tryingPrimary;
            this.logf("\n=====> Try=%d\n", attempt);
            boolean bl = tryingPrimary = !considerSecondary || attempt % 2 == 1;
            if (tryingPrimary) {
                delayMs = this.requestRetryOptions.calculateDelayInMs(primaryTry);
                this.logf("Primary try=%d, Delay=%d\n", primaryTry, delayMs);
            } else {
                delayMs = (long)(((double)(ThreadLocalRandom.current().nextFloat() / 2.0f) + 0.8) * 1000.0);
                this.logf("Secondary try=%d, Delay=%d\n", attempt - primaryTry, delayMs);
            }
            HttpHeaders bufferedHeaders = new HttpHeaders((Iterable)httpRequest.headers());
            Flowable bufferedBody = httpRequest.body() == null ? null : httpRequest.body().map(ByteBuffer::duplicate);
            HttpRequest requestCopy = new HttpRequest(httpRequest.callerMethod(), httpRequest.httpMethod(), httpRequest.url(), bufferedHeaders, bufferedBody, httpRequest.responseDecoder());
            if (!tryingPrimary) {
                UrlBuilder builder = UrlBuilder.parse((URL)requestCopy.url());
                builder.withHost(this.requestRetryOptions.secondaryHost());
                try {
                    requestCopy.withUrl(builder.toURL());
                }
                catch (MalformedURLException e) {
                    return Single.error((Throwable)e);
                }
            }
            return this.nextPolicy.sendAsync(requestCopy).timeout((long)this.requestRetryOptions.tryTimeout(), TimeUnit.SECONDS).delaySubscription(delayMs, TimeUnit.MILLISECONDS).flatMap(response -> {
                String action;
                boolean newConsiderSecondary = considerSecondary;
                int statusCode = response.statusCode();
                if (!tryingPrimary && statusCode == 404) {
                    newConsiderSecondary = false;
                    action = "Retry: Secondary URL returned 404";
                } else {
                    action = statusCode == 503 || statusCode == 500 ? "Retry: Temporary error or server timeout" : "NoRetry: Successful HTTP request";
                }
                this.logf("Action=%s\n", action);
                if (action.charAt(0) == 'R' && attempt < this.requestRetryOptions.maxTries()) {
                    int newPrimaryTry = !tryingPrimary || !considerSecondary ? primaryTry + 1 : primaryTry;
                    return this.attemptAsync(httpRequest, newPrimaryTry, newConsiderSecondary, attempt + 1);
                }
                return Single.just((Object)response);
            }).onErrorResumeNext(throwable -> {
                if (throwable instanceof UnexpectedLengthException && attempt > 1) {
                    return Single.error((Throwable)new IllegalStateException("The request failed because the size of the contents of the provided Flowable did not match the provided data size upon attempting to retry. This is likely caused by the Flowable not being replayable. To support retries, all Flowables must produce the same data for each subscriber. Please ensure this behavior.", (Throwable)throwable));
                }
                String action = throwable instanceof IOException ? "Retry: Network error" : (throwable instanceof TimeoutException ? "Retry: Client timeout" : "NoRetry: Unknown error");
                this.logf("Action=%s\n", action);
                if (action.charAt(0) == 'R' && attempt < this.requestRetryOptions.maxTries()) {
                    int newPrimaryTry = !tryingPrimary || !considerSecondary ? primaryTry + 1 : primaryTry;
                    return this.attemptAsync(httpRequest, newPrimaryTry, considerSecondary, attempt + 1);
                }
                return Single.error((Throwable)throwable);
            });
        }
    }
}

