/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobRange;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.CommonRestResponse;
import com.microsoft.azure.storage.blob.TransferManagerDownloadFromBlobOptions;
import com.microsoft.azure.storage.blob.TransferManagerUploadToBlockBlobOptions;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.BlobDownloadHeaders;
import com.microsoft.azure.storage.blob.models.ModifiedAccessConditions;
import com.microsoft.rest.v2.util.FlowableUtil;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import javafx.util.Pair;

public final class TransferManager {
    public static final int BLOB_DEFAULT_DOWNLOAD_BLOCK_SIZE = 0x400000;

    public static Single<CommonRestResponse> uploadFileToBlockBlob(AsynchronousFileChannel file, BlockBlobURL blockBlobURL, int blockLength, TransferManagerUploadToBlockBlobOptions options) throws IOException {
        TransferManagerUploadToBlockBlobOptions optionsReal;
        Utility.assertNotNull("file", file);
        Utility.assertNotNull("blockBlobURL", blockBlobURL);
        Utility.assertInBounds("blockLength", blockLength, 1L, 0x6400000L);
        TransferManagerUploadToBlockBlobOptions transferManagerUploadToBlockBlobOptions = optionsReal = options == null ? TransferManagerUploadToBlockBlobOptions.DEFAULT : options;
        if (file.size() < 0x10000000L) {
            optionsReal.progressReceiver();
            return blockBlobURL.upload((Flowable<ByteBuffer>)FlowableUtil.readFile((AsynchronousFileChannel)file), file.size(), optionsReal.httpHeaders(), optionsReal.metadata(), optionsReal.accessConditions(), null).map(CommonRestResponse::createFromPutBlobResponse);
        }
        int numBlocks = TransferManager.calculateNumBlocks(file.size(), blockLength);
        if (numBlocks > 50000) {
            throw new IllegalArgumentException("The total blocks for this upload exceeds the maximum allowable limit.");
        }
        return Observable.range((int)0, (int)numBlocks).concatMapEager(i -> {
            int count = Math.min(blockLength, (int)(file.size() - (long)(i * blockLength)));
            Flowable data = FlowableUtil.readFile((AsynchronousFileChannel)file, (long)(i * blockLength), (long)count);
            String blockId = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
            return blockBlobURL.stageBlock(blockId, (Flowable<ByteBuffer>)data, count, optionsReal.accessConditions().leaseAccessConditions(), null).map(x -> blockId).toObservable();
        }, optionsReal.parallelism(), 1).collectInto(new ArrayList(numBlocks), ArrayList::add).flatMap(ids -> blockBlobURL.commitBlockList((List<String>)ids, optionsReal.httpHeaders(), optionsReal.metadata(), optionsReal.accessConditions(), null)).map(CommonRestResponse::createFromPutBlockListResponse);
    }

    private static int calculateNumBlocks(long dataSize, long blockLength) {
        int numBlocks = StrictMath.toIntExact(dataSize / blockLength);
        if (dataSize % blockLength != 0L) {
            ++numBlocks;
        }
        return numBlocks;
    }

    public static Single<BlobDownloadHeaders> downloadBlobToFile(AsynchronousFileChannel file, BlobURL blobURL, BlobRange range, TransferManagerDownloadFromBlobOptions options) {
        BlobRange r = range == null ? BlobRange.DEFAULT : range;
        TransferManagerDownloadFromBlobOptions o = options == null ? TransferManagerDownloadFromBlobOptions.DEFAULT : options;
        Utility.assertNotNull("blobURL", blobURL);
        Utility.assertNotNull("file", file);
        Single<Pair<Long, BlobAccessConditions>> setupSingle = TransferManager.getSetupSingle(blobURL, r, o);
        return setupSingle.flatMap(setupPair -> {
            Long dataSize = (Long)setupPair.getKey();
            BlobAccessConditions realConditions = (BlobAccessConditions)setupPair.getValue();
            int numChunks = TransferManager.calculateNumBlocks(dataSize, o.chunkSize());
            numChunks = numChunks == 0 ? 1 : numChunks;
            return Observable.range((int)0, (int)numChunks).flatMap(i -> {
                long chunkSizeActual = Math.min(o.chunkSize(), dataSize - (long)i.intValue() * o.chunkSize());
                BlobRange chunkRange = new BlobRange().withOffset(r.offset() + (long)i.intValue() * o.chunkSize()).withCount(chunkSizeActual);
                return blobURL.download(chunkRange, realConditions, false, null).flatMapObservable(response -> FlowableUtil.writeFile(response.body(o.reliableDownloadOptionsPerBlock()), (AsynchronousFileChannel)file, (long)((long)i.intValue() * o.chunkSize())).andThen((SingleSource)Single.just((Object)response.headers())).toObservable());
            }, o.parallelism()).lastOrError();
        });
    }

    private static Single<Pair<Long, BlobAccessConditions>> getSetupSingle(BlobURL blobURL, BlobRange r, TransferManagerDownloadFromBlobOptions o) {
        if (r.count() == null || o.accessConditions().modifiedAccessConditions().ifMatch() == null) {
            return blobURL.getProperties(o.accessConditions(), null).map(response -> {
                BlobAccessConditions newConditions = o.accessConditions().modifiedAccessConditions().ifMatch() == null ? new BlobAccessConditions().withModifiedAccessConditions(new ModifiedAccessConditions().withIfModifiedSince(o.accessConditions().modifiedAccessConditions().ifModifiedSince()).withIfUnmodifiedSince(o.accessConditions().modifiedAccessConditions().ifUnmodifiedSince()).withIfMatch(response.headers().eTag()).withIfNoneMatch(o.accessConditions().modifiedAccessConditions().ifNoneMatch())).withLeaseAccessConditions(o.accessConditions().leaseAccessConditions()) : o.accessConditions();
                long newCount = r.count() == null || r.count() > response.headers().contentLength() - r.offset() ? response.headers().contentLength() - r.offset() : r.count();
                return new Pair((Object)newCount, (Object)newConditions);
            });
        }
        return Single.just((Object)new Pair((Object)r.count(), (Object)o.accessConditions()));
    }
}

