/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.GeneratedStorageClient;
import com.microsoft.azure.storage.blob.implementation.SignedIdentifiersWrapper;
import com.microsoft.azure.storage.blob.models.ContainerAcquireLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainerBreakLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainerChangeLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainerCreateResponse;
import com.microsoft.azure.storage.blob.models.ContainerDeleteResponse;
import com.microsoft.azure.storage.blob.models.ContainerGetAccessPolicyResponse;
import com.microsoft.azure.storage.blob.models.ContainerGetAccountInfoResponse;
import com.microsoft.azure.storage.blob.models.ContainerGetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.ContainerListBlobFlatSegmentResponse;
import com.microsoft.azure.storage.blob.models.ContainerListBlobHierarchySegmentResponse;
import com.microsoft.azure.storage.blob.models.ContainerReleaseLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainerRenewLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainerSetAccessPolicyResponse;
import com.microsoft.azure.storage.blob.models.ContainerSetMetadataResponse;
import com.microsoft.azure.storage.blob.models.LeaseAccessConditions;
import com.microsoft.azure.storage.blob.models.ListBlobsFlatSegmentResponse;
import com.microsoft.azure.storage.blob.models.ListBlobsHierarchySegmentResponse;
import com.microsoft.azure.storage.blob.models.ListBlobsIncludeItem;
import com.microsoft.azure.storage.blob.models.ModifiedAccessConditions;
import com.microsoft.azure.storage.blob.models.PublicAccessType;
import com.microsoft.azure.storage.blob.models.SignedIdentifier;
import com.microsoft.azure.storage.blob.models.StorageErrorException;
import com.microsoft.rest.v2.CollectionFormat;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceCallback;
import com.microsoft.rest.v2.ServiceClient;
import com.microsoft.rest.v2.ServiceFuture;
import com.microsoft.rest.v2.Validator;
import com.microsoft.rest.v2.annotations.BodyParam;
import com.microsoft.rest.v2.annotations.DELETE;
import com.microsoft.rest.v2.annotations.ExpectedResponses;
import com.microsoft.rest.v2.annotations.GET;
import com.microsoft.rest.v2.annotations.HeaderParam;
import com.microsoft.rest.v2.annotations.Host;
import com.microsoft.rest.v2.annotations.HostParam;
import com.microsoft.rest.v2.annotations.PUT;
import com.microsoft.rest.v2.annotations.QueryParam;
import com.microsoft.rest.v2.annotations.UnexpectedResponseExceptionType;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class GeneratedContainers {
    private ContainersService service;
    private GeneratedStorageClient client;

    public GeneratedContainers(GeneratedStorageClient client) {
        this.service = (ContainersService)RestProxy.create(ContainersService.class, (ServiceClient)client);
        this.client = client;
    }

    public void create(Context context, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId) {
        this.createAsync(context, timeout, metadata, access, requestId).blockingAwait();
    }

    public ServiceFuture<Void> createAsync(Context context, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.createAsync(context, timeout, metadata, access, requestId), serviceCallback);
    }

    public Single<ContainerCreateResponse> createWithRestResponseAsync(Context context, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(metadata);
        return this.service.create(context, this.client.url(), timeout, metadata, access, this.client.version(), requestId, "container");
    }

    public Completable createAsync(Context context, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId) {
        return this.createWithRestResponseAsync(context, timeout, metadata, access, requestId).toCompletable();
    }

    public void getProperties(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        this.getPropertiesAsync(context, timeout, requestId, leaseAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> getPropertiesAsync(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.getPropertiesAsync(context, timeout, requestId, leaseAccessConditions), serviceCallback);
    }

    public Single<ContainerGetPropertiesResponse> getPropertiesWithRestResponseAsync(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate((Object)leaseAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        return this.service.getProperties(context, this.client.url(), timeout, this.client.version(), requestId, "container", leaseId);
    }

    public Completable getPropertiesAsync(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        return this.getPropertiesWithRestResponseAsync(context, timeout, requestId, leaseAccessConditions).toCompletable();
    }

    public void delete(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.deleteAsync(context, timeout, requestId, leaseAccessConditions, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> deleteAsync(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.deleteAsync(context, timeout, requestId, leaseAccessConditions, modifiedAccessConditions), serviceCallback);
    }

    public Single<ContainerDeleteResponse> deleteWithRestResponseAsync(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate((Object)leaseAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.delete(context, this.client.url(), timeout, this.client.version(), requestId, "container", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted);
    }

    public Completable deleteAsync(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.deleteWithRestResponseAsync(context, timeout, requestId, leaseAccessConditions, modifiedAccessConditions).toCompletable();
    }

    public void setMetadata(Context context, Integer timeout, Map<String, String> metadata, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.setMetadataAsync(context, timeout, metadata, requestId, leaseAccessConditions, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> setMetadataAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.setMetadataAsync(context, timeout, metadata, requestId, leaseAccessConditions, modifiedAccessConditions), serviceCallback);
    }

    public Single<ContainerSetMetadataResponse> setMetadataWithRestResponseAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(metadata);
        Validator.validate((Object)leaseAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        return this.service.setMetadata(context, this.client.url(), timeout, metadata, this.client.version(), requestId, "container", "metadata", leaseId, ifModifiedSinceConverted);
    }

    public Completable setMetadataAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.setMetadataWithRestResponseAsync(context, timeout, metadata, requestId, leaseAccessConditions, modifiedAccessConditions).toCompletable();
    }

    public List<SignedIdentifier> getAccessPolicy(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        return (List)this.getAccessPolicyAsync(context, timeout, requestId, leaseAccessConditions).blockingGet();
    }

    public ServiceFuture<List<SignedIdentifier>> getAccessPolicyAsync(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ServiceCallback<List<SignedIdentifier>> serviceCallback) {
        return ServiceFuture.fromBody(this.getAccessPolicyAsync(context, timeout, requestId, leaseAccessConditions), serviceCallback);
    }

    public Single<ContainerGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate((Object)leaseAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        return this.service.getAccessPolicy(context, this.client.url(), timeout, this.client.version(), requestId, "container", "acl", leaseId);
    }

    public Maybe<List<SignedIdentifier>> getAccessPolicyAsync(Context context, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions) {
        return this.getAccessPolicyWithRestResponseAsync(context, timeout, requestId, leaseAccessConditions).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public void setAccessPolicy(Context context, List<SignedIdentifier> containerAcl, Integer timeout, PublicAccessType access, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        this.setAccessPolicyAsync(context, containerAcl, timeout, access, requestId, leaseAccessConditions, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> setAccessPolicyAsync(Context context, List<SignedIdentifier> containerAcl, Integer timeout, PublicAccessType access, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.setAccessPolicyAsync(context, containerAcl, timeout, access, requestId, leaseAccessConditions, modifiedAccessConditions), serviceCallback);
    }

    public Single<ContainerSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(Context context, List<SignedIdentifier> containerAcl, Integer timeout, PublicAccessType access, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(containerAcl);
        Validator.validate((Object)leaseAccessConditions);
        Validator.validate((Object)modifiedAccessConditions);
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.setAccessPolicy(context, this.client.url(), new SignedIdentifiersWrapper(containerAcl), timeout, access, this.client.version(), requestId, "container", "acl", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted);
    }

    public Completable setAccessPolicyAsync(Context context, List<SignedIdentifier> containerAcl, Integer timeout, PublicAccessType access, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions) {
        return this.setAccessPolicyWithRestResponseAsync(context, containerAcl, timeout, access, requestId, leaseAccessConditions, modifiedAccessConditions).toCompletable();
    }

    public void acquireLease(Context context, Integer timeout, Integer duration, String proposedLeaseId, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        this.acquireLeaseAsync(context, timeout, duration, proposedLeaseId, requestId, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> acquireLeaseAsync(Context context, Integer timeout, Integer duration, String proposedLeaseId, String requestId, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.acquireLeaseAsync(context, timeout, duration, proposedLeaseId, requestId, modifiedAccessConditions), serviceCallback);
    }

    public Single<ContainerAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(Context context, Integer timeout, Integer duration, String proposedLeaseId, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate((Object)modifiedAccessConditions);
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.acquireLease(context, this.client.url(), timeout, duration, proposedLeaseId, this.client.version(), requestId, "lease", "container", "acquire", ifModifiedSinceConverted, ifUnmodifiedSinceConverted);
    }

    public Completable acquireLeaseAsync(Context context, Integer timeout, Integer duration, String proposedLeaseId, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        return this.acquireLeaseWithRestResponseAsync(context, timeout, duration, proposedLeaseId, requestId, modifiedAccessConditions).toCompletable();
    }

    public void releaseLease(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        this.releaseLeaseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> releaseLeaseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.releaseLeaseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions), serviceCallback);
    }

    public Single<ContainerReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (leaseId == null) {
            throw new IllegalArgumentException("Parameter leaseId is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate((Object)modifiedAccessConditions);
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.releaseLease(context, this.client.url(), timeout, leaseId, this.client.version(), requestId, "lease", "container", "release", ifModifiedSinceConverted, ifUnmodifiedSinceConverted);
    }

    public Completable releaseLeaseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        return this.releaseLeaseWithRestResponseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions).toCompletable();
    }

    public void renewLease(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        this.renewLeaseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> renewLeaseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.renewLeaseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions), serviceCallback);
    }

    public Single<ContainerRenewLeaseResponse> renewLeaseWithRestResponseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (leaseId == null) {
            throw new IllegalArgumentException("Parameter leaseId is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate((Object)modifiedAccessConditions);
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.renewLease(context, this.client.url(), timeout, leaseId, this.client.version(), requestId, "lease", "container", "renew", ifModifiedSinceConverted, ifUnmodifiedSinceConverted);
    }

    public Completable renewLeaseAsync(Context context, @NonNull String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        return this.renewLeaseWithRestResponseAsync(context, leaseId, timeout, requestId, modifiedAccessConditions).toCompletable();
    }

    public void breakLease(Context context, Integer timeout, Integer breakPeriod, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        this.breakLeaseAsync(context, timeout, breakPeriod, requestId, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> breakLeaseAsync(Context context, Integer timeout, Integer breakPeriod, String requestId, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.breakLeaseAsync(context, timeout, breakPeriod, requestId, modifiedAccessConditions), serviceCallback);
    }

    public Single<ContainerBreakLeaseResponse> breakLeaseWithRestResponseAsync(Context context, Integer timeout, Integer breakPeriod, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate((Object)modifiedAccessConditions);
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.breakLease(context, this.client.url(), timeout, breakPeriod, this.client.version(), requestId, "lease", "container", "break", ifModifiedSinceConverted, ifUnmodifiedSinceConverted);
    }

    public Completable breakLeaseAsync(Context context, Integer timeout, Integer breakPeriod, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        return this.breakLeaseWithRestResponseAsync(context, timeout, breakPeriod, requestId, modifiedAccessConditions).toCompletable();
    }

    public void changeLease(Context context, @NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        this.changeLeaseAsync(context, leaseId, proposedLeaseId, timeout, requestId, modifiedAccessConditions).blockingAwait();
    }

    public ServiceFuture<Void> changeLeaseAsync(Context context, @NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.changeLeaseAsync(context, leaseId, proposedLeaseId, timeout, requestId, modifiedAccessConditions), serviceCallback);
    }

    public Single<ContainerChangeLeaseResponse> changeLeaseWithRestResponseAsync(Context context, @NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (leaseId == null) {
            throw new IllegalArgumentException("Parameter leaseId is required and cannot be null.");
        }
        if (proposedLeaseId == null) {
            throw new IllegalArgumentException("Parameter proposedLeaseId is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate((Object)modifiedAccessConditions);
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.changeLease(context, this.client.url(), timeout, leaseId, proposedLeaseId, this.client.version(), requestId, "lease", "container", "change", ifModifiedSinceConverted, ifUnmodifiedSinceConverted);
    }

    public Completable changeLeaseAsync(Context context, @NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions) {
        return this.changeLeaseWithRestResponseAsync(context, leaseId, proposedLeaseId, timeout, requestId, modifiedAccessConditions).toCompletable();
    }

    public ListBlobsFlatSegmentResponse listBlobFlatSegment(Context context, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return (ListBlobsFlatSegmentResponse)this.listBlobFlatSegmentAsync(context, prefix, marker, maxresults, include, timeout, requestId).blockingGet();
    }

    public ServiceFuture<ListBlobsFlatSegmentResponse> listBlobFlatSegmentAsync(Context context, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, ServiceCallback<ListBlobsFlatSegmentResponse> serviceCallback) {
        return ServiceFuture.fromBody(this.listBlobFlatSegmentAsync(context, prefix, marker, maxresults, include, timeout, requestId), serviceCallback);
    }

    public Single<ContainerListBlobFlatSegmentResponse> listBlobFlatSegmentWithRestResponseAsync(Context context, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(include);
        String includeConverted = this.client.serializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listBlobFlatSegment(context, this.client.url(), prefix, marker, maxresults, includeConverted, timeout, this.client.version(), requestId, "container", "list");
    }

    public Maybe<ListBlobsFlatSegmentResponse> listBlobFlatSegmentAsync(Context context, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return this.listBlobFlatSegmentWithRestResponseAsync(context, prefix, marker, maxresults, include, timeout, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public ListBlobsHierarchySegmentResponse listBlobHierarchySegment(Context context, @NonNull String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return (ListBlobsHierarchySegmentResponse)this.listBlobHierarchySegmentAsync(context, delimiter, prefix, marker, maxresults, include, timeout, requestId).blockingGet();
    }

    public ServiceFuture<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentAsync(Context context, @NonNull String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, ServiceCallback<ListBlobsHierarchySegmentResponse> serviceCallback) {
        return ServiceFuture.fromBody(this.listBlobHierarchySegmentAsync(context, delimiter, prefix, marker, maxresults, include, timeout, requestId), serviceCallback);
    }

    public Single<ContainerListBlobHierarchySegmentResponse> listBlobHierarchySegmentWithRestResponseAsync(Context context, @NonNull String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (delimiter == null) {
            throw new IllegalArgumentException("Parameter delimiter is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(include);
        String includeConverted = this.client.serializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listBlobHierarchySegment(context, this.client.url(), prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.version(), requestId, "container", "list");
    }

    public Maybe<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentAsync(Context context, @NonNull String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return this.listBlobHierarchySegmentWithRestResponseAsync(context, delimiter, prefix, marker, maxresults, include, timeout, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public void getAccountInfo(Context context) {
        this.getAccountInfoAsync(context).blockingAwait();
    }

    public ServiceFuture<Void> getAccountInfoAsync(Context context, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.getAccountInfoAsync(context), serviceCallback);
    }

    public Single<ContainerGetAccountInfoResponse> getAccountInfoWithRestResponseAsync(Context context) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        return this.service.getAccountInfo(context, this.client.url(), this.client.version(), "account", "properties");
    }

    public Completable getAccountInfoAsync(Context context) {
        return this.getAccountInfoWithRestResponseAsync(context).toCompletable();
    }

    @Host(value="{url}")
    private static interface ContainersService {
        @PUT(value="{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerCreateResponse> create(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="restype") String var8);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerGetPropertiesResponse> getProperties(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @HeaderParam(value="x-ms-lease-id") String var7);

        @DELETE(value="{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerDeleteResponse> delete(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerSetMetadataResponse> setMetadata(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="restype") String var7, @QueryParam(value="comp") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerGetAccessPolicyResponse> getAccessPolicy(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, @HeaderParam(value="x-ms-lease-id") String var8);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerSetAccessPolicyResponse> setAccessPolicy(Context var1, @HostParam(value="url") String var2, @BodyParam(value="application/xml; charset=utf-8") SignedIdentifiersWrapper var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="restype") String var8, @QueryParam(value="comp") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerAcquireLeaseResponse> acquireLease(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-duration") Integer var4, @HeaderParam(value="x-ms-proposed-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @QueryParam(value="restype") String var9, @HeaderParam(value="x-ms-lease-action") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerReleaseLeaseResponse> releaseLease(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @QueryParam(value="restype") String var8, @HeaderParam(value="x-ms-lease-action") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerRenewLeaseResponse> renewLease(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @QueryParam(value="restype") String var8, @HeaderParam(value="x-ms-lease-action") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerBreakLeaseResponse> breakLease(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-break-period") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @QueryParam(value="restype") String var8, @HeaderParam(value="x-ms-lease-action") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerChangeLeaseResponse> changeLease(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-proposed-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @QueryParam(value="restype") String var9, @HeaderParam(value="x-ms-lease-action") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerListBlobFlatSegmentResponse> listBlobFlatSegment(Context var1, @HostParam(value="url") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @QueryParam(value="restype") String var10, @QueryParam(value="comp") String var11);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerListBlobHierarchySegmentResponse> listBlobHierarchySegment(Context var1, @HostParam(value="url") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="delimiter") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="include") String var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="restype") String var11, @QueryParam(value="comp") String var12);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainerGetAccountInfoResponse> getAccountInfo(Context var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5);
    }
}

