/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobRange;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.CommonRestResponse;
import com.microsoft.azure.storage.blob.ProgressReporter;
import com.microsoft.azure.storage.blob.TransferManagerDownloadFromBlobOptions;
import com.microsoft.azure.storage.blob.TransferManagerUploadToBlockBlobOptions;
import com.microsoft.azure.storage.blob.UploadFromNRFBufferPool;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.BlobDownloadHeaders;
import com.microsoft.azure.storage.blob.models.BlockBlobCommitBlockListResponse;
import com.microsoft.azure.storage.blob.models.ModifiedAccessConditions;
import com.microsoft.rest.v2.util.FlowableUtil;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Publisher;

public final class TransferManager {
    public static final int BLOB_DEFAULT_DOWNLOAD_BLOCK_SIZE = 0x400000;

    public static Single<CommonRestResponse> uploadFileToBlockBlob(AsynchronousFileChannel file, BlockBlobURL blockBlobURL, int blockLength, TransferManagerUploadToBlockBlobOptions options) throws IOException {
        Utility.assertNotNull("file", file);
        Utility.assertNotNull("blockBlobURL", blockBlobURL);
        Utility.assertInBounds("blockLength", blockLength, 1L, 0x6400000L);
        TransferManagerUploadToBlockBlobOptions optionsReal = options == null ? TransferManagerUploadToBlockBlobOptions.DEFAULT : options;
        AtomicLong totalProgress = new AtomicLong(0L);
        ReentrantLock progressLock = new ReentrantLock();
        if (file.size() < 0x10000000L) {
            Flowable<ByteBuffer> data = FlowableUtil.readFile((AsynchronousFileChannel)file);
            data = ProgressReporter.addProgressReporting(data, optionsReal.progressReceiver());
            return blockBlobURL.upload(data, file.size(), optionsReal.httpHeaders(), optionsReal.metadata(), optionsReal.accessConditions(), null).map(CommonRestResponse::createFromPutBlobResponse);
        }
        int numBlocks = TransferManager.calculateNumBlocks(file.size(), blockLength);
        if (numBlocks > 50000) {
            throw new IllegalArgumentException("The total blocks for this upload exceeds the maximum allowable limit.");
        }
        return Observable.range((int)0, (int)numBlocks).concatMapEager(i -> {
            int count = (int)Math.min((long)blockLength, file.size() - (long)i.intValue() * (long)blockLength);
            Flowable<ByteBuffer> data = FlowableUtil.readFile((AsynchronousFileChannel)file, (long)((long)i.intValue() * (long)blockLength), (long)count);
            data = ProgressReporter.addParallelProgressReporting(data, optionsReal.progressReceiver(), progressLock, totalProgress);
            String blockId = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
            return blockBlobURL.stageBlock(blockId, data, count, optionsReal.accessConditions().leaseAccessConditions(), null).map(x -> blockId).toObservable();
        }, optionsReal.parallelism(), 1).collectInto(new ArrayList(numBlocks), ArrayList::add).flatMap(ids -> blockBlobURL.commitBlockList((List<String>)ids, optionsReal.httpHeaders(), optionsReal.metadata(), optionsReal.accessConditions(), null)).map(CommonRestResponse::createFromPutBlockListResponse);
    }

    private static int calculateNumBlocks(long dataSize, long blockLength) {
        int numBlocks = StrictMath.toIntExact(dataSize / blockLength);
        if (dataSize % blockLength != 0L) {
            ++numBlocks;
        }
        return numBlocks;
    }

    public static Single<BlobDownloadHeaders> downloadBlobToFile(AsynchronousFileChannel file, BlobURL blobURL, BlobRange range, TransferManagerDownloadFromBlobOptions options) {
        BlobRange rangeReal = range == null ? BlobRange.DEFAULT : range;
        TransferManagerDownloadFromBlobOptions optionsReal = options == null ? TransferManagerDownloadFromBlobOptions.DEFAULT : options;
        Utility.assertNotNull("blobURL", blobURL);
        Utility.assertNotNull("file", file);
        ReentrantLock progressLock = new ReentrantLock();
        AtomicLong totalProgress = new AtomicLong(0L);
        Single<List<Object>> setupSingle = TransferManager.getSetupSingle(blobURL, rangeReal, optionsReal);
        return setupSingle.flatMap(setupPair -> {
            Long dataSize = (Long)setupPair.get(0);
            BlobAccessConditions realConditions = (BlobAccessConditions)setupPair.get(1);
            int numChunks = TransferManager.calculateNumBlocks(dataSize, optionsReal.chunkSize());
            numChunks = numChunks == 0 ? 1 : numChunks;
            return Observable.range((int)0, (int)numChunks).flatMap(chunkNum -> {
                long chunkSizeActual = Math.min(optionsReal.chunkSize(), dataSize - (long)chunkNum.intValue() * optionsReal.chunkSize());
                BlobRange chunkRange = new BlobRange().withOffset(rangeReal.offset() + (long)chunkNum.intValue() * optionsReal.chunkSize()).withCount(chunkSizeActual);
                return blobURL.download(chunkRange, realConditions, false, null).flatMapObservable(response -> {
                    Flowable<ByteBuffer> data = response.body(optionsReal.reliableDownloadOptionsPerBlock());
                    data = ProgressReporter.addParallelProgressReporting(data, optionsReal.progressReceiver(), progressLock, totalProgress);
                    return FlowableUtil.writeFile(data, (AsynchronousFileChannel)file, (long)((long)chunkNum.intValue() * optionsReal.chunkSize())).andThen((SingleSource)Single.just((Object)response.headers())).toObservable();
                });
            }, optionsReal.parallelism()).lastOrError();
        });
    }

    private static Single<List<Object>> getSetupSingle(BlobURL blobURL, BlobRange r, TransferManagerDownloadFromBlobOptions o) {
        if (r.count() == null || o.accessConditions().modifiedAccessConditions().ifMatch() == null) {
            return blobURL.getProperties(o.accessConditions(), null).map(response -> {
                BlobAccessConditions newConditions = o.accessConditions().modifiedAccessConditions().ifMatch() == null ? new BlobAccessConditions().withModifiedAccessConditions(new ModifiedAccessConditions().withIfModifiedSince(o.accessConditions().modifiedAccessConditions().ifModifiedSince()).withIfUnmodifiedSince(o.accessConditions().modifiedAccessConditions().ifUnmodifiedSince()).withIfMatch(response.headers().eTag()).withIfNoneMatch(o.accessConditions().modifiedAccessConditions().ifNoneMatch())).withLeaseAccessConditions(o.accessConditions().leaseAccessConditions()) : o.accessConditions();
                long newCount = r.count() == null || r.count() > response.headers().contentLength() - r.offset() ? response.headers().contentLength() - r.offset() : r.count();
                return Arrays.asList(newCount, newConditions);
            });
        }
        return Single.just(Arrays.asList(r.count(), o.accessConditions()));
    }

    public static Single<BlockBlobCommitBlockListResponse> uploadFromNonReplayableFlowable(Flowable<ByteBuffer> source, BlockBlobURL blockBlobURL, int blockSize, int numBuffers, TransferManagerUploadToBlockBlobOptions options) {
        Utility.assertNotNull("source", source);
        Utility.assertNotNull("blockBlobURL", blockBlobURL);
        TransferManagerUploadToBlockBlobOptions optionsReal = options == null ? TransferManagerUploadToBlockBlobOptions.DEFAULT : options;
        AtomicLong totalProgress = new AtomicLong(0L);
        ReentrantLock progressLock = new ReentrantLock();
        UploadFromNRFBufferPool pool = new UploadFromNRFBufferPool(numBuffers, blockSize);
        Flowable chunkedSource = source.flatMap(buffer -> {
            if (buffer.remaining() <= blockSize) {
                return Flowable.just((Object)buffer);
            }
            ArrayList<ByteBuffer> smallerChunks = new ArrayList<ByteBuffer>();
            int i = 0;
            while ((double)i < Math.ceil((double)buffer.remaining() / (double)blockSize)) {
                ByteBuffer duplicate = buffer.duplicate();
                duplicate.position(i * blockSize);
                duplicate.limit(Math.min(duplicate.limit(), (i + 1) * blockSize));
                smallerChunks.add(duplicate);
                ++i;
            }
            return Flowable.fromIterable(smallerChunks);
        }, false, 1);
        return chunkedSource.flatMap(pool::write, false, 1).concatWith((Publisher)Flowable.defer(pool::flush)).concatMapEager(buffer -> {
            Flowable<ByteBuffer> data = ProgressReporter.addParallelProgressReporting((Flowable<ByteBuffer>)Flowable.just((Object)buffer), optionsReal.progressReceiver(), progressLock, totalProgress);
            String blockId = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
            return blockBlobURL.stageBlock(blockId, data, buffer.remaining(), optionsReal.accessConditions().leaseAccessConditions(), null).map(x -> {
                pool.returnBuffer((ByteBuffer)buffer);
                return blockId;
            }).toFlowable();
        }, optionsReal.parallelism(), 1).collectInto(new ArrayList(), ArrayList::add).flatMap(ids -> blockBlobURL.commitBlockList((List<String>)ids, optionsReal.httpHeaders(), optionsReal.metadata(), optionsReal.accessConditions(), null));
    }
}

