/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.AppendBlobURL;
import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobRange;
import com.microsoft.azure.storage.blob.BlobURLParts;
import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.DownloadResponse;
import com.microsoft.azure.storage.blob.HTTPGetterInfo;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.PageBlobURL;
import com.microsoft.azure.storage.blob.StorageURL;
import com.microsoft.azure.storage.blob.URLParser;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.AccessTier;
import com.microsoft.azure.storage.blob.models.BlobAbortCopyFromURLResponse;
import com.microsoft.azure.storage.blob.models.BlobAcquireLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobBreakLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobChangeLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobCopyFromURLResponse;
import com.microsoft.azure.storage.blob.models.BlobCreateSnapshotResponse;
import com.microsoft.azure.storage.blob.models.BlobDeleteResponse;
import com.microsoft.azure.storage.blob.models.BlobDownloadHeaders;
import com.microsoft.azure.storage.blob.models.BlobGetAccountInfoResponse;
import com.microsoft.azure.storage.blob.models.BlobGetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.models.BlobReleaseLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobRenewLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobSetHTTPHeadersResponse;
import com.microsoft.azure.storage.blob.models.BlobSetMetadataResponse;
import com.microsoft.azure.storage.blob.models.BlobSetTierResponse;
import com.microsoft.azure.storage.blob.models.BlobStartCopyFromURLResponse;
import com.microsoft.azure.storage.blob.models.BlobUndeleteResponse;
import com.microsoft.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.microsoft.azure.storage.blob.models.LeaseAccessConditions;
import com.microsoft.azure.storage.blob.models.ModifiedAccessConditions;
import com.microsoft.azure.storage.blob.models.SourceModifiedAccessConditions;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.RestResponse;
import com.microsoft.rest.v2.http.HttpPipeline;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class BlobURL
extends StorageURL {
    public BlobURL(URL url, HttpPipeline pipeline) {
        super(url, pipeline);
    }

    public BlobURL withPipeline(HttpPipeline pipeline) {
        try {
            return new BlobURL(new URL(this.storageClient.url()), pipeline);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public BlobURL withSnapshot(String snapshot) throws MalformedURLException, UnknownHostException {
        BlobURLParts blobURLParts = URLParser.parse(new URL(this.storageClient.url()));
        blobURLParts.withSnapshot(snapshot);
        return new BlobURL(blobURLParts.toURL(), this.storageClient.httpPipeline());
    }

    public BlockBlobURL toBlockBlobURL() {
        try {
            return new BlockBlobURL(new URL(this.storageClient.url()), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public AppendBlobURL toAppendBlobURL() {
        try {
            return new AppendBlobURL(new URL(this.storageClient.url()), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public PageBlobURL toPageBlobURL() {
        try {
            return new PageBlobURL(new URL(this.storageClient.url()), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Single<BlobStartCopyFromURLResponse> startCopyFromURL(URL sourceURL) {
        return this.startCopyFromURL(sourceURL, null, null, null, null);
    }

    public Single<BlobStartCopyFromURLResponse> startCopyFromURL(URL sourceURL, Metadata metadata, ModifiedAccessConditions sourceModifiedAccessConditions, BlobAccessConditions destAccessConditions, Context context) {
        metadata = metadata == null ? new Metadata() : metadata;
        sourceModifiedAccessConditions = sourceModifiedAccessConditions == null ? new ModifiedAccessConditions() : sourceModifiedAccessConditions;
        destAccessConditions = destAccessConditions == null ? new BlobAccessConditions() : destAccessConditions;
        context = context == null ? Context.NONE : context;
        SourceModifiedAccessConditions sourceConditions = new SourceModifiedAccessConditions().withSourceIfModifiedSince(sourceModifiedAccessConditions.ifModifiedSince()).withSourceIfUnmodifiedSince(sourceModifiedAccessConditions.ifUnmodifiedSince()).withSourceIfMatch(sourceModifiedAccessConditions.ifMatch()).withSourceIfNoneMatch(sourceModifiedAccessConditions.ifNoneMatch());
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().startCopyFromURLWithRestResponseAsync(context, sourceURL, null, metadata, null, sourceConditions, destAccessConditions.modifiedAccessConditions(), destAccessConditions.leaseAccessConditions()));
    }

    public Single<BlobAbortCopyFromURLResponse> abortCopyFromURL(String copyId) {
        return this.abortCopyFromURL(copyId, null, null);
    }

    public Single<BlobAbortCopyFromURLResponse> abortCopyFromURL(String copyId, LeaseAccessConditions leaseAccessConditions, Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().abortCopyFromURLWithRestResponseAsync(context, copyId, null, null, leaseAccessConditions));
    }

    public Single<BlobCopyFromURLResponse> syncCopyFromURL(URL copySource) {
        return this.syncCopyFromURL(copySource, null, null, null, null);
    }

    public Single<BlobCopyFromURLResponse> syncCopyFromURL(URL copySource, Metadata metadata, ModifiedAccessConditions sourceModifiedAccessConditions, BlobAccessConditions destAccessConditions, Context context) {
        metadata = metadata == null ? new Metadata() : metadata;
        sourceModifiedAccessConditions = sourceModifiedAccessConditions == null ? new ModifiedAccessConditions() : sourceModifiedAccessConditions;
        destAccessConditions = destAccessConditions == null ? new BlobAccessConditions() : destAccessConditions;
        context = context == null ? Context.NONE : context;
        SourceModifiedAccessConditions sourceConditions = new SourceModifiedAccessConditions().withSourceIfModifiedSince(sourceModifiedAccessConditions.ifModifiedSince()).withSourceIfUnmodifiedSince(sourceModifiedAccessConditions.ifUnmodifiedSince()).withSourceIfMatch(sourceModifiedAccessConditions.ifMatch()).withSourceIfNoneMatch(sourceModifiedAccessConditions.ifNoneMatch());
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().copyFromURLWithRestResponseAsync(context, copySource, null, metadata, null, sourceConditions, destAccessConditions.modifiedAccessConditions(), destAccessConditions.leaseAccessConditions()));
    }

    public Single<DownloadResponse> download() {
        return this.download(null, null, false, null);
    }

    public Single<DownloadResponse> download(BlobRange range, BlobAccessConditions accessConditions, boolean rangeGetContentMD5, Context context) {
        Boolean getMD5 = rangeGetContentMD5 ? Boolean.valueOf(rangeGetContentMD5) : null;
        range = range == null ? new BlobRange() : range;
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        HTTPGetterInfo info = new HTTPGetterInfo().withOffset(range.offset()).withCount(range.count()).withETag(accessConditions.modifiedAccessConditions().ifMatch());
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().downloadWithRestResponseAsync(context, null, null, range.toHeaderValue(), getMD5, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions())).map(response -> {
            info.withETag(response.headers().eTag());
            return new DownloadResponse((RestResponse<BlobDownloadHeaders, Flowable<ByteBuffer>>)response, info, (Function<HTTPGetterInfo, Single<DownloadResponse>>)((Function)newInfo -> this.download(new BlobRange().withOffset(newInfo.offset()).withCount(newInfo.count()), new BlobAccessConditions().withModifiedAccessConditions(new ModifiedAccessConditions().withIfMatch(info.eTag())), false, context == null ? Context.NONE : context)));
        });
    }

    public Single<BlobDeleteResponse> delete() {
        return this.delete(null, null, null);
    }

    public Single<BlobDeleteResponse> delete(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobAccessConditions accessConditions, Context context) {
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().deleteWithRestResponseAsync(context, null, null, deleteBlobSnapshotOptions, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<BlobGetPropertiesResponse> getProperties() {
        return this.getProperties(null, null);
    }

    public Single<BlobGetPropertiesResponse> getProperties(BlobAccessConditions accessConditions, Context context) {
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().getPropertiesWithRestResponseAsync(context, null, null, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<BlobSetHTTPHeadersResponse> setHTTPHeaders(BlobHTTPHeaders headers) {
        return this.setHTTPHeaders(headers, null, null);
    }

    public Single<BlobSetHTTPHeadersResponse> setHTTPHeaders(BlobHTTPHeaders headers, BlobAccessConditions accessConditions, Context context) {
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().setHTTPHeadersWithRestResponseAsync(context, null, null, headers, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<BlobSetMetadataResponse> setMetadata(Metadata metadata) {
        return this.setMetadata(metadata, null, null);
    }

    public Single<BlobSetMetadataResponse> setMetadata(Metadata metadata, BlobAccessConditions accessConditions, Context context) {
        metadata = metadata == null ? new Metadata() : metadata;
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().setMetadataWithRestResponseAsync(context, null, metadata, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<BlobCreateSnapshotResponse> createSnapshot() {
        return this.createSnapshot(null, null, null);
    }

    public Single<BlobCreateSnapshotResponse> createSnapshot(Metadata metadata, BlobAccessConditions accessConditions, Context context) {
        metadata = metadata == null ? new Metadata() : metadata;
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().createSnapshotWithRestResponseAsync(context, null, metadata, null, accessConditions.modifiedAccessConditions(), accessConditions.leaseAccessConditions()));
    }

    public Single<BlobSetTierResponse> setTier(AccessTier tier) {
        return this.setTier(tier, null, null);
    }

    public Single<BlobSetTierResponse> setTier(AccessTier tier, LeaseAccessConditions leaseAccessConditions, Context context) {
        Utility.assertNotNull("tier", (Object)tier);
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().setTierWithRestResponseAsync(context, tier, null, null, leaseAccessConditions));
    }

    public Single<BlobUndeleteResponse> undelete() {
        return this.undelete(null);
    }

    public Single<BlobUndeleteResponse> undelete(Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().undeleteWithRestResponseAsync(context, null, null));
    }

    public Single<BlobAcquireLeaseResponse> acquireLease(String proposedId, int duration) {
        return this.acquireLease(proposedId, duration, null, null);
    }

    public Single<BlobAcquireLeaseResponse> acquireLease(String proposedID, int duration, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        if (duration != -1 && (duration < 15 || duration > 60)) {
            throw new IllegalArgumentException("Duration must be -1 or between 15 and 60.");
        }
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().acquireLeaseWithRestResponseAsync(context, null, duration, proposedID, null, modifiedAccessConditions));
    }

    public Single<BlobRenewLeaseResponse> renewLease(String leaseID) {
        return this.renewLease(leaseID, null, null);
    }

    public Single<BlobRenewLeaseResponse> renewLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().renewLeaseWithRestResponseAsync(context, leaseID, null, null, modifiedAccessConditions));
    }

    public Single<BlobReleaseLeaseResponse> releaseLease(String leaseID) {
        return this.releaseLease(leaseID, null, null);
    }

    public Single<BlobReleaseLeaseResponse> releaseLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().releaseLeaseWithRestResponseAsync(context, leaseID, null, null, modifiedAccessConditions));
    }

    public Single<BlobBreakLeaseResponse> breakLease() {
        return this.breakLease(null, null, null);
    }

    public Single<BlobBreakLeaseResponse> breakLease(Integer breakPeriodInSeconds, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().breakLeaseWithRestResponseAsync(context, null, breakPeriodInSeconds, null, modifiedAccessConditions));
    }

    public Single<BlobChangeLeaseResponse> changeLease(String leaseId, String proposedID) {
        return this.changeLease(leaseId, proposedID, null, null);
    }

    public Single<BlobChangeLeaseResponse> changeLease(String leaseId, String proposedID, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().changeLeaseWithRestResponseAsync(context, leaseId, proposedID, null, null, modifiedAccessConditions));
    }

    public Single<BlobGetAccountInfoResponse> getAccountInfo() {
        return this.getAccountInfo(null);
    }

    public Single<BlobGetAccountInfoResponse> getAccountInfo(Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedBlobs().getAccountInfoWithRestResponseAsync(context));
    }
}

