/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.ICredentials;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.util.concurrent.atomic.AtomicReference;

public final class TokenCredentials
implements ICredentials {
    private AtomicReference<String> token;

    public TokenCredentials(String token) {
        this.token = new AtomicReference<String>(token);
    }

    public String getToken() {
        return this.token.get();
    }

    public void setToken(String token) {
        this.token.set(token);
    }

    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new TokenCredentialsPolicy(this, next);
    }

    private final class TokenCredentialsPolicy
    implements RequestPolicy {
        private final TokenCredentials factory;
        private final RequestPolicy nextPolicy;

        private TokenCredentialsPolicy(TokenCredentials factory, RequestPolicy nextPolicy) {
            this.factory = factory;
            this.nextPolicy = nextPolicy;
        }

        public Single<HttpResponse> sendAsync(HttpRequest request) {
            if (!request.url().getProtocol().equals("https")) {
                throw new Error("Token credentials require a URL using the https protocol scheme");
            }
            request.withHeader("Authorization", "Bearer " + this.factory.getToken());
            return this.nextPolicy.sendAsync(request);
        }
    }
}

