/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.AppendBlobURL;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.ContainerAccessConditions;
import com.microsoft.azure.storage.blob.ListBlobsOptions;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.PageBlobURL;
import com.microsoft.azure.storage.blob.StorageURL;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.ContainerAcquireLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainerBreakLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainerChangeLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainerCreateResponse;
import com.microsoft.azure.storage.blob.models.ContainerDeleteResponse;
import com.microsoft.azure.storage.blob.models.ContainerGetAccessPolicyResponse;
import com.microsoft.azure.storage.blob.models.ContainerGetAccountInfoResponse;
import com.microsoft.azure.storage.blob.models.ContainerGetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.ContainerListBlobFlatSegmentResponse;
import com.microsoft.azure.storage.blob.models.ContainerListBlobHierarchySegmentResponse;
import com.microsoft.azure.storage.blob.models.ContainerReleaseLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainerRenewLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainerSetAccessPolicyResponse;
import com.microsoft.azure.storage.blob.models.ContainerSetMetadataResponse;
import com.microsoft.azure.storage.blob.models.LeaseAccessConditions;
import com.microsoft.azure.storage.blob.models.ModifiedAccessConditions;
import com.microsoft.azure.storage.blob.models.PublicAccessType;
import com.microsoft.azure.storage.blob.models.SignedIdentifier;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.http.HttpPipeline;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.temporal.ChronoUnit;
import java.util.List;

public final class ContainerURL
extends StorageURL {
    public static final String ROOT_CONTAINER_NAME = "$root";
    public static final String STATIC_WEBSITE_CONTAINER_NAME = "$web";
    public static final String LOG_CONTAINER_NAME = "$logs";

    public ContainerURL(URL url, HttpPipeline pipeline) {
        super(url, pipeline);
    }

    public ContainerURL withPipeline(HttpPipeline pipeline) {
        try {
            return new ContainerURL(new URL(this.storageClient.url()), pipeline);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public BlockBlobURL createBlockBlobURL(String blobName) {
        blobName = Utility.safeURLEncode(blobName);
        try {
            return new BlockBlobURL(StorageURL.appendToURLPath(new URL(this.storageClient.url()), blobName), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public PageBlobURL createPageBlobURL(String blobName) {
        blobName = Utility.safeURLEncode(blobName);
        try {
            return new PageBlobURL(StorageURL.appendToURLPath(new URL(this.storageClient.url()), blobName), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public AppendBlobURL createAppendBlobURL(String blobName) {
        blobName = Utility.safeURLEncode(blobName);
        try {
            return new AppendBlobURL(StorageURL.appendToURLPath(new URL(this.storageClient.url()), blobName), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public BlobURL createBlobURL(String blobName) {
        blobName = Utility.safeURLEncode(blobName);
        try {
            return new BlobURL(StorageURL.appendToURLPath(new URL(this.storageClient.url()), blobName), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Single<ContainerCreateResponse> create() {
        return this.create(null, null, null);
    }

    public Single<ContainerCreateResponse> create(Metadata metadata, PublicAccessType accessType, Context context) {
        metadata = metadata == null ? new Metadata() : metadata;
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedContainers().createWithRestResponseAsync(context, null, metadata, accessType, null));
    }

    public Single<ContainerDeleteResponse> delete() {
        return this.delete(null, null);
    }

    public Single<ContainerDeleteResponse> delete(ContainerAccessConditions accessConditions, Context context) {
        accessConditions = accessConditions == null ? new ContainerAccessConditions() : accessConditions;
        Context context2 = context = context == null ? Context.NONE : context;
        if (!this.validateNoEtag(accessConditions.modifiedAccessConditions())) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        return Utility.postProcessResponse(this.storageClient.generatedContainers().deleteWithRestResponseAsync(context, null, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<ContainerGetPropertiesResponse> getProperties() {
        return this.getProperties(null, null);
    }

    public Single<ContainerGetPropertiesResponse> getProperties(LeaseAccessConditions leaseAccessConditions, Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedContainers().getPropertiesWithRestResponseAsync(context, null, null, leaseAccessConditions));
    }

    public Single<ContainerSetMetadataResponse> setMetadata(Metadata metadata) {
        return this.setMetadata(metadata, null, null);
    }

    public Single<ContainerSetMetadataResponse> setMetadata(Metadata metadata, ContainerAccessConditions accessConditions, Context context) {
        metadata = metadata == null ? new Metadata() : metadata;
        accessConditions = accessConditions == null ? new ContainerAccessConditions() : accessConditions;
        Context context2 = context = context == null ? Context.NONE : context;
        if (!this.validateNoEtag(accessConditions.modifiedAccessConditions()) || accessConditions.modifiedAccessConditions().ifUnmodifiedSince() != null) {
            throw new UnsupportedOperationException("If-Modified-Since is the only HTTP access condition supported for this API");
        }
        return Utility.postProcessResponse(this.storageClient.generatedContainers().setMetadataWithRestResponseAsync(context, null, metadata, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<ContainerGetAccessPolicyResponse> getAccessPolicy() {
        return this.getAccessPolicy(null, null);
    }

    public Single<ContainerGetAccessPolicyResponse> getAccessPolicy(LeaseAccessConditions leaseAccessConditions, Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedContainers().getAccessPolicyWithRestResponseAsync(context, null, null, leaseAccessConditions));
    }

    public Single<ContainerSetAccessPolicyResponse> setAccessPolicy(PublicAccessType accessType, List<SignedIdentifier> identifiers) {
        return this.setAccessPolicy(accessType, identifiers, null, null);
    }

    public Single<ContainerSetAccessPolicyResponse> setAccessPolicy(PublicAccessType accessType, List<SignedIdentifier> identifiers, ContainerAccessConditions accessConditions, Context context) {
        accessConditions = accessConditions == null ? new ContainerAccessConditions() : accessConditions;
        Context context2 = context = context == null ? Context.NONE : context;
        if (!this.validateNoEtag(accessConditions.modifiedAccessConditions())) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        if (identifiers != null) {
            for (SignedIdentifier identifier : identifiers) {
                if (identifier.accessPolicy() != null && identifier.accessPolicy().start() != null) {
                    identifier.accessPolicy().withStart(identifier.accessPolicy().start().truncatedTo(ChronoUnit.SECONDS));
                }
                if (identifier.accessPolicy() == null || identifier.accessPolicy().expiry() == null) continue;
                identifier.accessPolicy().withExpiry(identifier.accessPolicy().expiry().truncatedTo(ChronoUnit.SECONDS));
            }
        }
        return Utility.postProcessResponse(this.storageClient.generatedContainers().setAccessPolicyWithRestResponseAsync(context, identifiers, null, accessType, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    private boolean validateNoEtag(ModifiedAccessConditions modifiedAccessConditions) {
        if (modifiedAccessConditions == null) {
            return true;
        }
        return modifiedAccessConditions.ifMatch() == null && modifiedAccessConditions.ifNoneMatch() == null;
    }

    public Single<ContainerAcquireLeaseResponse> acquireLease(String proposedId, int duration) {
        return this.acquireLease(proposedId, duration, null, null);
    }

    public Single<ContainerAcquireLeaseResponse> acquireLease(String proposedID, int duration, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        if (!this.validateNoEtag(modifiedAccessConditions)) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedContainers().acquireLeaseWithRestResponseAsync(context, null, duration, proposedID, null, modifiedAccessConditions));
    }

    public Single<ContainerRenewLeaseResponse> renewLease(String leaseID) {
        return this.renewLease(leaseID, null, null);
    }

    public Single<ContainerRenewLeaseResponse> renewLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        if (!this.validateNoEtag(modifiedAccessConditions)) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedContainers().renewLeaseWithRestResponseAsync(context, leaseID, null, null, modifiedAccessConditions));
    }

    public Single<ContainerReleaseLeaseResponse> releaseLease(String leaseID) {
        return this.releaseLease(leaseID, null, null);
    }

    public Single<ContainerReleaseLeaseResponse> releaseLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        if (!this.validateNoEtag(modifiedAccessConditions)) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedContainers().releaseLeaseWithRestResponseAsync(context, leaseID, null, null, modifiedAccessConditions));
    }

    public Single<ContainerBreakLeaseResponse> breakLease() {
        return this.breakLease(null, null, null);
    }

    public Single<ContainerBreakLeaseResponse> breakLease(Integer breakPeriodInSeconds, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        if (!this.validateNoEtag(modifiedAccessConditions)) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedContainers().breakLeaseWithRestResponseAsync(context, null, breakPeriodInSeconds, null, modifiedAccessConditions));
    }

    public Single<ContainerChangeLeaseResponse> changeLease(String leaseID, String proposedID) {
        return this.changeLease(leaseID, proposedID, null, null);
    }

    public Single<ContainerChangeLeaseResponse> changeLease(String leaseID, String proposedID, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        if (!this.validateNoEtag(modifiedAccessConditions)) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedContainers().changeLeaseWithRestResponseAsync(context, leaseID, proposedID, null, null, modifiedAccessConditions));
    }

    public Single<ContainerListBlobFlatSegmentResponse> listBlobsFlatSegment(String marker, ListBlobsOptions options) {
        return this.listBlobsFlatSegment(marker, options, null);
    }

    public Single<ContainerListBlobFlatSegmentResponse> listBlobsFlatSegment(String marker, ListBlobsOptions options, Context context) {
        options = options == null ? new ListBlobsOptions() : options;
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedContainers().listBlobFlatSegmentWithRestResponseAsync(context, options.prefix(), marker, options.maxResults(), options.details().toList(), null, null));
    }

    public Single<ContainerListBlobHierarchySegmentResponse> listBlobsHierarchySegment(String marker, String delimiter, ListBlobsOptions options) {
        return this.listBlobsHierarchySegment(marker, delimiter, options, null);
    }

    public Single<ContainerListBlobHierarchySegmentResponse> listBlobsHierarchySegment(String marker, String delimiter, ListBlobsOptions options, Context context) {
        ListBlobsOptions listBlobsOptions = options = options == null ? new ListBlobsOptions() : options;
        if (options.details().snapshots()) {
            throw new UnsupportedOperationException("Including snapshots in a hierarchical listing is not supported.");
        }
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedContainers().listBlobHierarchySegmentWithRestResponseAsync(context, delimiter, options.prefix(), marker, options.maxResults(), options.details().toList(), null, null));
    }

    public Single<ContainerGetAccountInfoResponse> getAccountInfo() {
        return this.getAccountInfo(null);
    }

    public Single<ContainerGetAccountInfoResponse> getAccountInfo(Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.postProcessResponse(this.storageClient.generatedContainers().getAccountInfoWithRestResponseAsync(context));
    }
}

