/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.microsoft.azure.storage.Credentials;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageKey;
import com.microsoft.azure.storage.core.Canonicalizer;
import com.microsoft.azure.storage.core.CanonicalizerFactory;
import com.microsoft.azure.storage.core.UriQueryBuilder;
import com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;

public final class BaseRequest {
    private static final String METADATA = "metadata";
    private static final String SERVICE = "service";
    private static final String STATS = "stats";
    private static final String TIMEOUT = "timeout";
    private static String userAgent;

    public static void addLeaseId(HttpURLConnection request, String leaseId) {
        if (leaseId != null) {
            BaseRequest.addOptionalHeader(request, "x-ms-lease-id", leaseId);
        }
    }

    public static void addMetadata(HttpURLConnection request, HashMap<String, String> metadata, OperationContext opContext) {
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                BaseRequest.addMetadata(request, entry.getKey(), entry.getValue(), opContext);
            }
        }
    }

    private static void addMetadata(HttpURLConnection request, String name, String value, OperationContext opContext) {
        if (Utility.isNullOrEmptyOrWhitespace(name)) {
            throw new IllegalArgumentException("The key for one of the metadata key-value pairs is null, empty, or whitespace.");
        }
        if (Utility.isNullOrEmptyOrWhitespace(value)) {
            throw new IllegalArgumentException("The value for one of the metadata key-value pairs is null, empty, or whitespace.");
        }
        request.setRequestProperty("x-ms-meta-" + name, value);
    }

    public static void addOptionalHeader(HttpURLConnection request, String name, String value) {
        if (value != null && !value.equals("")) {
            request.setRequestProperty(name, value);
        }
    }

    public static HttpURLConnection create(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setFixedLengthStreamingMode(0);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static HttpURLConnection createURLConnection(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        URL resourceUrl = builder.addToURI(uri).toURL();
        HttpURLConnection retConnection = (HttpURLConnection)resourceUrl.openConnection();
        if (options.getTimeoutIntervalInMs() != null && options.getTimeoutIntervalInMs() != 0) {
            builder.add(TIMEOUT, String.valueOf(options.getTimeoutIntervalInMs() / 1000));
        }
        retConnection.setReadTimeout(Utility.getRemainingTimeout(options.getOperationExpiryTimeInMs()));
        retConnection.setRequestProperty("Accept", "application/xml");
        retConnection.setRequestProperty("Accept-Charset", "UTF-8");
        retConnection.setRequestProperty("Content-Type", "");
        retConnection.setRequestProperty("x-ms-version", "2014-02-14");
        retConnection.setRequestProperty("User-Agent", BaseRequest.getUserAgent());
        retConnection.setRequestProperty("x-ms-client-request-id", opContext.getClientRequestID());
        return retConnection;
    }

    public static HttpURLConnection delete(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("DELETE");
        return retConnection;
    }

    public static HttpURLConnection getProperties(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("HEAD");
        return retConnection;
    }

    public static HttpURLConnection getServiceProperties(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "properties");
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    public static HttpURLConnection getServiceStats(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", STATS);
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    public static String getUserAgent() {
        if (userAgent == null) {
            String userAgentComment = String.format(Utility.LOCALE_US, "(JavaJRE %s; %s %s)", System.getProperty("java.version"), System.getProperty("os.name").replaceAll(" ", ""), System.getProperty("os.version"));
            userAgent = String.format("%s/%s %s", "Azure-Storage", "2.0.0", userAgentComment);
        }
        return userAgent;
    }

    public static HttpURLConnection setMetadata(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", METADATA);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setFixedLengthStreamingMode(0);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static HttpURLConnection setServiceProperties(URI uri, RequestOptions options, UriQueryBuilder builder, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (builder == null) {
            builder = new UriQueryBuilder();
        }
        builder.add("comp", "properties");
        builder.add("restype", SERVICE);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, builder, opContext);
        retConnection.setDoOutput(true);
        retConnection.setRequestMethod("PUT");
        return retConnection;
    }

    public static void signRequestForBlobAndQueue(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getBlobQueueFullCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKey", credentials.getAccountName(), computedBase64Signature));
    }

    @Deprecated
    public static void signRequestForBlobAndQueueSharedKeyLite(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getBlobQueueLiteCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKeyLite", credentials.getAccountName(), computedBase64Signature));
    }

    public static void signRequestForTableSharedKey(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getTableFullCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKey", credentials.getAccountName(), computedBase64Signature));
    }

    @Deprecated
    public static void signRequestForTableSharedKeyLite(HttpURLConnection request, Credentials credentials, Long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        request.setRequestProperty("x-ms-date", Utility.getGMTTime());
        Canonicalizer canonicalizer = CanonicalizerFactory.getTableLiteCanonicalizer(request);
        String stringToSign = canonicalizer.canonicalize(request, credentials.getAccountName(), contentLength);
        String computedBase64Signature = StorageKey.computeMacSha256(credentials.getKey(), stringToSign);
        request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKeyLite", credentials.getAccountName(), computedBase64Signature));
    }

    private BaseRequest() {
    }
}

