/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.Constants;
import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.blob.BlobEncryptStream;
import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.BlobOutputStreamInternal;
import com.microsoft.azure.storage.blob.BlobRequest;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlobType;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.PageOperationType;
import com.microsoft.azure.storage.blob.PageRange;
import com.microsoft.azure.storage.blob.PageRangeDiff;
import com.microsoft.azure.storage.blob.PageRangeDiffHandler;
import com.microsoft.azure.storage.blob.PageRangeHandler;
import com.microsoft.azure.storage.core.Base64;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.RequestLocationMode;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.Utility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;

public final class CloudPageBlob
extends CloudBlob {
    public CloudPageBlob(URI blobAbsoluteUri) throws StorageException {
        this(new StorageUri(blobAbsoluteUri));
    }

    public CloudPageBlob(StorageUri blobAbsoluteUri) throws StorageException {
        this(blobAbsoluteUri, (StorageCredentials)null);
    }

    public CloudPageBlob(CloudPageBlob otherBlob) {
        super(otherBlob);
    }

    public CloudPageBlob(URI blobAbsoluteUri, StorageCredentials credentials) throws StorageException {
        this(new StorageUri(blobAbsoluteUri), credentials);
    }

    public CloudPageBlob(URI blobAbsoluteUri, String snapshotID, StorageCredentials credentials) throws StorageException {
        this(new StorageUri(blobAbsoluteUri), snapshotID, credentials);
    }

    public CloudPageBlob(StorageUri blobAbsoluteUri, StorageCredentials credentials) throws StorageException {
        this(blobAbsoluteUri, null, credentials);
    }

    public CloudPageBlob(StorageUri blobAbsoluteUri, String snapshotID, StorageCredentials credentials) throws StorageException {
        super(BlobType.PAGE_BLOB, blobAbsoluteUri, snapshotID, credentials);
    }

    protected CloudPageBlob(String blobName, String snapshotID, CloudBlobContainer container) throws URISyntaxException {
        super(BlobType.PAGE_BLOB, blobName, snapshotID, container);
    }

    @DoesServiceRequest
    public final String startCopy(CloudPageBlob sourceBlob) throws StorageException, URISyntaxException {
        return this.startCopy(sourceBlob, null, null, null, null);
    }

    @DoesServiceRequest
    public final String startCopy(CloudPageBlob sourceBlob, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        Utility.assertNotNull("sourceBlob", sourceBlob);
        return this.startCopy(sourceBlob.getQualifiedUri(), sourceAccessCondition, destinationAccessCondition, options, opContext);
    }

    @DoesServiceRequest
    public void clearPages(long offset, long length) throws StorageException {
        this.clearPages(offset, length, null, null, null);
    }

    @DoesServiceRequest
    public void clearPages(long offset, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (offset % 512L != 0L) {
            throw new IllegalArgumentException("Page start offset must be multiple of 512.");
        }
        if (length % 512L != 0L) {
            throw new IllegalArgumentException("Page blob length must be multiple of 512.");
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.PAGE_BLOB, this.blobServiceClient);
        options.assertNoEncryptionPolicyOrStrictMode();
        PageRange range = new PageRange(offset, offset + length - 1L);
        this.putPagesInternal(range, PageOperationType.CLEAR, null, length, null, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    public void create(long length) throws StorageException {
        this.create(length, null, null, null);
    }

    @DoesServiceRequest
    public void create(long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (length % 512L != 0L) {
            throw new IllegalArgumentException("Page blob length must be multiple of 512.");
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.PAGE_BLOB, this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.createImpl(length, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> createImpl(final long length, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.putBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.properties, BlobType.PAGE_BLOB, length);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                BlobRequest.addMetadata(connection, blob.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.getProperties().setLength(length);
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public ArrayList<PageRange> downloadPageRanges() throws StorageException {
        return this.downloadPageRanges(null, null, null);
    }

    @DoesServiceRequest
    public ArrayList<PageRange> downloadPageRanges(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.PAGE_BLOB, this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadPageRangesImpl(null, null, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public List<PageRange> downloadPageRanges(long offset, Long length) throws StorageException {
        return this.downloadPageRanges(offset, length, null, null, null);
    }

    @DoesServiceRequest
    public List<PageRange> downloadPageRanges(long offset, Long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (offset < 0L || length != null && length <= 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.PAGE_BLOB, this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadPageRangesImpl(offset, length, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, ArrayList<PageRange>> downloadPageRangesImpl(final Long offset, final Long length, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, ArrayList<PageRange>> getRequest = new StorageRequest<CloudBlobClient, CloudBlob, ArrayList<PageRange>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.getPageRanges(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.snapshotID, offset, length);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public ArrayList<PageRange> preProcessResponse(CloudBlob parentObject, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ArrayList<PageRange> postProcessResponse(HttpURLConnection connection, CloudBlob blob, CloudBlobClient client, OperationContext context, ArrayList<PageRange> storageObject) throws Exception {
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.updateLengthFromResponse(this.getConnection());
                return PageRangeHandler.getPageRanges(this.getConnection().getInputStream());
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public List<PageRangeDiff> downloadPageRangesDiff(String previousSnapshot) throws StorageException {
        return this.downloadPageRangesDiff(previousSnapshot, null, null, null, null, null);
    }

    @DoesServiceRequest
    public List<PageRangeDiff> downloadPageRangesDiff(String previousSnapshot, Long offset, Long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.PAGE_BLOB, this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadPageRangesDiffImpl(previousSnapshot, offset, length, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, List<PageRangeDiff>> downloadPageRangesDiffImpl(final String previousSnapshot, final Long offset, final Long length, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, List<PageRangeDiff>> getRequest = new StorageRequest<CloudBlobClient, CloudBlob, List<PageRangeDiff>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.getPageRangesDiff(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.snapshotID, previousSnapshot, offset, length);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public List<PageRangeDiff> preProcessResponse(CloudBlob parentObject, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public List<PageRangeDiff> postProcessResponse(HttpURLConnection connection, CloudBlob blob, CloudBlobClient client, OperationContext context, List<PageRangeDiff> storageObject) throws Exception {
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.updateLengthFromResponse(this.getConnection());
                return PageRangeDiffHandler.getPageRangesDiff(this.getConnection().getInputStream());
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public BlobOutputStream openWriteExisting() throws StorageException {
        return this.openOutputStreamInternal(null, null, null, null);
    }

    @DoesServiceRequest
    public BlobOutputStream openWriteExisting(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.openOutputStreamInternal(null, null, null, null);
    }

    @DoesServiceRequest
    public BlobOutputStream openWriteNew(long length) throws StorageException {
        return this.openOutputStreamInternal(length, null, null, null);
    }

    @DoesServiceRequest
    public BlobOutputStream openWriteNew(long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.openOutputStreamInternal(length, accessCondition, options, opContext);
    }

    private BlobOutputStream openOutputStreamInternal(Long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.assertNoWriteOperationForSnapshot();
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.PAGE_BLOB, this.blobServiceClient, false);
        options.assertPolicyIfRequired();
        if (options.getStoreBlobContentMD5().booleanValue()) {
            throw new IllegalArgumentException("Blob level MD5 is not supported for page blobs.");
        }
        Cipher cipher = null;
        if (options.getEncryptionPolicy() != null) {
            cipher = options.getEncryptionPolicy().createAndSetEncryptionContext(this.getMetadata(), true);
        }
        if (length != null) {
            if (length % 512L != 0L) {
                throw new IllegalArgumentException("Page blob length must be multiple of 512.");
            }
            this.create(length, accessCondition, options, opContext);
        } else {
            if (options.getEncryptionPolicy() != null) {
                throw new IllegalArgumentException("Encryption is not supported for a blob that already exists. Please do not specify an encryption policy.");
            }
            this.downloadAttributes(accessCondition, options, opContext);
            length = this.getProperties().getLength();
        }
        if (accessCondition != null) {
            accessCondition = AccessCondition.generateLeaseCondition(accessCondition.getLeaseID());
        }
        if (options.getEncryptionPolicy() != null) {
            return new BlobEncryptStream(this, length, accessCondition, options, opContext, cipher);
        }
        return new BlobOutputStreamInternal(this, length, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private void putPagesInternal(PageRange pageRange, PageOperationType operationType, byte[] data, long length, String md5, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.putPagesImpl(pageRange, operationType, data, length, md5, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudPageBlob, Void> putPagesImpl(final PageRange pageRange, final PageOperationType operationType, final byte[] data, final long length, final String md5, final AccessCondition accessCondition, final BlobRequestOptions options, final OperationContext opContext) {
        StorageRequest<CloudBlobClient, CloudPageBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudPageBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudPageBlob blob, OperationContext context) throws Exception {
                if (operationType == PageOperationType.UPDATE) {
                    this.setSendStream(new ByteArrayInputStream(data));
                    this.setLength(length);
                }
                return BlobRequest.putPage(blob.getTransformedAddress(opContext).getUri(this.getCurrentLocation()), options, opContext, accessCondition, pageRange, operationType);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudPageBlob blob, OperationContext context) {
                if (operationType == PageOperationType.UPDATE && options.getUseTransactionalContentMD5().booleanValue()) {
                    connection.setRequestProperty("Content-MD5", md5);
                }
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                if (operationType == PageOperationType.UPDATE) {
                    StorageRequest.signBlobQueueAndFileRequest(connection, client, length, context);
                } else {
                    StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
                }
            }

            @Override
            public Void preProcessResponse(CloudPageBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.updateSequenceNumberFromResponse(this.getConnection());
                return null;
            }
        };
        return putRequest;
    }

    protected void updateSequenceNumberFromResponse(HttpURLConnection request) {
        String sequenceNumber = request.getHeaderField("x-ms-blob-sequence-number");
        if (!Utility.isNullOrEmpty(sequenceNumber)) {
            this.getProperties().setPageBlobSequenceNumber(Long.parseLong(sequenceNumber));
        }
    }

    public void resize(long size) throws StorageException {
        this.resize(size, null, null, null);
    }

    public void resize(long size, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (size % 512L != 0L) {
            throw new IllegalArgumentException("Page blob length must be multiple of 512.");
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.populateAndApplyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.resizeImpl(size, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudPageBlob, Void> resizeImpl(final long size, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudPageBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudPageBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudPageBlob blob, OperationContext context) throws Exception {
                return BlobRequest.resize(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, size);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudPageBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.getProperties().setLength(size);
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.updateSequenceNumberFromResponse(this.getConnection());
                return null;
            }
        };
        return putRequest;
    }

    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length) throws StorageException, IOException {
        this.upload(sourceStream, length, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.PAGE_BLOB, this.blobServiceClient);
        options.assertPolicyIfRequired();
        if (length <= 0L || length % 512L != 0L) {
            throw new IllegalArgumentException("Page blob length must be multiple of 512.");
        }
        if (options.getStoreBlobContentMD5().booleanValue()) {
            throw new IllegalArgumentException("Blob level MD5 is not supported for page blobs.");
        }
        if (sourceStream.markSupported()) {
            sourceStream.mark(0x4000000);
        }
        BlobOutputStream streamRef = this.openWriteNew(length, accessCondition, options, opContext);
        try {
            streamRef.write(sourceStream, length);
        }
        finally {
            streamRef.close();
        }
    }

    @DoesServiceRequest
    public void uploadPages(InputStream sourceStream, long offset, long length) throws StorageException, IOException {
        this.uploadPages(sourceStream, offset, length, null, null, null);
    }

    @DoesServiceRequest
    public void uploadPages(InputStream sourceStream, long offset, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        if (offset % 512L != 0L) {
            throw new IllegalArgumentException("Page start offset must be multiple of 512.");
        }
        if (length == 0L || length % 512L != 0L) {
            throw new IllegalArgumentException("Page blob length must be multiple of 512.");
        }
        if (length > 0x400000L) {
            throw new IllegalArgumentException("Max write size is 4MB. Please specify a smaller range.");
        }
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.populateAndApplyDefaults(options, BlobType.PAGE_BLOB, this.blobServiceClient);
        options.assertNoEncryptionPolicyOrStrictMode();
        PageRange pageRange = new PageRange(offset, offset + length - 1L);
        byte[] data = new byte[(int)length];
        String md5 = null;
        int count = 0;
        int total = 0;
        while ((long)total < length) {
            count = sourceStream.read(data, total, (int)Math.min(length - (long)total, Integer.MAX_VALUE));
            total += count;
        }
        if (options.getUseTransactionalContentMD5().booleanValue()) {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                digest.update(data, 0, data.length);
                md5 = Base64.encode(digest.digest());
            }
            catch (NoSuchAlgorithmException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        this.putPagesInternal(pageRange, PageOperationType.UPDATE, data, length, md5, accessCondition, options, opContext);
    }

    @Override
    public void setStreamWriteSizeInBytes(int streamWriteSizeInBytes) {
        if (streamWriteSizeInBytes > Constants.MAX_BLOCK_SIZE || streamWriteSizeInBytes < 512 || streamWriteSizeInBytes % 512 != 0) {
            throw new IllegalArgumentException("StreamWriteSizeInBytes");
        }
        this.streamWriteSizeInBytes = streamWriteSizeInBytes;
    }
}

