/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.boot.autoconfigure.storage;

import com.microsoft.azure.spring.boot.autoconfigure.storage.StorageProperties;
import com.microsoft.azure.storage.CloudStorageAccount;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnMissingBean(value={CloudStorageAccount.class})
@EnableConfigurationProperties(value={StorageProperties.class})
@ConditionalOnProperty(prefix="azure.storage", value={"connection-string"})
public class StorageAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(StorageAutoConfiguration.class);
    private final StorageProperties properties;

    public StorageAutoConfiguration(StorageProperties properties) {
        this.properties = properties;
    }

    @Bean
    @Scope(value="prototype")
    public CloudStorageAccount cloudStorageAccount() throws URISyntaxException, InvalidKeyException {
        LOG.debug("cloudStorageAccount called");
        return this.createCloudStorageAccount();
    }

    private CloudStorageAccount createCloudStorageAccount() throws URISyntaxException, InvalidKeyException {
        LOG.debug("createCloudStorageAccount called");
        return CloudStorageAccount.parse((String)this.properties.getConnectionString());
    }
}

