/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.DacOperations;
import com.microsoft.windowsazure.management.sql.SqlManagementClientImpl;
import com.microsoft.windowsazure.management.sql.models.DacExportParameters;
import com.microsoft.windowsazure.management.sql.models.DacGetStatusParameters;
import com.microsoft.windowsazure.management.sql.models.DacGetStatusResponse;
import com.microsoft.windowsazure.management.sql.models.DacImportExportResponse;
import com.microsoft.windowsazure.management.sql.models.DacImportParameters;
import com.microsoft.windowsazure.management.sql.models.StatusInfo;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DacOperationsImpl
implements ServiceOperations<SqlManagementClientImpl>,
DacOperations {
    private SqlManagementClientImpl client;

    DacOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }

    public SqlManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<DacImportExportResponse> exportAsync(final String serverName, final DacExportParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DacImportExportResponse>(){

            @Override
            public DacImportExportResponse call() throws Exception {
                return DacOperationsImpl.this.export(serverName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DacImportExportResponse export(String serverName, DacExportParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (parameters != null) {
            if (parameters.getBlobCredentials() != null) {
                if (parameters.getBlobCredentials().getStorageAccessKey() == null) {
                    throw new NullPointerException("parameters.BlobCredentials.StorageAccessKey");
                }
                if (parameters.getBlobCredentials().getUri() == null) {
                    throw new NullPointerException("parameters.BlobCredentials.Uri");
                }
            }
            if (parameters.getConnectionInfo() != null) {
                if (parameters.getConnectionInfo().getDatabaseName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.DatabaseName");
                }
                if (parameters.getConnectionInfo().getPassword() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.Password");
                }
                if (parameters.getConnectionInfo().getServerName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.ServerName");
                }
                if (parameters.getConnectionInfo().getUserName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.UserName");
                }
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"exportAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/DacOperations/Export";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        if (parameters != null) {
            Element exportInputElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ExportInput");
            requestDoc.appendChild(exportInputElement);
            if (parameters.getBlobCredentials() != null) {
                Element blobCredentialsElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "BlobCredentials");
                exportInputElement.appendChild(blobCredentialsElement);
                Attr typeAttribute = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                typeAttribute.setValue("BlobStorageAccessKeyCredentials");
                blobCredentialsElement.setAttributeNode(typeAttribute);
                Element uriElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "Uri");
                uriElement.appendChild(requestDoc.createTextNode(parameters.getBlobCredentials().getUri().toString()));
                blobCredentialsElement.appendChild(uriElement);
                Element storageAccessKeyElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "StorageAccessKey");
                storageAccessKeyElement.appendChild(requestDoc.createTextNode(parameters.getBlobCredentials().getStorageAccessKey()));
                blobCredentialsElement.appendChild(storageAccessKeyElement);
            }
            if (parameters.getConnectionInfo() != null) {
                Element connectionInfoElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ConnectionInfo");
                exportInputElement.appendChild(connectionInfoElement);
                Element databaseNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "DatabaseName");
                databaseNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getDatabaseName()));
                connectionInfoElement.appendChild(databaseNameElement);
                Element passwordElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "Password");
                passwordElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getPassword()));
                connectionInfoElement.appendChild(passwordElement);
                Element serverNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ServerName");
                serverNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getServerName()));
                connectionInfoElement.appendChild(serverNameElement);
                Element userNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "UserName");
                userNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getUserName()));
                connectionInfoElement.appendChild(userNameElement);
            }
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DacImportExportResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DacImportExportResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
                Element guidElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/2003/10/Serialization/", (String)"guid");
                if (guidElement != null) {
                    result.setGuid(guidElement.getTextContent());
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DacImportExportResponse dacImportExportResponse = result;
            return dacImportExportResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DacGetStatusResponse> getStatusAsync(final String serverName, final String fullyQualifiedServerName, final String username, final String password, final String requestId) {
        return this.getClient().getExecutorService().submit(new Callable<DacGetStatusResponse>(){

            @Override
            public DacGetStatusResponse call() throws Exception {
                return DacOperationsImpl.this.getStatus(serverName, fullyQualifiedServerName, username, password, requestId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DacGetStatusResponse getStatus(String serverName, String fullyQualifiedServerName, String username, String password, String requestId) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        String baseUrl;
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (fullyQualifiedServerName == null) {
            throw new NullPointerException("fullyQualifiedServerName");
        }
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (requestId == null) {
            throw new NullPointerException("requestId");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("fullyQualifiedServerName", fullyQualifiedServerName);
            tracingParameters.put("username", username);
            tracingParameters.put("password", password);
            tracingParameters.put("requestId", requestId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getStatusAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/DacOperations/Status";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("servername=" + URLEncoder.encode(fullyQualifiedServerName, "UTF-8"));
        queryParameters.add("username=" + URLEncoder.encode(username, "UTF-8"));
        queryParameters.add("password=" + URLEncoder.encode(password, "UTF-8"));
        queryParameters.add("reqId=" + URLEncoder.encode(requestId, "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DacGetStatusResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DacGetStatusResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element arrayOfStatusInfoElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"ArrayOfStatusInfo");
                if (arrayOfStatusInfoElement != null && arrayOfStatusInfoElement != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)arrayOfStatusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"StatusInfo").size(); ++i1) {
                        Element statusElement;
                        Element serverNameElement;
                        Element requestTypeElement;
                        Element requestIdElement;
                        Element queuedTimeElement;
                        Element lastModifiedTimeElement;
                        Element errorMessageElement;
                        Element databaseNameElement;
                        Element statusInfoElement = (Element)XmlUtility.getElementsByTagNameNS((Node)arrayOfStatusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"StatusInfo").get(i1);
                        StatusInfo statusInfoInstance = new StatusInfo();
                        result.getStatusInfoList().add(statusInfoInstance);
                        Element blobUriElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"BlobUri");
                        if (blobUriElement != null) {
                            URI blobUriInstance = new URI(blobUriElement.getTextContent());
                            statusInfoInstance.setBlobUri(blobUriInstance);
                        }
                        if ((databaseNameElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"DatabaseName")) != null) {
                            String databaseNameInstance = databaseNameElement.getTextContent();
                            statusInfoInstance.setDatabaseName(databaseNameInstance);
                        }
                        if ((errorMessageElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"ErrorMessage")) != null) {
                            boolean isNil = false;
                            Attr nilAttribute = errorMessageElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                            if (nilAttribute != null) {
                                isNil = "true".equals(nilAttribute.getValue());
                            }
                            if (!isNil) {
                                String errorMessageInstance = errorMessageElement.getTextContent();
                                statusInfoInstance.setErrorMessage(errorMessageInstance);
                            }
                        }
                        if ((lastModifiedTimeElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"LastModifiedTime")) != null) {
                            Calendar lastModifiedTimeInstance = DatatypeConverter.parseDateTime((String)lastModifiedTimeElement.getTextContent());
                            statusInfoInstance.setLastModifiedTime(lastModifiedTimeInstance);
                        }
                        if ((queuedTimeElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"QueuedTime")) != null) {
                            Calendar queuedTimeInstance = DatatypeConverter.parseDateTime((String)queuedTimeElement.getTextContent());
                            statusInfoInstance.setQueuedTime(queuedTimeInstance);
                        }
                        if ((requestIdElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"RequestId")) != null) {
                            String requestIdInstance = requestIdElement.getTextContent();
                            statusInfoInstance.setRequestId(requestIdInstance);
                        }
                        if ((requestTypeElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"RequestType")) != null) {
                            String requestTypeInstance = requestTypeElement.getTextContent();
                            statusInfoInstance.setRequestType(requestTypeInstance);
                        }
                        if ((serverNameElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"ServerName")) != null) {
                            String serverNameInstance = serverNameElement.getTextContent();
                            statusInfoInstance.setServerName(serverNameInstance);
                        }
                        if ((statusElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"Status")) == null) continue;
                        String statusInstance = statusElement.getTextContent();
                        statusInfoInstance.setStatus(statusInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            DacGetStatusResponse dacGetStatusResponse = result;
            return dacGetStatusResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DacGetStatusResponse> getStatusPostAsync(final String serverName, final DacGetStatusParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DacGetStatusResponse>(){

            @Override
            public DacGetStatusResponse call() throws Exception {
                return DacOperationsImpl.this.getStatusPost(serverName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DacGetStatusResponse getStatusPost(String serverName, DacGetStatusParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getPassword() == null) {
            throw new NullPointerException("parameters.Password");
        }
        if (parameters.getRequestId() == null) {
            throw new NullPointerException("parameters.RequestId");
        }
        if (parameters.getServerName() == null) {
            throw new NullPointerException("parameters.ServerName");
        }
        if (parameters.getUserName() == null) {
            throw new NullPointerException("parameters.UserName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getStatusPostAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/DacOperations/Status";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element statusInputElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "StatusInput");
        requestDoc.appendChild(statusInputElement);
        Element passwordElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "Password");
        passwordElement.appendChild(requestDoc.createTextNode(parameters.getPassword()));
        statusInputElement.appendChild(passwordElement);
        Element requestIdElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "RequestId");
        requestIdElement.appendChild(requestDoc.createTextNode(parameters.getRequestId()));
        statusInputElement.appendChild(requestIdElement);
        Element serverNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ServerName");
        serverNameElement.appendChild(requestDoc.createTextNode(parameters.getServerName()));
        statusInputElement.appendChild(serverNameElement);
        Element userNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "UserName");
        userNameElement.appendChild(requestDoc.createTextNode(parameters.getUserName()));
        statusInputElement.appendChild(userNameElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DacGetStatusResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DacGetStatusResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
                Element arrayOfStatusInfoElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"ArrayOfStatusInfo");
                if (arrayOfStatusInfoElement != null && arrayOfStatusInfoElement != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)arrayOfStatusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"StatusInfo").size(); ++i1) {
                        Element statusElement;
                        Element serverNameElement2;
                        Element requestTypeElement;
                        Element requestIdElement2;
                        Element queuedTimeElement;
                        Element lastModifiedTimeElement;
                        Element errorMessageElement;
                        Element databaseNameElement;
                        Element statusInfoElement = (Element)XmlUtility.getElementsByTagNameNS((Node)arrayOfStatusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"StatusInfo").get(i1);
                        StatusInfo statusInfoInstance = new StatusInfo();
                        result.getStatusInfoList().add(statusInfoInstance);
                        Element blobUriElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"BlobUri");
                        if (blobUriElement != null) {
                            URI blobUriInstance = new URI(blobUriElement.getTextContent());
                            statusInfoInstance.setBlobUri(blobUriInstance);
                        }
                        if ((databaseNameElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"DatabaseName")) != null) {
                            String databaseNameInstance = databaseNameElement.getTextContent();
                            statusInfoInstance.setDatabaseName(databaseNameInstance);
                        }
                        if ((errorMessageElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"ErrorMessage")) != null) {
                            boolean isNil = false;
                            Attr nilAttribute = errorMessageElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                            if (nilAttribute != null) {
                                isNil = "true".equals(nilAttribute.getValue());
                            }
                            if (!isNil) {
                                String errorMessageInstance = errorMessageElement.getTextContent();
                                statusInfoInstance.setErrorMessage(errorMessageInstance);
                            }
                        }
                        if ((lastModifiedTimeElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"LastModifiedTime")) != null) {
                            Calendar lastModifiedTimeInstance = DatatypeConverter.parseDateTime((String)lastModifiedTimeElement.getTextContent());
                            statusInfoInstance.setLastModifiedTime(lastModifiedTimeInstance);
                        }
                        if ((queuedTimeElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"QueuedTime")) != null) {
                            Calendar queuedTimeInstance = DatatypeConverter.parseDateTime((String)queuedTimeElement.getTextContent());
                            statusInfoInstance.setQueuedTime(queuedTimeInstance);
                        }
                        if ((requestIdElement2 = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"RequestId")) != null) {
                            String requestIdInstance = requestIdElement2.getTextContent();
                            statusInfoInstance.setRequestId(requestIdInstance);
                        }
                        if ((requestTypeElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"RequestType")) != null) {
                            String requestTypeInstance = requestTypeElement.getTextContent();
                            statusInfoInstance.setRequestType(requestTypeInstance);
                        }
                        if ((serverNameElement2 = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"ServerName")) != null) {
                            String serverNameInstance = serverNameElement2.getTextContent();
                            statusInfoInstance.setServerName(serverNameInstance);
                        }
                        if ((statusElement = XmlUtility.getElementByTagNameNS((Node)statusInfoElement, (String)"http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", (String)"Status")) == null) continue;
                        String statusInstance = statusElement.getTextContent();
                        statusInfoInstance.setStatus(statusInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            DacGetStatusResponse dacGetStatusResponse = result;
            return dacGetStatusResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DacImportExportResponse> importMethodAsync(final String serverName, final DacImportParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DacImportExportResponse>(){

            @Override
            public DacImportExportResponse call() throws Exception {
                return DacOperationsImpl.this.importMethod(serverName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DacImportExportResponse importMethod(String serverName, DacImportParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (parameters != null) {
            if (parameters.getBlobCredentials() != null) {
                if (parameters.getBlobCredentials().getStorageAccessKey() == null) {
                    throw new NullPointerException("parameters.BlobCredentials.StorageAccessKey");
                }
                if (parameters.getBlobCredentials().getUri() == null) {
                    throw new NullPointerException("parameters.BlobCredentials.Uri");
                }
            }
            if (parameters.getConnectionInfo() != null) {
                if (parameters.getConnectionInfo().getDatabaseName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.DatabaseName");
                }
                if (parameters.getConnectionInfo().getPassword() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.Password");
                }
                if (parameters.getConnectionInfo().getServerName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.ServerName");
                }
                if (parameters.getConnectionInfo().getUserName() == null) {
                    throw new NullPointerException("parameters.ConnectionInfo.UserName");
                }
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"importMethodAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/DacOperations/Import";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        if (parameters != null) {
            Element importInputElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ImportInput");
            requestDoc.appendChild(importInputElement);
            if (parameters.getAzureEdition() != null) {
                Element azureEditionElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "AzureEdition");
                azureEditionElement.appendChild(requestDoc.createTextNode(parameters.getAzureEdition()));
                importInputElement.appendChild(azureEditionElement);
            }
            if (parameters.getBlobCredentials() != null) {
                Element blobCredentialsElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "BlobCredentials");
                importInputElement.appendChild(blobCredentialsElement);
                Attr typeAttribute = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                typeAttribute.setValue("BlobStorageAccessKeyCredentials");
                blobCredentialsElement.setAttributeNode(typeAttribute);
                Element uriElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "Uri");
                uriElement.appendChild(requestDoc.createTextNode(parameters.getBlobCredentials().getUri().toString()));
                blobCredentialsElement.appendChild(uriElement);
                Element storageAccessKeyElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "StorageAccessKey");
                storageAccessKeyElement.appendChild(requestDoc.createTextNode(parameters.getBlobCredentials().getStorageAccessKey()));
                blobCredentialsElement.appendChild(storageAccessKeyElement);
            }
            if (parameters.getConnectionInfo() != null) {
                Element connectionInfoElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ConnectionInfo");
                importInputElement.appendChild(connectionInfoElement);
                Element databaseNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "DatabaseName");
                databaseNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getDatabaseName()));
                connectionInfoElement.appendChild(databaseNameElement);
                Element passwordElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "Password");
                passwordElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getPassword()));
                connectionInfoElement.appendChild(passwordElement);
                Element serverNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "ServerName");
                serverNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getServerName()));
                connectionInfoElement.appendChild(serverNameElement);
                Element userNameElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "UserName");
                userNameElement.appendChild(requestDoc.createTextNode(parameters.getConnectionInfo().getUserName()));
                connectionInfoElement.appendChild(userNameElement);
            }
            Element databaseSizeInGBElement = requestDoc.createElementNS("http://schemas.datacontract.org/2004/07/Microsoft.SqlServer.Management.Dac.ServiceTypes", "DatabaseSizeInGB");
            databaseSizeInGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getDatabaseSizeInGB())));
            importInputElement.appendChild(databaseSizeInGBElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DacImportExportResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DacImportExportResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
                Element guidElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/2003/10/Serialization/", (String)"guid");
                if (guidElement != null) {
                    result.setGuid(guidElement.getTextContent());
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DacImportExportResponse dacImportExportResponse = result;
            return dacImportExportResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

