/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.DatabaseCopyOperations;
import com.microsoft.windowsazure.management.sql.SqlManagementClientImpl;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopy;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyCreateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyCreateResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyGetResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyListResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyUpdateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyUpdateResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DatabaseCopyOperationsImpl
implements ServiceOperations<SqlManagementClientImpl>,
DatabaseCopyOperations {
    private SqlManagementClientImpl client;

    DatabaseCopyOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }

    public SqlManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<DatabaseCopyCreateResponse> createAsync(final String serverName, final String databaseName, final DatabaseCopyCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseCopyCreateResponse>(){

            @Override
            public DatabaseCopyCreateResponse call() throws Exception {
                return DatabaseCopyOperationsImpl.this.create(serverName, databaseName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseCopyCreateResponse create(String serverName, String databaseName, DatabaseCopyCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getPartnerDatabase() == null) {
            throw new NullPointerException("parameters.PartnerDatabase");
        }
        if (parameters.getPartnerServer() == null) {
            throw new NullPointerException("parameters.PartnerServer");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/databasecopies";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element serviceResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceResource");
        requestDoc.appendChild(serviceResourceElement);
        Element partnerServerElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PartnerServer");
        partnerServerElement.appendChild(requestDoc.createTextNode(parameters.getPartnerServer()));
        serviceResourceElement.appendChild(partnerServerElement);
        Element partnerDatabaseElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PartnerDatabase");
        partnerDatabaseElement.appendChild(requestDoc.createTextNode(parameters.getPartnerDatabase()));
        serviceResourceElement.appendChild(partnerDatabaseElement);
        Element isContinuousElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsContinuous");
        isContinuousElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isContinuous()).toLowerCase()));
        serviceResourceElement.appendChild(isContinuousElement);
        Element isOfflineSecondaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsOfflineSecondary");
        isOfflineSecondaryElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isOfflineSecondary()).toLowerCase()));
        serviceResourceElement.appendChild(isOfflineSecondaryElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 201) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseCopyCreateResponse result = null;
            if (statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseCopyCreateResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourceElement2 = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
                if (serviceResourceElement2 != null) {
                    Element stateElement;
                    Element typeElement;
                    Element nameElement;
                    Element isTerminationAllowedElement;
                    Element isOfflineSecondaryElement2;
                    Element percentCompleteElement;
                    Element modifyDateElement;
                    Element startDateElement;
                    Element isInterlinkConnectedElement;
                    Element isLocalDatabaseReplicationTargetElement;
                    Element localDatabaseIdElement;
                    Element replicationStateDescriptionElement;
                    Element replicationStateElement;
                    Element isContinuousElement2;
                    Element destinationDatabaseNameElement;
                    Element destinationServerNameElement;
                    Element sourceDatabaseNameElement;
                    DatabaseCopy serviceResourceInstance = new DatabaseCopy();
                    result.setDatabaseCopy(serviceResourceInstance);
                    Element sourceServerNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceServerName");
                    if (sourceServerNameElement != null) {
                        String sourceServerNameInstance = sourceServerNameElement.getTextContent();
                        serviceResourceInstance.setSourceServerName(sourceServerNameInstance);
                    }
                    if ((sourceDatabaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceDatabaseName")) != null) {
                        String sourceDatabaseNameInstance = sourceDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setSourceDatabaseName(sourceDatabaseNameInstance);
                    }
                    if ((destinationServerNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"DestinationServerName")) != null) {
                        String destinationServerNameInstance = destinationServerNameElement.getTextContent();
                        serviceResourceInstance.setDestinationServerName(destinationServerNameInstance);
                    }
                    if ((destinationDatabaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"DestinationDatabaseName")) != null) {
                        String destinationDatabaseNameInstance = destinationDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setDestinationDatabaseName(destinationDatabaseNameInstance);
                    }
                    if ((isContinuousElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsContinuous")) != null) {
                        boolean isContinuousInstance = DatatypeConverter.parseBoolean((String)isContinuousElement2.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsContinuous(isContinuousInstance);
                    }
                    if ((replicationStateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationState")) != null) {
                        byte replicationStateInstance = DatatypeConverter.parseByte((String)replicationStateElement.getTextContent());
                        serviceResourceInstance.setReplicationState(replicationStateInstance);
                    }
                    if ((replicationStateDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationStateDescription")) != null) {
                        String replicationStateDescriptionInstance = replicationStateDescriptionElement.getTextContent();
                        serviceResourceInstance.setReplicationStateDescription(replicationStateDescriptionInstance);
                    }
                    if ((localDatabaseIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalDatabaseId")) != null) {
                        int localDatabaseIdInstance = DatatypeConverter.parseInt((String)localDatabaseIdElement.getTextContent());
                        serviceResourceInstance.setLocalDatabaseId(localDatabaseIdInstance);
                    }
                    if ((isLocalDatabaseReplicationTargetElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsLocalDatabaseReplicationTarget")) != null) {
                        boolean isLocalDatabaseReplicationTargetInstance = DatatypeConverter.parseBoolean((String)isLocalDatabaseReplicationTargetElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsLocalDatabaseReplicationTarget(isLocalDatabaseReplicationTargetInstance);
                    }
                    if ((isInterlinkConnectedElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsInterlinkConnected")) != null) {
                        boolean isInterlinkConnectedInstance = DatatypeConverter.parseBoolean((String)isInterlinkConnectedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsInterlinkConnected(isInterlinkConnectedInstance);
                    }
                    if ((startDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartDate")) != null) {
                        String startDateInstance = startDateElement.getTextContent();
                        serviceResourceInstance.setStartDate(startDateInstance);
                    }
                    if ((modifyDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ModifyDate")) != null) {
                        String modifyDateInstance = modifyDateElement.getTextContent();
                        serviceResourceInstance.setModifyDate(modifyDateInstance);
                    }
                    if ((percentCompleteElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PercentComplete")) != null) {
                        float percentCompleteInstance = DatatypeConverter.parseFloat((String)percentCompleteElement.getTextContent());
                        serviceResourceInstance.setPercentComplete(percentCompleteInstance);
                    }
                    if ((isOfflineSecondaryElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsOfflineSecondary")) != null) {
                        boolean isOfflineSecondaryInstance = DatatypeConverter.parseBoolean((String)isOfflineSecondaryElement2.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsOfflineSecondary(isOfflineSecondaryInstance);
                    }
                    if ((isTerminationAllowedElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsTerminationAllowed")) != null) {
                        boolean isTerminationAllowedInstance = DatatypeConverter.parseBoolean((String)isTerminationAllowedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsTerminationAllowed(isTerminationAllowedInstance);
                    }
                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DatabaseCopyCreateResponse databaseCopyCreateResponse = result;
            return databaseCopyCreateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String serverName, final String databaseName, final String databaseCopyName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return DatabaseCopyOperationsImpl.this.delete(serverName, databaseName, databaseCopyName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String serverName, String databaseName, String databaseCopyName) throws IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (databaseCopyName == null) {
            throw new NullPointerException("databaseCopyName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("databaseCopyName", databaseCopyName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/databasecopies/";
        url = url + URLEncoder.encode(databaseCopyName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DatabaseCopyGetResponse> getAsync(final String serverName, final String databaseName, final String databaseCopyName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseCopyGetResponse>(){

            @Override
            public DatabaseCopyGetResponse call() throws Exception {
                return DatabaseCopyOperationsImpl.this.get(serverName, databaseName, databaseCopyName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseCopyGetResponse get(String serverName, String databaseName, String databaseCopyName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (databaseCopyName == null) {
            throw new NullPointerException("databaseCopyName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("databaseCopyName", databaseCopyName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/databasecopies/";
        url = url + URLEncoder.encode(databaseCopyName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseCopyGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseCopyGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
                if (serviceResourceElement != null) {
                    Element stateElement;
                    Element typeElement;
                    Element nameElement;
                    Element isTerminationAllowedElement;
                    Element isOfflineSecondaryElement;
                    Element percentCompleteElement;
                    Element modifyDateElement;
                    Element startDateElement;
                    Element isInterlinkConnectedElement;
                    Element isLocalDatabaseReplicationTargetElement;
                    Element localDatabaseIdElement;
                    Element replicationStateDescriptionElement;
                    Element replicationStateElement;
                    Element isContinuousElement;
                    Element destinationDatabaseNameElement;
                    Element destinationServerNameElement;
                    Element sourceDatabaseNameElement;
                    DatabaseCopy serviceResourceInstance = new DatabaseCopy();
                    result.setDatabaseCopy(serviceResourceInstance);
                    Element sourceServerNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceServerName");
                    if (sourceServerNameElement != null) {
                        String sourceServerNameInstance = sourceServerNameElement.getTextContent();
                        serviceResourceInstance.setSourceServerName(sourceServerNameInstance);
                    }
                    if ((sourceDatabaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceDatabaseName")) != null) {
                        String sourceDatabaseNameInstance = sourceDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setSourceDatabaseName(sourceDatabaseNameInstance);
                    }
                    if ((destinationServerNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DestinationServerName")) != null) {
                        String destinationServerNameInstance = destinationServerNameElement.getTextContent();
                        serviceResourceInstance.setDestinationServerName(destinationServerNameInstance);
                    }
                    if ((destinationDatabaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DestinationDatabaseName")) != null) {
                        String destinationDatabaseNameInstance = destinationDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setDestinationDatabaseName(destinationDatabaseNameInstance);
                    }
                    if ((isContinuousElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsContinuous")) != null) {
                        boolean isContinuousInstance = DatatypeConverter.parseBoolean((String)isContinuousElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsContinuous(isContinuousInstance);
                    }
                    if ((replicationStateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationState")) != null) {
                        byte replicationStateInstance = DatatypeConverter.parseByte((String)replicationStateElement.getTextContent());
                        serviceResourceInstance.setReplicationState(replicationStateInstance);
                    }
                    if ((replicationStateDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationStateDescription")) != null) {
                        String replicationStateDescriptionInstance = replicationStateDescriptionElement.getTextContent();
                        serviceResourceInstance.setReplicationStateDescription(replicationStateDescriptionInstance);
                    }
                    if ((localDatabaseIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalDatabaseId")) != null) {
                        int localDatabaseIdInstance = DatatypeConverter.parseInt((String)localDatabaseIdElement.getTextContent());
                        serviceResourceInstance.setLocalDatabaseId(localDatabaseIdInstance);
                    }
                    if ((isLocalDatabaseReplicationTargetElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsLocalDatabaseReplicationTarget")) != null) {
                        boolean isLocalDatabaseReplicationTargetInstance = DatatypeConverter.parseBoolean((String)isLocalDatabaseReplicationTargetElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsLocalDatabaseReplicationTarget(isLocalDatabaseReplicationTargetInstance);
                    }
                    if ((isInterlinkConnectedElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsInterlinkConnected")) != null) {
                        boolean isInterlinkConnectedInstance = DatatypeConverter.parseBoolean((String)isInterlinkConnectedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsInterlinkConnected(isInterlinkConnectedInstance);
                    }
                    if ((startDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartDate")) != null) {
                        String startDateInstance = startDateElement.getTextContent();
                        serviceResourceInstance.setStartDate(startDateInstance);
                    }
                    if ((modifyDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ModifyDate")) != null) {
                        String modifyDateInstance = modifyDateElement.getTextContent();
                        serviceResourceInstance.setModifyDate(modifyDateInstance);
                    }
                    if ((percentCompleteElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PercentComplete")) != null) {
                        float percentCompleteInstance = DatatypeConverter.parseFloat((String)percentCompleteElement.getTextContent());
                        serviceResourceInstance.setPercentComplete(percentCompleteInstance);
                    }
                    if ((isOfflineSecondaryElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsOfflineSecondary")) != null) {
                        boolean isOfflineSecondaryInstance = DatatypeConverter.parseBoolean((String)isOfflineSecondaryElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsOfflineSecondary(isOfflineSecondaryInstance);
                    }
                    if ((isTerminationAllowedElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsTerminationAllowed")) != null) {
                        boolean isTerminationAllowedInstance = DatatypeConverter.parseBoolean((String)isTerminationAllowedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsTerminationAllowed(isTerminationAllowedInstance);
                    }
                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DatabaseCopyGetResponse databaseCopyGetResponse = result;
            return databaseCopyGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DatabaseCopyListResponse> listAsync(final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseCopyListResponse>(){

            @Override
            public DatabaseCopyListResponse call() throws Exception {
                return DatabaseCopyOperationsImpl.this.list(serverName, databaseName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseCopyListResponse list(String serverName, String databaseName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/databasecopies";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseCopyListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseCopyListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResources");
                if (serviceResourcesSequenceElement != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").size(); ++i1) {
                        Element stateElement;
                        Element typeElement;
                        Element nameElement;
                        Element isTerminationAllowedElement;
                        Element isOfflineSecondaryElement;
                        Element percentCompleteElement;
                        Element modifyDateElement;
                        Element startDateElement;
                        Element isInterlinkConnectedElement;
                        Element isLocalDatabaseReplicationTargetElement;
                        Element localDatabaseIdElement;
                        Element replicationStateDescriptionElement;
                        Element replicationStateElement;
                        Element isContinuousElement;
                        Element destinationDatabaseNameElement;
                        Element destinationServerNameElement;
                        Element sourceDatabaseNameElement;
                        Element serviceResourcesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").get(i1);
                        DatabaseCopy serviceResourceInstance = new DatabaseCopy();
                        result.getDatabaseCopies().add(serviceResourceInstance);
                        Element sourceServerNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceServerName");
                        if (sourceServerNameElement != null) {
                            String sourceServerNameInstance = sourceServerNameElement.getTextContent();
                            serviceResourceInstance.setSourceServerName(sourceServerNameInstance);
                        }
                        if ((sourceDatabaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceDatabaseName")) != null) {
                            String sourceDatabaseNameInstance = sourceDatabaseNameElement.getTextContent();
                            serviceResourceInstance.setSourceDatabaseName(sourceDatabaseNameInstance);
                        }
                        if ((destinationServerNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DestinationServerName")) != null) {
                            String destinationServerNameInstance = destinationServerNameElement.getTextContent();
                            serviceResourceInstance.setDestinationServerName(destinationServerNameInstance);
                        }
                        if ((destinationDatabaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DestinationDatabaseName")) != null) {
                            String destinationDatabaseNameInstance = destinationDatabaseNameElement.getTextContent();
                            serviceResourceInstance.setDestinationDatabaseName(destinationDatabaseNameInstance);
                        }
                        if ((isContinuousElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsContinuous")) != null) {
                            boolean isContinuousInstance = DatatypeConverter.parseBoolean((String)isContinuousElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsContinuous(isContinuousInstance);
                        }
                        if ((replicationStateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationState")) != null) {
                            byte replicationStateInstance = DatatypeConverter.parseByte((String)replicationStateElement.getTextContent());
                            serviceResourceInstance.setReplicationState(replicationStateInstance);
                        }
                        if ((replicationStateDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationStateDescription")) != null) {
                            String replicationStateDescriptionInstance = replicationStateDescriptionElement.getTextContent();
                            serviceResourceInstance.setReplicationStateDescription(replicationStateDescriptionInstance);
                        }
                        if ((localDatabaseIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalDatabaseId")) != null) {
                            int localDatabaseIdInstance = DatatypeConverter.parseInt((String)localDatabaseIdElement.getTextContent());
                            serviceResourceInstance.setLocalDatabaseId(localDatabaseIdInstance);
                        }
                        if ((isLocalDatabaseReplicationTargetElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsLocalDatabaseReplicationTarget")) != null) {
                            boolean isLocalDatabaseReplicationTargetInstance = DatatypeConverter.parseBoolean((String)isLocalDatabaseReplicationTargetElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsLocalDatabaseReplicationTarget(isLocalDatabaseReplicationTargetInstance);
                        }
                        if ((isInterlinkConnectedElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsInterlinkConnected")) != null) {
                            boolean isInterlinkConnectedInstance = DatatypeConverter.parseBoolean((String)isInterlinkConnectedElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsInterlinkConnected(isInterlinkConnectedInstance);
                        }
                        if ((startDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartDate")) != null) {
                            String startDateInstance = startDateElement.getTextContent();
                            serviceResourceInstance.setStartDate(startDateInstance);
                        }
                        if ((modifyDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ModifyDate")) != null) {
                            String modifyDateInstance = modifyDateElement.getTextContent();
                            serviceResourceInstance.setModifyDate(modifyDateInstance);
                        }
                        if ((percentCompleteElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"PercentComplete")) != null) {
                            float percentCompleteInstance = DatatypeConverter.parseFloat((String)percentCompleteElement.getTextContent());
                            serviceResourceInstance.setPercentComplete(percentCompleteInstance);
                        }
                        if ((isOfflineSecondaryElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsOfflineSecondary")) != null) {
                            boolean isOfflineSecondaryInstance = DatatypeConverter.parseBoolean((String)isOfflineSecondaryElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsOfflineSecondary(isOfflineSecondaryInstance);
                        }
                        if ((isTerminationAllowedElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsTerminationAllowed")) != null) {
                            boolean isTerminationAllowedInstance = DatatypeConverter.parseBoolean((String)isTerminationAllowedElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsTerminationAllowed(isTerminationAllowedInstance);
                        }
                        if ((nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                            String nameInstance = nameElement.getTextContent();
                            serviceResourceInstance.setName(nameInstance);
                        }
                        if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                            String typeInstance = typeElement.getTextContent();
                            serviceResourceInstance.setType(typeInstance);
                        }
                        if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) == null) continue;
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            DatabaseCopyListResponse databaseCopyListResponse = result;
            return databaseCopyListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DatabaseCopyUpdateResponse> updateAsync(final String serverName, final String databaseName, final String databaseCopyName, final DatabaseCopyUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseCopyUpdateResponse>(){

            @Override
            public DatabaseCopyUpdateResponse call() throws Exception {
                return DatabaseCopyOperationsImpl.this.update(serverName, databaseName, databaseCopyName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseCopyUpdateResponse update(String serverName, String databaseName, String databaseCopyName, DatabaseCopyUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (databaseCopyName == null) {
            throw new NullPointerException("databaseCopyName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("databaseCopyName", databaseCopyName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/databasecopies/";
        url = url + URLEncoder.encode(databaseCopyName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element serviceResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceResource");
        requestDoc.appendChild(serviceResourceElement);
        if (parameters.isForcedTerminate() != null) {
            Element isForcedTerminateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsForcedTerminate");
            isForcedTerminateElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isForcedTerminate()).toLowerCase()));
            serviceResourceElement.appendChild(isForcedTerminateElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DatabaseCopyUpdateResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseCopyUpdateResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourceElement2 = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
                if (serviceResourceElement2 != null) {
                    Element stateElement;
                    Element typeElement;
                    Element nameElement;
                    Element isTerminationAllowedElement;
                    Element isOfflineSecondaryElement;
                    Element percentCompleteElement;
                    Element modifyDateElement;
                    Element startDateElement;
                    Element isInterlinkConnectedElement;
                    Element isLocalDatabaseReplicationTargetElement;
                    Element localDatabaseIdElement;
                    Element replicationStateDescriptionElement;
                    Element replicationStateElement;
                    Element isContinuousElement;
                    Element destinationDatabaseNameElement;
                    Element destinationServerNameElement;
                    Element sourceDatabaseNameElement;
                    DatabaseCopy serviceResourceInstance = new DatabaseCopy();
                    result.setDatabaseCopy(serviceResourceInstance);
                    Element sourceServerNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceServerName");
                    if (sourceServerNameElement != null) {
                        String sourceServerNameInstance = sourceServerNameElement.getTextContent();
                        serviceResourceInstance.setSourceServerName(sourceServerNameInstance);
                    }
                    if ((sourceDatabaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceDatabaseName")) != null) {
                        String sourceDatabaseNameInstance = sourceDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setSourceDatabaseName(sourceDatabaseNameInstance);
                    }
                    if ((destinationServerNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"DestinationServerName")) != null) {
                        String destinationServerNameInstance = destinationServerNameElement.getTextContent();
                        serviceResourceInstance.setDestinationServerName(destinationServerNameInstance);
                    }
                    if ((destinationDatabaseNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"DestinationDatabaseName")) != null) {
                        String destinationDatabaseNameInstance = destinationDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setDestinationDatabaseName(destinationDatabaseNameInstance);
                    }
                    if ((isContinuousElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsContinuous")) != null) {
                        boolean isContinuousInstance = DatatypeConverter.parseBoolean((String)isContinuousElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsContinuous(isContinuousInstance);
                    }
                    if ((replicationStateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationState")) != null) {
                        byte replicationStateInstance = DatatypeConverter.parseByte((String)replicationStateElement.getTextContent());
                        serviceResourceInstance.setReplicationState(replicationStateInstance);
                    }
                    if ((replicationStateDescriptionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ReplicationStateDescription")) != null) {
                        String replicationStateDescriptionInstance = replicationStateDescriptionElement.getTextContent();
                        serviceResourceInstance.setReplicationStateDescription(replicationStateDescriptionInstance);
                    }
                    if ((localDatabaseIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"LocalDatabaseId")) != null) {
                        int localDatabaseIdInstance = DatatypeConverter.parseInt((String)localDatabaseIdElement.getTextContent());
                        serviceResourceInstance.setLocalDatabaseId(localDatabaseIdInstance);
                    }
                    if ((isLocalDatabaseReplicationTargetElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsLocalDatabaseReplicationTarget")) != null) {
                        boolean isLocalDatabaseReplicationTargetInstance = DatatypeConverter.parseBoolean((String)isLocalDatabaseReplicationTargetElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsLocalDatabaseReplicationTarget(isLocalDatabaseReplicationTargetInstance);
                    }
                    if ((isInterlinkConnectedElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsInterlinkConnected")) != null) {
                        boolean isInterlinkConnectedInstance = DatatypeConverter.parseBoolean((String)isInterlinkConnectedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsInterlinkConnected(isInterlinkConnectedInstance);
                    }
                    if ((startDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartDate")) != null) {
                        String startDateInstance = startDateElement.getTextContent();
                        serviceResourceInstance.setStartDate(startDateInstance);
                    }
                    if ((modifyDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"ModifyDate")) != null) {
                        String modifyDateInstance = modifyDateElement.getTextContent();
                        serviceResourceInstance.setModifyDate(modifyDateInstance);
                    }
                    if ((percentCompleteElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"PercentComplete")) != null) {
                        float percentCompleteInstance = DatatypeConverter.parseFloat((String)percentCompleteElement.getTextContent());
                        serviceResourceInstance.setPercentComplete(percentCompleteInstance);
                    }
                    if ((isOfflineSecondaryElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsOfflineSecondary")) != null) {
                        boolean isOfflineSecondaryInstance = DatatypeConverter.parseBoolean((String)isOfflineSecondaryElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsOfflineSecondary(isOfflineSecondaryInstance);
                    }
                    if ((isTerminationAllowedElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsTerminationAllowed")) != null) {
                        boolean isTerminationAllowedInstance = DatatypeConverter.parseBoolean((String)isTerminationAllowedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsTerminationAllowed(isTerminationAllowedInstance);
                    }
                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DatabaseCopyUpdateResponse databaseCopyUpdateResponse = result;
            return databaseCopyUpdateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

