/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.FirewallRuleOperations;
import com.microsoft.windowsazure.management.sql.SqlManagementClientImpl;
import com.microsoft.windowsazure.management.sql.models.FirewallRule;
import com.microsoft.windowsazure.management.sql.models.FirewallRuleCreateParameters;
import com.microsoft.windowsazure.management.sql.models.FirewallRuleCreateResponse;
import com.microsoft.windowsazure.management.sql.models.FirewallRuleGetResponse;
import com.microsoft.windowsazure.management.sql.models.FirewallRuleListResponse;
import com.microsoft.windowsazure.management.sql.models.FirewallRuleUpdateParameters;
import com.microsoft.windowsazure.management.sql.models.FirewallRuleUpdateResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FirewallRuleOperationsImpl
implements ServiceOperations<SqlManagementClientImpl>,
FirewallRuleOperations {
    private SqlManagementClientImpl client;

    FirewallRuleOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }

    public SqlManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<FirewallRuleCreateResponse> createAsync(final String serverName, final FirewallRuleCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<FirewallRuleCreateResponse>(){

            @Override
            public FirewallRuleCreateResponse call() throws Exception {
                return FirewallRuleOperationsImpl.this.create(serverName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FirewallRuleCreateResponse create(String serverName, FirewallRuleCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getEndIPAddress() == null) {
            throw new NullPointerException("parameters.EndIPAddress");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        if (parameters.getStartIPAddress() == null) {
            throw new NullPointerException("parameters.StartIPAddress");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/firewallrules";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element serviceResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceResource");
        requestDoc.appendChild(serviceResourceElement);
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        serviceResourceElement.appendChild(nameElement);
        Element startIPAddressElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StartIPAddress");
        startIPAddressElement.appendChild(requestDoc.createTextNode(parameters.getStartIPAddress().getHostAddress()));
        serviceResourceElement.appendChild(startIPAddressElement);
        Element endIPAddressElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EndIPAddress");
        endIPAddressElement.appendChild(requestDoc.createTextNode(parameters.getEndIPAddress().getHostAddress()));
        serviceResourceElement.appendChild(endIPAddressElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 201) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            FirewallRuleCreateResponse result = null;
            if (statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new FirewallRuleCreateResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourceElement2 = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
                if (serviceResourceElement2 != null) {
                    Element stateElement;
                    Element typeElement;
                    Element nameElement2;
                    Element endIPAddressElement2;
                    FirewallRule serviceResourceInstance = new FirewallRule();
                    result.setFirewallRule(serviceResourceInstance);
                    Element startIPAddressElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartIPAddress");
                    if (startIPAddressElement2 != null) {
                        InetAddress startIPAddressInstance = InetAddress.getByName(startIPAddressElement2.getTextContent());
                        serviceResourceInstance.setStartIPAddress(startIPAddressInstance);
                    }
                    if ((endIPAddressElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"EndIPAddress")) != null) {
                        InetAddress endIPAddressInstance = InetAddress.getByName(endIPAddressElement2.getTextContent());
                        serviceResourceInstance.setEndIPAddress(endIPAddressInstance);
                    }
                    if ((nameElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement2.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            FirewallRuleCreateResponse firewallRuleCreateResponse = result;
            return firewallRuleCreateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String serverName, final String ruleName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return FirewallRuleOperationsImpl.this.delete(serverName, ruleName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String serverName, String ruleName) throws IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (ruleName == null) {
            throw new NullPointerException("ruleName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("ruleName", ruleName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/firewallrules/";
        url = url + URLEncoder.encode(ruleName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<FirewallRuleGetResponse> getAsync(final String serverName, final String ruleName) {
        return this.getClient().getExecutorService().submit(new Callable<FirewallRuleGetResponse>(){

            @Override
            public FirewallRuleGetResponse call() throws Exception {
                return FirewallRuleOperationsImpl.this.get(serverName, ruleName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FirewallRuleGetResponse get(String serverName, String ruleName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (ruleName == null) {
            throw new NullPointerException("ruleName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("ruleName", ruleName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/firewallrules/";
        url = url + URLEncoder.encode(ruleName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            FirewallRuleGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new FirewallRuleGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
                if (serviceResourceElement != null) {
                    Element stateElement;
                    Element typeElement;
                    Element nameElement;
                    Element endIPAddressElement;
                    FirewallRule serviceResourceInstance = new FirewallRule();
                    result.setFirewallRule(serviceResourceInstance);
                    Element startIPAddressElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartIPAddress");
                    if (startIPAddressElement != null) {
                        InetAddress startIPAddressInstance = InetAddress.getByName(startIPAddressElement.getTextContent());
                        serviceResourceInstance.setStartIPAddress(startIPAddressInstance);
                    }
                    if ((endIPAddressElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EndIPAddress")) != null) {
                        InetAddress endIPAddressInstance = InetAddress.getByName(endIPAddressElement.getTextContent());
                        serviceResourceInstance.setEndIPAddress(endIPAddressInstance);
                    }
                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            FirewallRuleGetResponse firewallRuleGetResponse = result;
            return firewallRuleGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<FirewallRuleListResponse> listAsync(final String serverName) {
        return this.getClient().getExecutorService().submit(new Callable<FirewallRuleListResponse>(){

            @Override
            public FirewallRuleListResponse call() throws Exception {
                return FirewallRuleOperationsImpl.this.list(serverName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FirewallRuleListResponse list(String serverName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/firewallrules";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            FirewallRuleListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new FirewallRuleListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResources");
                if (serviceResourcesSequenceElement != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").size(); ++i1) {
                        Element stateElement;
                        Element typeElement;
                        Element nameElement;
                        Element endIPAddressElement;
                        Element serviceResourcesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").get(i1);
                        FirewallRule serviceResourceInstance = new FirewallRule();
                        result.getFirewallRules().add(serviceResourceInstance);
                        Element startIPAddressElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartIPAddress");
                        if (startIPAddressElement != null) {
                            InetAddress startIPAddressInstance = InetAddress.getByName(startIPAddressElement.getTextContent());
                            serviceResourceInstance.setStartIPAddress(startIPAddressInstance);
                        }
                        if ((endIPAddressElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EndIPAddress")) != null) {
                            InetAddress endIPAddressInstance = InetAddress.getByName(endIPAddressElement.getTextContent());
                            serviceResourceInstance.setEndIPAddress(endIPAddressInstance);
                        }
                        if ((nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                            String nameInstance = nameElement.getTextContent();
                            serviceResourceInstance.setName(nameInstance);
                        }
                        if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                            String typeInstance = typeElement.getTextContent();
                            serviceResourceInstance.setType(typeInstance);
                        }
                        if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) == null) continue;
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            FirewallRuleListResponse firewallRuleListResponse = result;
            return firewallRuleListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<FirewallRuleUpdateResponse> updateAsync(final String serverName, final String ruleName, final FirewallRuleUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<FirewallRuleUpdateResponse>(){

            @Override
            public FirewallRuleUpdateResponse call() throws Exception {
                return FirewallRuleOperationsImpl.this.update(serverName, ruleName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FirewallRuleUpdateResponse update(String serverName, String ruleName, FirewallRuleUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (ruleName == null) {
            throw new NullPointerException("ruleName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getEndIPAddress() == null) {
            throw new NullPointerException("parameters.EndIPAddress");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        if (parameters.getStartIPAddress() == null) {
            throw new NullPointerException("parameters.StartIPAddress");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("ruleName", ruleName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/firewallrules/";
        url = url + URLEncoder.encode(ruleName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element serviceResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceResource");
        requestDoc.appendChild(serviceResourceElement);
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        serviceResourceElement.appendChild(nameElement);
        Element startIPAddressElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StartIPAddress");
        startIPAddressElement.appendChild(requestDoc.createTextNode(parameters.getStartIPAddress().getHostAddress()));
        serviceResourceElement.appendChild(startIPAddressElement);
        Element endIPAddressElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "EndIPAddress");
        endIPAddressElement.appendChild(requestDoc.createTextNode(parameters.getEndIPAddress().getHostAddress()));
        serviceResourceElement.appendChild(endIPAddressElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            FirewallRuleUpdateResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new FirewallRuleUpdateResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourceElement2 = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
                if (serviceResourceElement2 != null) {
                    Element stateElement;
                    Element typeElement;
                    Element nameElement2;
                    Element endIPAddressElement2;
                    FirewallRule serviceResourceInstance = new FirewallRule();
                    result.setFirewallRule(serviceResourceInstance);
                    Element startIPAddressElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"StartIPAddress");
                    if (startIPAddressElement2 != null) {
                        InetAddress startIPAddressInstance = InetAddress.getByName(startIPAddressElement2.getTextContent());
                        serviceResourceInstance.setStartIPAddress(startIPAddressInstance);
                    }
                    if ((endIPAddressElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"EndIPAddress")) != null) {
                        InetAddress endIPAddressInstance = InetAddress.getByName(endIPAddressElement2.getTextContent());
                        serviceResourceInstance.setEndIPAddress(endIPAddressInstance);
                    }
                    if ((nameElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement2.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            FirewallRuleUpdateResponse firewallRuleUpdateResponse = result;
            return firewallRuleUpdateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

