/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.RecoverDatabaseOperations;
import com.microsoft.windowsazure.management.sql.SqlManagementClientImpl;
import com.microsoft.windowsazure.management.sql.models.RecoverDatabaseOperation;
import com.microsoft.windowsazure.management.sql.models.RecoverDatabaseOperationCreateParameters;
import com.microsoft.windowsazure.management.sql.models.RecoverDatabaseOperationCreateResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RecoverDatabaseOperationsImpl
implements ServiceOperations<SqlManagementClientImpl>,
RecoverDatabaseOperations {
    private SqlManagementClientImpl client;

    RecoverDatabaseOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }

    public SqlManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<RecoverDatabaseOperationCreateResponse> createAsync(final String sourceServerName, final RecoverDatabaseOperationCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<RecoverDatabaseOperationCreateResponse>(){

            @Override
            public RecoverDatabaseOperationCreateResponse call() throws Exception {
                return RecoverDatabaseOperationsImpl.this.create(sourceServerName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecoverDatabaseOperationCreateResponse create(String sourceServerName, RecoverDatabaseOperationCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (sourceServerName == null) {
            throw new NullPointerException("sourceServerName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getSourceDatabaseName() == null) {
            throw new NullPointerException("parameters.SourceDatabaseName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("sourceServerName", sourceServerName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(sourceServerName, "UTF-8");
        url = url + "/recoverdatabaseoperations";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element serviceResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceResource");
        requestDoc.appendChild(serviceResourceElement);
        Element sourceDatabaseNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SourceDatabaseName");
        sourceDatabaseNameElement.appendChild(requestDoc.createTextNode(parameters.getSourceDatabaseName()));
        serviceResourceElement.appendChild(sourceDatabaseNameElement);
        if (parameters.getTargetServerName() != null) {
            Element targetServerNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TargetServerName");
            targetServerNameElement.appendChild(requestDoc.createTextNode(parameters.getTargetServerName()));
            serviceResourceElement.appendChild(targetServerNameElement);
        }
        if (parameters.getTargetDatabaseName() != null) {
            Element targetDatabaseNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TargetDatabaseName");
            targetDatabaseNameElement.appendChild(requestDoc.createTextNode(parameters.getTargetDatabaseName()));
            serviceResourceElement.appendChild(targetDatabaseNameElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 201) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RecoverDatabaseOperationCreateResponse result = null;
            if (statusCode == 201) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RecoverDatabaseOperationCreateResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourceElement2 = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
                if (serviceResourceElement2 != null) {
                    Element stateElement;
                    Element typeElement;
                    Element nameElement;
                    Element targetDatabaseNameElement2;
                    Element targetServerNameElement2;
                    Element sourceDatabaseNameElement2;
                    RecoverDatabaseOperation serviceResourceInstance = new RecoverDatabaseOperation();
                    result.setOperation(serviceResourceInstance);
                    Element requestIDElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"RequestID");
                    if (requestIDElement != null) {
                        String requestIDInstance = requestIDElement.getTextContent();
                        serviceResourceInstance.setId(requestIDInstance);
                    }
                    if ((sourceDatabaseNameElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"SourceDatabaseName")) != null) {
                        String sourceDatabaseNameInstance = sourceDatabaseNameElement2.getTextContent();
                        serviceResourceInstance.setSourceDatabaseName(sourceDatabaseNameInstance);
                    }
                    if ((targetServerNameElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"TargetServerName")) != null) {
                        String targetServerNameInstance = targetServerNameElement2.getTextContent();
                        serviceResourceInstance.setTargetServerName(targetServerNameInstance);
                    }
                    if ((targetDatabaseNameElement2 = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"TargetDatabaseName")) != null) {
                        String targetDatabaseNameInstance = targetDatabaseNameElement2.getTextContent();
                        serviceResourceInstance.setTargetDatabaseName(targetDatabaseNameInstance);
                    }
                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement2, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RecoverDatabaseOperationCreateResponse recoverDatabaseOperationCreateResponse = result;
            return recoverDatabaseOperationCreateResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

