/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.RecoverableDatabaseOperations;
import com.microsoft.windowsazure.management.sql.SqlManagementClientImpl;
import com.microsoft.windowsazure.management.sql.models.RecoverableDatabase;
import com.microsoft.windowsazure.management.sql.models.RecoverableDatabaseGetResponse;
import com.microsoft.windowsazure.management.sql.models.RecoverableDatabaseListResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RecoverableDatabaseOperationsImpl
implements ServiceOperations<SqlManagementClientImpl>,
RecoverableDatabaseOperations {
    private SqlManagementClientImpl client;

    RecoverableDatabaseOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }

    public SqlManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<RecoverableDatabaseGetResponse> getAsync(final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<RecoverableDatabaseGetResponse>(){

            @Override
            public RecoverableDatabaseGetResponse call() throws Exception {
                return RecoverableDatabaseOperationsImpl.this.get(serverName, databaseName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecoverableDatabaseGetResponse get(String serverName, String databaseName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/recoverabledatabases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RecoverableDatabaseGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RecoverableDatabaseGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
                if (serviceResourceElement != null) {
                    Element stateElement;
                    Element typeElement;
                    Element nameElement;
                    Element lastAvailableBackupDateElement;
                    Element editionElement;
                    Element serverNameElement;
                    RecoverableDatabase serviceResourceInstance = new RecoverableDatabase();
                    result.setDatabase(serviceResourceInstance);
                    Element entityIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EntityId");
                    if (entityIdElement != null) {
                        String entityIdInstance = entityIdElement.getTextContent();
                        serviceResourceInstance.setEntityId(entityIdInstance);
                    }
                    if ((serverNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServerName")) != null) {
                        String serverNameInstance = serverNameElement.getTextContent();
                        serviceResourceInstance.setServerName(serverNameInstance);
                    }
                    if ((editionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Edition")) != null) {
                        String editionInstance = editionElement.getTextContent();
                        serviceResourceInstance.setEdition(editionInstance);
                    }
                    if ((lastAvailableBackupDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastAvailableBackupDate")) != null) {
                        Calendar lastAvailableBackupDateInstance = DatatypeConverter.parseDateTime((String)lastAvailableBackupDateElement.getTextContent());
                        serviceResourceInstance.setLastAvailableBackupDate(lastAvailableBackupDateInstance);
                    }
                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RecoverableDatabaseGetResponse recoverableDatabaseGetResponse = result;
            return recoverableDatabaseGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<RecoverableDatabaseListResponse> listAsync(final String serverName) {
        return this.getClient().getExecutorService().submit(new Callable<RecoverableDatabaseListResponse>(){

            @Override
            public RecoverableDatabaseListResponse call() throws Exception {
                return RecoverableDatabaseOperationsImpl.this.list(serverName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecoverableDatabaseListResponse list(String serverName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        String baseUrl;
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/recoverabledatabases";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("contentview=generic");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RecoverableDatabaseListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RecoverableDatabaseListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResources");
                if (serviceResourcesSequenceElement != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").size(); ++i1) {
                        Element stateElement;
                        Element typeElement;
                        Element nameElement;
                        Element lastAvailableBackupDateElement;
                        Element editionElement;
                        Element serverNameElement;
                        Element serviceResourcesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").get(i1);
                        RecoverableDatabase serviceResourceInstance = new RecoverableDatabase();
                        result.getDatabases().add(serviceResourceInstance);
                        Element entityIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EntityId");
                        if (entityIdElement != null) {
                            String entityIdInstance = entityIdElement.getTextContent();
                            serviceResourceInstance.setEntityId(entityIdInstance);
                        }
                        if ((serverNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServerName")) != null) {
                            String serverNameInstance = serverNameElement.getTextContent();
                            serviceResourceInstance.setServerName(serverNameInstance);
                        }
                        if ((editionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Edition")) != null) {
                            String editionInstance = editionElement.getTextContent();
                            serviceResourceInstance.setEdition(editionInstance);
                        }
                        if ((lastAvailableBackupDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LastAvailableBackupDate")) != null) {
                            Calendar lastAvailableBackupDateInstance = DatatypeConverter.parseDateTime((String)lastAvailableBackupDateElement.getTextContent());
                            serviceResourceInstance.setLastAvailableBackupDate(lastAvailableBackupDateInstance);
                        }
                        if ((nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                            String nameInstance = nameElement.getTextContent();
                            serviceResourceInstance.setName(nameInstance);
                        }
                        if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                            String typeInstance = typeElement.getTextContent();
                            serviceResourceInstance.setType(typeInstance);
                        }
                        if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) == null) continue;
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            RecoverableDatabaseListResponse recoverableDatabaseListResponse = result;
            return recoverableDatabaseListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

