/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.RestorableDroppedDatabaseOperations;
import com.microsoft.windowsazure.management.sql.SqlManagementClientImpl;
import com.microsoft.windowsazure.management.sql.models.RestorableDroppedDatabase;
import com.microsoft.windowsazure.management.sql.models.RestorableDroppedDatabaseGetResponse;
import com.microsoft.windowsazure.management.sql.models.RestorableDroppedDatabaseListResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RestorableDroppedDatabaseOperationsImpl
implements ServiceOperations<SqlManagementClientImpl>,
RestorableDroppedDatabaseOperations {
    private SqlManagementClientImpl client;

    RestorableDroppedDatabaseOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }

    public SqlManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<RestorableDroppedDatabaseGetResponse> getAsync(final String serverName, final String entityId) {
        return this.getClient().getExecutorService().submit(new Callable<RestorableDroppedDatabaseGetResponse>(){

            @Override
            public RestorableDroppedDatabaseGetResponse call() throws Exception {
                return RestorableDroppedDatabaseOperationsImpl.this.get(serverName, entityId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestorableDroppedDatabaseGetResponse get(String serverName, String entityId) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (entityId == null) {
            throw new NullPointerException("entityId");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("entityId", entityId);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/restorabledroppeddatabases/";
        url = url + URLEncoder.encode(entityId, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RestorableDroppedDatabaseGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RestorableDroppedDatabaseGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource");
                if (serviceResourceElement != null) {
                    Element stateElement;
                    Element typeElement;
                    Element nameElement;
                    Element recoveryPeriodStartDateElement;
                    Element deletionDateElement;
                    Element creationDateElement;
                    Element maxSizeBytesElement;
                    Element editionElement;
                    Element serverNameElement;
                    RestorableDroppedDatabase serviceResourceInstance = new RestorableDroppedDatabase();
                    result.setDatabase(serviceResourceInstance);
                    Element entityIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EntityId");
                    if (entityIdElement != null) {
                        String entityIdInstance = entityIdElement.getTextContent();
                        serviceResourceInstance.setEntityId(entityIdInstance);
                    }
                    if ((serverNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServerName")) != null) {
                        String serverNameInstance = serverNameElement.getTextContent();
                        serviceResourceInstance.setServerName(serverNameInstance);
                    }
                    if ((editionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Edition")) != null) {
                        String editionInstance = editionElement.getTextContent();
                        serviceResourceInstance.setEdition(editionInstance);
                    }
                    if ((maxSizeBytesElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxSizeBytes")) != null) {
                        long maxSizeBytesInstance = DatatypeConverter.parseLong((String)maxSizeBytesElement.getTextContent());
                        serviceResourceInstance.setMaximumDatabaseSizeInBytes(maxSizeBytesInstance);
                    }
                    if ((creationDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreationDate")) != null) {
                        Calendar creationDateInstance = DatatypeConverter.parseDateTime((String)creationDateElement.getTextContent());
                        serviceResourceInstance.setCreationDate(creationDateInstance);
                    }
                    if ((deletionDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeletionDate")) != null) {
                        Calendar deletionDateInstance = DatatypeConverter.parseDateTime((String)deletionDateElement.getTextContent());
                        serviceResourceInstance.setDeletionDate(deletionDateInstance);
                    }
                    if ((recoveryPeriodStartDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RecoveryPeriodStartDate")) != null && recoveryPeriodStartDateElement.getTextContent() != null && !recoveryPeriodStartDateElement.getTextContent().isEmpty()) {
                        Calendar recoveryPeriodStartDateInstance = DatatypeConverter.parseDateTime((String)recoveryPeriodStartDateElement.getTextContent());
                        serviceResourceInstance.setRecoveryPeriodStartDate(recoveryPeriodStartDateInstance);
                    }
                    if ((nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                        String nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                        String typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) != null) {
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            RestorableDroppedDatabaseGetResponse restorableDroppedDatabaseGetResponse = result;
            return restorableDroppedDatabaseGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<RestorableDroppedDatabaseListResponse> listAsync(final String serverName) {
        return this.getClient().getExecutorService().submit(new Callable<RestorableDroppedDatabaseListResponse>(){

            @Override
            public RestorableDroppedDatabaseListResponse call() throws Exception {
                return RestorableDroppedDatabaseOperationsImpl.this.list(serverName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestorableDroppedDatabaseListResponse list(String serverName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        String baseUrl;
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("serverName", serverName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/restorabledroppeddatabases";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("contentview=generic");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            RestorableDroppedDatabaseListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new RestorableDroppedDatabaseListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
                Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResources");
                if (serviceResourcesSequenceElement != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").size(); ++i1) {
                        Element stateElement;
                        Element typeElement;
                        Element nameElement;
                        Element recoveryPeriodStartDateElement;
                        Element deletionDateElement;
                        Element creationDateElement;
                        Element maxSizeBytesElement;
                        Element editionElement;
                        Element serverNameElement;
                        Element serviceResourcesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)serviceResourcesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceResource").get(i1);
                        RestorableDroppedDatabase serviceResourceInstance = new RestorableDroppedDatabase();
                        result.getDatabases().add(serviceResourceInstance);
                        Element entityIdElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"EntityId");
                        if (entityIdElement != null) {
                            String entityIdInstance = entityIdElement.getTextContent();
                            serviceResourceInstance.setEntityId(entityIdInstance);
                        }
                        if ((serverNameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServerName")) != null) {
                            String serverNameInstance = serverNameElement.getTextContent();
                            serviceResourceInstance.setServerName(serverNameInstance);
                        }
                        if ((editionElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Edition")) != null) {
                            String editionInstance = editionElement.getTextContent();
                            serviceResourceInstance.setEdition(editionInstance);
                        }
                        if ((maxSizeBytesElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MaxSizeBytes")) != null) {
                            long maxSizeBytesInstance = DatatypeConverter.parseLong((String)maxSizeBytesElement.getTextContent());
                            serviceResourceInstance.setMaximumDatabaseSizeInBytes(maxSizeBytesInstance);
                        }
                        if ((creationDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreationDate")) != null) {
                            Calendar creationDateInstance = DatatypeConverter.parseDateTime((String)creationDateElement.getTextContent());
                            serviceResourceInstance.setCreationDate(creationDateInstance);
                        }
                        if ((deletionDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeletionDate")) != null) {
                            Calendar deletionDateInstance = DatatypeConverter.parseDateTime((String)deletionDateElement.getTextContent());
                            serviceResourceInstance.setDeletionDate(deletionDateInstance);
                        }
                        if ((recoveryPeriodStartDateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RecoveryPeriodStartDate")) != null && recoveryPeriodStartDateElement.getTextContent() != null && !recoveryPeriodStartDateElement.getTextContent().isEmpty()) {
                            Calendar recoveryPeriodStartDateInstance = DatatypeConverter.parseDateTime((String)recoveryPeriodStartDateElement.getTextContent());
                            serviceResourceInstance.setRecoveryPeriodStartDate(recoveryPeriodStartDateInstance);
                        }
                        if ((nameElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name")) != null) {
                            String nameInstance = nameElement.getTextContent();
                            serviceResourceInstance.setName(nameInstance);
                        }
                        if ((typeElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Type")) != null) {
                            String typeInstance = typeElement.getTextContent();
                            serviceResourceInstance.setType(typeInstance);
                        }
                        if ((stateElement = XmlUtility.getElementByTagNameNS((Node)serviceResourcesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"State")) == null) continue;
                        String stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            RestorableDroppedDatabaseListResponse restorableDroppedDatabaseListResponse = result;
            return restorableDroppedDatabaseListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

