/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.applicationinsights;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent;
import com.azure.resourcemanager.applicationinsights.models.ApplicationType;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.azure.resourcemanager.resources.models.Providers;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.AzureService;
import com.microsoft.azure.toolkit.lib.SubscriptionScoped;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsEntity;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ApplicationInsights
extends SubscriptionScoped<ApplicationInsights>
implements AzureService {
    public ApplicationInsights() {
        super(ApplicationInsights::new);
    }

    private ApplicationInsights(@Nonnull List<Subscription> subscriptions) {
        super(ApplicationInsights::new, subscriptions);
    }

    public boolean exists(@Nonnull String resourceGroup, @Nonnull String name) {
        return this.exists(this.getDefaultSubscription().getId(), resourceGroup, name);
    }

    public boolean exists(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull String name) {
        try {
            return this.get(subscriptionId, resourceGroup, name) != null;
        }
        catch (ManagementException e) {
            return false;
        }
    }

    public ApplicationInsightsEntity get(@Nonnull String resourceGroup, @Nonnull String name) {
        return this.get(this.getDefaultSubscription().getId(), resourceGroup, name);
    }

    public ApplicationInsightsEntity get(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull String name) {
        return Optional.ofNullable(this.getApplicationInsightsManager(subscriptionId).components().getByResourceGroup(resourceGroup, name)).map(ApplicationInsights::getFromApplicationInsightsComponent).orElse(null);
    }

    public ApplicationInsightsEntity create(@Nonnull String resourceGroup, @Nonnull Region region, @Nonnull String name) {
        return this.create(this.getDefaultSubscription().getId(), resourceGroup, region, name);
    }

    public ApplicationInsightsEntity create(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull Region region, @Nonnull String name) {
        ApplicationInsightsComponent component = this.getApplicationInsightsManager(subscriptionId).components().define(name).withRegion(region.getName()).withExistingResourceGroup(resourceGroup).withKind("web").withApplicationType(ApplicationType.WEB).create();
        return ApplicationInsights.getFromApplicationInsightsComponent(component);
    }

    public List<ApplicationInsightsEntity> list() {
        return ((Stream)this.getSubscriptions().stream().parallel()).map(subscription -> this.getApplicationInsightsManager(subscription.getId())).flatMap(manager -> manager.components().list().stream()).map(ApplicationInsights::getFromApplicationInsightsComponent).collect(Collectors.toList());
    }

    public void delete(@Nonnull String resourceGroup, @Nonnull String name) {
        this.delete(this.getDefaultSubscription().getId(), resourceGroup, name);
    }

    public void delete(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull String name) {
        this.getApplicationInsightsManager(subscriptionId).components().deleteByResourceGroup(resourceGroup, name);
    }

    @Cacheable(cacheName="applicationinsights/{}/manager", key="$subscriptionId")
    private ApplicationInsightsManager getApplicationInsightsManager(String subscriptionId) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        String tenantId = account.getSubscription(subscriptionId).getTenantId();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogOptions logOptions = new HttpLogOptions();
        logOptions.setLogLevel(Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE));
        AzureProfile azureProfile = new AzureProfile(tenantId, subscriptionId, account.getEnvironment());
        Providers providers = ((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withHttpClient(AzureService.getDefaultHttpClient())).withPolicy(this.getUserAgentPolicy(userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId).providers();
        return ApplicationInsightsManager.configure().withHttpClient(AzureService.getDefaultHttpClient()).withLogOptions(logOptions).withPolicy(this.getUserAgentPolicy(userAgent)).withPolicy((HttpPipelinePolicy)new ProviderRegistrationPolicy(providers)).authenticate(account.getTokenCredential(subscriptionId), azureProfile);
    }

    private HttpPipelinePolicy getUserAgentPolicy(String userAgent) {
        return (httpPipelineCallContext, httpPipelineNextPolicy) -> {
            String previousUserAgent = httpPipelineCallContext.getHttpRequest().getHeaders().getValue("User-Agent");
            httpPipelineCallContext.getHttpRequest().setHeader("User-Agent", String.format("%s %s", userAgent, previousUserAgent));
            return httpPipelineNextPolicy.process();
        };
    }

    private static ApplicationInsightsEntity getFromApplicationInsightsComponent(ApplicationInsightsComponent component) {
        ResourceId resourceId = ResourceId.fromString((String)component.id());
        return ((ApplicationInsightsEntity.ApplicationInsightsEntityBuilder)((ApplicationInsightsEntity.ApplicationInsightsEntityBuilder)((ApplicationInsightsEntity.ApplicationInsightsEntityBuilder)((ApplicationInsightsEntity.ApplicationInsightsEntityBuilder)((ApplicationInsightsEntity.ApplicationInsightsEntityBuilder)((ApplicationInsightsEntity.ApplicationInsightsEntityBuilder)((ApplicationInsightsEntity.ApplicationInsightsEntityBuilder)((ApplicationInsightsEntity.ApplicationInsightsEntityBuilder)ApplicationInsightsEntity.builder().id(component.id())).name(component.name())).subscriptionId(resourceId.subscriptionId())).resourceGroup(resourceId.resourceGroupName())).region(Region.fromName((String)component.location()))).instrumentationKey(component.instrumentationKey())).kind(component.kind())).type(component.type())).build();
    }
}

