/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.applicationinsights.task;

import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementException;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsights;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsEntity;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import javax.annotation.Nonnull;

public class GetOrCreateApplicationInsightsTask
extends AzureTask<ApplicationInsightsEntity> {
    private static final String APPLICATION_INSIGHTS_CREATE_START = "Creating application insights...";
    private static final String APPLICATION_INSIGHTS_CREATED = "Successfully created the application insights %s for this Function App. You can visit %s/#@/resource%s/overview to view your Application Insights component.";
    private final String subscriptionId;
    private final String resourceGroup;
    private final String name;
    private final Region region;

    public GetOrCreateApplicationInsightsTask(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull Region region, @Nonnull String name) {
        this.subscriptionId = subscriptionId;
        this.resourceGroup = resourceGroup;
        this.name = name;
        this.region = region;
    }

    public ApplicationInsightsEntity execute() {
        ApplicationInsights az = (ApplicationInsights)((ApplicationInsights)Azure.az(ApplicationInsights.class)).subscription(this.subscriptionId);
        try {
            return az.get(this.resourceGroup, this.name);
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() != 404) {
                throw e;
            }
            AzureMessager.getMessager().info(APPLICATION_INSIGHTS_CREATE_START);
            AzureEnvironment environment = ((AzureAccount)Azure.az(AzureAccount.class)).account().getEnvironment();
            ApplicationInsightsEntity resource = ((ApplicationInsights)Azure.az(ApplicationInsights.class)).create(this.resourceGroup, this.region, this.name);
            AzureMessager.getMessager().info(String.format(APPLICATION_INSIGHTS_CREATED, resource.getName(), AzureEnvironmentUtils.getPortalUrl((AzureEnvironment)environment), resource.getId()));
            return resource;
        }
    }
}

