/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.applicationinsights;

import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent;
import com.azure.resourcemanager.applicationinsights.models.ApplicationType;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsight;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsModule;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsResourceManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationInsightDraft
extends ApplicationInsight
implements AzResource.Draft<ApplicationInsight, ApplicationInsightsComponent> {
    private static final String REGION_IS_REQUIRED = "'region' is required to create application insight.";
    private static final String START_CREATING_APPLICATION_INSIGHT = "Start creating Application Insight ({0})...";
    private static final String APPLICATION_INSIGHTS_CREATED = "Application Insight ({0}) is successfully created. You can visit {1} to view your Application Insights component.";
    private Region region;
    private final ApplicationInsight origin;

    protected ApplicationInsightDraft(@Nonnull String name, @Nonnull String resourceGroupName, ApplicationInsightsModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    protected ApplicationInsightDraft(@Nonnull ApplicationInsight origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.region = null;
    }

    @AzureOperation(name="resource.create_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public ApplicationInsightsComponent createResourceInAzure() {
        AzureTelemetry.getContext().setProperty("resourceType", this.getFullResourceType());
        AzureTelemetry.getContext().setProperty("subscriptionId", this.getSubscriptionId());
        if (Objects.isNull(this.region)) {
            throw new AzureToolkitRuntimeException(REGION_IS_REQUIRED);
        }
        ApplicationInsightsManager applicationInsightsManager = Objects.requireNonNull((ApplicationInsightsManager)((ApplicationInsightsResourceManager)this.getParent()).getRemote());
        IAzureMessager messager = AzureMessager.getMessager();
        messager.info(AzureString.format((String)START_CREATING_APPLICATION_INSIGHT, (Object[])new Object[]{this.getName()}));
        ApplicationInsightsComponent result = applicationInsightsManager.components().define(this.getName()).withRegion(this.region.getName()).withExistingResourceGroup(this.getResourceGroupName()).withKind("web").withApplicationType(ApplicationType.WEB).create();
        messager.success(AzureString.format((String)APPLICATION_INSIGHTS_CREATED, (Object[])new Object[]{this.getName(), this.getPortalUrl()}));
        return result;
    }

    @AzureOperation(name="resource.update_resource.resource|type", params={"this.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    public ApplicationInsightsComponent updateResourceInAzure(@Nonnull ApplicationInsightsComponent origin) {
        throw new AzureToolkitRuntimeException("not supported");
    }

    public boolean isModified() {
        return this.region != null && !Objects.equals(this.region, (Object)this.origin);
    }

    @Nullable
    public ApplicationInsight getOrigin() {
        return this.origin;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }
}

