/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.applicationinsights;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.azure.resourcemanager.resources.models.Providers;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.AzureService;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsModule;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsResourceManager;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzureApplicationInsights
extends AbstractAzService<ApplicationInsightsResourceManager, ApplicationInsightsManager> {
    public AzureApplicationInsights() {
        super("Microsoft.Insights");
    }

    protected ApplicationInsightsResourceManager newResource(@Nonnull ApplicationInsightsManager applicationInsightsManager) {
        return new ApplicationInsightsResourceManager(applicationInsightsManager.serviceClient().getSubscriptionId(), this);
    }

    @Nonnull
    public ApplicationInsightsModule applicationInsights(@Nonnull String subscriptionId) {
        ApplicationInsightsResourceManager rm = (ApplicationInsightsResourceManager)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.applicationInsights();
    }

    @Nullable
    protected ApplicationInsightsManager loadResourceFromAzure(@NotNull String subscriptionId, String resourceGroup) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        String tenantId = account.getSubscription(subscriptionId).getTenantId();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogOptions logOptions = new HttpLogOptions();
        logOptions.setLogLevel(Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE));
        AzureProfile azureProfile = new AzureProfile(tenantId, subscriptionId, account.getEnvironment());
        Providers providers = ((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withHttpClient(AzureService.getDefaultHttpClient())).withPolicy(AzureService.getUserAgentPolicy((String)userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId).providers();
        return ApplicationInsightsManager.configure().withHttpClient(AzureService.getDefaultHttpClient()).withLogOptions(logOptions).withPolicy(AzureService.getUserAgentPolicy((String)userAgent)).withPolicy((HttpPipelinePolicy)new ProviderRegistrationPolicy(providers)).authenticate(account.getTokenCredential(subscriptionId), azureProfile);
    }

    public String getResourceTypeName() {
        return "Application Insights";
    }
}

