/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.applicationinsights;

import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent;
import com.azure.resourcemanager.applicationinsights.models.Components;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsight;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightDraft;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ApplicationInsightsModule
extends AbstractAzResourceModule<ApplicationInsight, ApplicationInsightsServiceSubscription, ApplicationInsightsComponent> {
    public static final String NAME = "components";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public ApplicationInsightsModule(@Nonnull ApplicationInsightsServiceSubscription parent) {
        super(NAME, (AbstractAzResource)parent);
    }

    @Nonnull
    @AzureOperation(name="resource.list_resources.type", params={"this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected Stream<ApplicationInsightsComponent> loadResourcesFromAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Stream<ApplicationInsightsComponent> stream = Optional.ofNullable(this.getClient()).map(c -> c.list().stream()).orElse(Stream.empty());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return stream;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    @AzureOperation(name="resource.load_resource.resource|type", params={"name", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected ApplicationInsightsComponent loadResourceFromAzure(@Nonnull String name, String resourceGroup) {
        String string = name;
        String string2 = resourceGroup;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            assert (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{resourceGroup})) : "resource group can not be empty";
            ApplicationInsightsComponent applicationInsightsComponent = Optional.ofNullable(this.getClient()).map(c -> c.getByResourceGroup(resourceGroup, name)).orElse(null);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return applicationInsightsComponent;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="resource.delete_resource.resource|type", params={"nameFromResourceId(resourceId)", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Optional.ofNullable(this.getClient()).ifPresent(c -> c.deleteById(resourceId));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_create.resource|type", params={"name", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected ApplicationInsightDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        String string = name;
        String string2 = resourceGroupName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            assert (resourceGroupName != null) : "'Resource group' is required.";
            ApplicationInsightDraft applicationInsightDraft = new ApplicationInsightDraft(name, resourceGroupName, this);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return applicationInsightDraft;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="resource.draft_for_update.resource|type", params={"origin.getName()", "this.getResourceTypeName()"}, type=AzureOperation.Type.SERVICE)
    protected ApplicationInsightDraft newDraftForUpdate(@Nonnull ApplicationInsight applicationInsight) {
        ApplicationInsight applicationInsight2 = applicationInsight;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)((Object)applicationInsight2));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ApplicationInsightDraft applicationInsightDraft = new ApplicationInsightDraft(applicationInsight);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return applicationInsightDraft;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected ApplicationInsight newResource(@Nonnull ApplicationInsightsComponent remote) {
        return new ApplicationInsight(remote, this);
    }

    @Nonnull
    protected ApplicationInsight newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new ApplicationInsight(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Nullable
    public Components getClient() {
        return Optional.ofNullable((ApplicationInsightsManager)((ApplicationInsightsServiceSubscription)this.parent).getRemote()).map(ApplicationInsightsManager::components).orElse(null);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Application Insights";
    }

    static {
        ApplicationInsightsModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ApplicationInsightsModule.java", ApplicationInsightsModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourcesFromAzure", "com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsModule", "", "", "", "java.util.stream.Stream"), 33);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourceFromAzure", "com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsModule", "java.lang.String:java.lang.String", "name:resourceGroup", "", "com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent"), 40);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsModule", "java.lang.String", "resourceId", "", "void"), 51);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "newDraftForCreate", "com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsModule", "java.lang.String:java.lang.String", "name:resourceGroupName", "", "com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightDraft"), 58);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "newDraftForUpdate", "com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsModule", "com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsight", "applicationInsight", "", "com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightDraft"), 70);
    }
}

