/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.applicationinsights;

import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent;
import com.azure.resourcemanager.applicationinsights.models.ApplicationType;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsight;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsModule;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.monitor.AzureLogAnalyticsWorkspace;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspace;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceConfig;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceDraft;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ApplicationInsightDraft
extends ApplicationInsight
implements AzResource.Draft<ApplicationInsight, ApplicationInsightsComponent> {
    private static final String REGION_IS_REQUIRED = "'region' is required to create Application Insights.";
    private static final String START_CREATING_APPLICATION_INSIGHT = "Start creating Application Insights ({0})...";
    private static final String APPLICATION_INSIGHTS_CREATED = "Application Insights ({0}) is successfully created. You can visit {1} to view your Application Insights component.";
    @Nullable
    private Region region;
    @Nullable
    private LogAnalyticsWorkspaceConfig workspaceConfig;
    @Nullable
    private final ApplicationInsight origin;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected ApplicationInsightDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ApplicationInsightsModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    protected ApplicationInsightDraft(@Nonnull ApplicationInsight origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.region = null;
    }

    @Nonnull
    @AzureOperation(name="azure/ai.create_ai.ai", params={"this.getName()"})
    public ApplicationInsightsComponent createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (Objects.isNull(this.region)) {
                throw new AzureToolkitRuntimeException(REGION_IS_REQUIRED);
            }
            String workspaceResourceId = this.extractWorkspaceId();
            ApplicationInsightsManager applicationInsightsManager = Objects.requireNonNull((ApplicationInsightsManager)((ApplicationInsightsServiceSubscription)this.getParent()).getRemote());
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)START_CREATING_APPLICATION_INSIGHT, (Object[])new Object[]{this.getName()}));
            ApplicationInsightsComponent result = applicationInsightsManager.components().define(this.getName()).withRegion(this.region.getName()).withExistingResourceGroup(this.getResourceGroupName()).withKind("web").withWorkspaceResourceId(workspaceResourceId).withApplicationType(ApplicationType.WEB).create();
            messager.success(AzureString.format((String)APPLICATION_INSIGHTS_CREATED, (Object[])new Object[]{this.getName(), this.getPortalUrl()}));
            ApplicationInsightsComponent applicationInsightsComponent = result;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return applicationInsightsComponent;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/ai.update_ai.ai", params={"this.getName()"})
    public ApplicationInsightsComponent updateResourceInAzure(@Nonnull ApplicationInsightsComponent origin) {
        ApplicationInsightsComponent applicationInsightsComponent = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)applicationInsightsComponent);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            throw new AzureToolkitRuntimeException("not supported");
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Optional.ofNullable(this.region).orElseGet(() -> super.getRegion());
    }

    public boolean isModified() {
        return this.region != null && !Objects.equals(this.region, this.origin.getRegion());
    }

    @Nullable
    private String extractWorkspaceId() {
        String workspaceResourceId;
        if (Objects.isNull(this.workspaceConfig)) {
            return null;
        }
        if (this.workspaceConfig.isNewCreate()) {
            String resourceGroupName = String.format("DefaultResourceGroup-%s", this.region.getAbbreviation());
            ResourceGroup resourceGroup = (ResourceGroup)((AzureResources)Azure.az(AzureResources.class)).groups(this.getSubscriptionId()).getOrDraft(resourceGroupName, resourceGroupName);
            if (resourceGroup.isDraftForCreating()) {
                ((ResourceGroupDraft)resourceGroup).setRegion(this.region);
                ((ResourceGroupDraft)resourceGroup).createIfNotExist();
            }
            LogAnalyticsWorkspaceDraft draft = (LogAnalyticsWorkspaceDraft)((AzureLogAnalyticsWorkspace)Azure.az(AzureLogAnalyticsWorkspace.class)).logAnalyticsWorkspaces(this.getSubscriptionId()).create(this.workspaceConfig.getName(), resourceGroupName);
            draft.setRegion(this.region);
            workspaceResourceId = ((LogAnalyticsWorkspace)draft.commit()).getId();
        } else {
            workspaceResourceId = this.workspaceConfig.getResourceId();
        }
        return workspaceResourceId;
    }

    public void setRegion(@Nullable Region region) {
        this.region = region;
    }

    public void setWorkspaceConfig(@Nullable LogAnalyticsWorkspaceConfig workspaceConfig) {
        this.workspaceConfig = workspaceConfig;
    }

    @Nullable
    public LogAnalyticsWorkspaceConfig getWorkspaceConfig() {
        return this.workspaceConfig;
    }

    @Nullable
    public ApplicationInsight getOrigin() {
        return this.origin;
    }

    static {
        ApplicationInsightDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ApplicationInsightDraft.java", ApplicationInsightDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightDraft", "", "", "", "com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent"), 70);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightDraft", "com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent", "origin", "", "com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent"), 91);
    }
}

