/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.PricingTier;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebApp;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAzureManager;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AppServicePlan
extends AbstractAzureManager<com.azure.resourcemanager.appservice.models.AppServicePlan>
implements IAppServicePlan {
    private static final String APP_SERVICE_PLAN_ID_TEMPLATE = "/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Web/serverfarms/%s";
    private AppServicePlanEntity entity;
    private final AzureResourceManager azureClient;

    public AppServicePlan(@Nonnull String id, @Nonnull AzureResourceManager azureClient) {
        super(id);
        this.azureClient = azureClient;
    }

    public AppServicePlan(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull String name, @Nonnull AzureResourceManager azureClient) {
        super(subscriptionId, resourceGroup, name);
        this.azureClient = azureClient;
    }

    public AppServicePlan(com.azure.resourcemanager.appservice.models.AppServicePlan remote, AzureResourceManager azureClient) {
        super(remote);
        this.entity = AppServiceUtils.fromAppServicePlan(remote);
        this.azureClient = azureClient;
    }

    @Override
    public IAppServicePlan.Creator create() {
        return new AppServicePlanCreator();
    }

    public AppServicePlan refresh() {
        super.refresh();
        this.entity = Optional.ofNullable((com.azure.resourcemanager.appservice.models.AppServicePlan)this.remote).map(AppServiceUtils::fromAppServicePlan).orElse(null);
        return this;
    }

    public String name() {
        return this.getRemoteResource().name();
    }

    public String id() {
        return String.format(APP_SERVICE_PLAN_ID_TEMPLATE, this.subscriptionId, this.resourceGroup, this.name);
    }

    @Override
    public AppServicePlanEntity entity() {
        if (this.remote == null) {
            this.refresh();
        }
        return this.entity;
    }

    @Override
    public List<IWebApp> webapps() {
        return ((AppServiceManager)this.getRemoteResource().manager()).webApps().list().stream().filter(webapp -> StringUtils.equals((CharSequence)webapp.appServicePlanId(), (CharSequence)this.getRemoteResource().id())).map(webapp -> new WebApp((WebSiteBase)webapp, this.azureClient)).collect(Collectors.toList());
    }

    @Override
    public AppServicePlanUpdater update() {
        return new AppServicePlanUpdater();
    }

    @Override
    protected com.azure.resourcemanager.appservice.models.AppServicePlan loadRemote() {
        return (com.azure.resourcemanager.appservice.models.AppServicePlan)this.azureClient.appServicePlans().getByResourceGroup(this.resourceGroup, this.name);
    }

    @Nonnull
    private com.azure.resourcemanager.appservice.models.AppServicePlan getRemoteResource() {
        if (this.remote == null) {
            this.refresh();
        }
        return Objects.requireNonNull((com.azure.resourcemanager.appservice.models.AppServicePlan)this.remote, "Target resource does not exist.");
    }

    public class AppServicePlanUpdater
    implements IAppServicePlan.Updater {
        private com.microsoft.azure.toolkit.lib.appservice.model.PricingTier pricingTier;

        @Override
        public AppServicePlanUpdater withPricingTier(com.microsoft.azure.toolkit.lib.appservice.model.PricingTier pricingTier) {
            this.pricingTier = pricingTier;
            return this;
        }

        @Override
        public AppServicePlan commit() {
            PricingTier newPricingTier;
            boolean modified = false;
            AppServicePlan.Update update = (AppServicePlan.Update)AppServicePlan.this.getRemoteResource().update();
            if (this.pricingTier != null && !Objects.equals(newPricingTier = AppServiceUtils.toPricingTier(this.pricingTier), AppServicePlan.this.getRemoteResource().pricingTier())) {
                modified = true;
                update = update.withPricingTier(newPricingTier);
            }
            if (modified) {
                AppServicePlan.this.remote = (HasId)update.apply();
            }
            AppServicePlan.this.entity = AppServiceUtils.fromAppServicePlan((com.azure.resourcemanager.appservice.models.AppServicePlan)AppServicePlan.this.remote);
            return AppServicePlan.this;
        }
    }

    public class AppServicePlanCreator
    implements IAppServicePlan.Creator {
        private String name;
        private Region region;
        private String resourceGroup;
        private com.microsoft.azure.toolkit.lib.appservice.model.PricingTier pricingTier;
        private com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem operatingSystem;

        @Override
        public IAppServicePlan.Creator withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public IAppServicePlan.Creator withRegion(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public IAppServicePlan.Creator withResourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        @Override
        public IAppServicePlan.Creator withPricingTier(com.microsoft.azure.toolkit.lib.appservice.model.PricingTier pricingTier) {
            this.pricingTier = pricingTier;
            return this;
        }

        @Override
        public IAppServicePlan.Creator withOperatingSystem(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public IAppServicePlan commit() {
            AppServicePlan.this.remote = (HasId)((AppServicePlan.DefinitionStages.WithPricingTier)((AppServicePlan.DefinitionStages.WithGroup)((AppServicePlan.DefinitionStages.Blank)AppServicePlan.this.azureClient.appServicePlans().define(this.name)).withRegion(this.region.getName())).withExistingResourceGroup(this.resourceGroup)).withPricingTier(AppServiceUtils.toPricingTier(this.pricingTier)).withOperatingSystem(this.convertOS(this.operatingSystem)).create();
            AppServicePlan.this.entity = AppServiceUtils.fromAppServicePlan((com.azure.resourcemanager.appservice.models.AppServicePlan)AppServicePlan.this.remote);
            return AppServicePlan.this;
        }

        private OperatingSystem convertOS(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem operatingSystem) {
            return operatingSystem == com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.WINDOWS ? OperatingSystem.WINDOWS : OperatingSystem.LINUX;
        }
    }
}

