/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebApp;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class DeployWebAppTask
extends AzureTask<IWebApp> {
    private static final String SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE = "Skip deployment for docker webapp, you can navigate to %s to access your docker webapp.";
    private static final String DEPLOY_START = "Trying to deploy artifact to %s...";
    private static final String DEPLOY_FINISH = "Successfully deployed the artifact to https://%s";
    private static final String STOP_APP = "Stopping Web App before deploying artifacts...";
    private static final String START_APP = "Starting Web App after deploying artifacts...";
    private static final String STOP_APP_DONE = "Successfully stopped Web App.";
    private static final String START_APP_DONE = "Successfully started Web App.";
    private static final String RUNNING = "Running";
    private IWebApp webApp;
    private List<WebAppArtifact> artifacts;
    private boolean isStopAppDuringDeployment;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DeployWebAppTask(IWebApp webApp, List<WebAppArtifact> artifacts) {
        this(webApp, artifacts, false);
    }

    public DeployWebAppTask(IWebApp webApp, List<WebAppArtifact> artifacts, boolean isStopAppDuringDeployment) {
        this.webApp = webApp;
        this.artifacts = artifacts;
        this.isStopAppDuringDeployment = isStopAppDuringDeployment;
    }

    @AzureOperation(name="webapp.deploy", params={"this.config.getAppName()"}, type=AzureOperation.Type.SERVICE)
    public IWebApp execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            IWebApp iWebApp;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (this.webApp.getRuntime().isDocker()) {
                AzureMessager.getMessager().info(AzureString.format((String)SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE, (Object[])new Object[]{"https://" + this.webApp.hostName()}));
                iWebApp = this.webApp;
            } else {
                try {
                    AzureMessager.getMessager().info(String.format(DEPLOY_START, this.webApp.name()));
                    if (this.isStopAppDuringDeployment) {
                        DeployWebAppTask.stopAppService(this.webApp);
                    }
                    this.deployArtifacts();
                    AzureMessager.getMessager().info(String.format(DEPLOY_FINISH, this.webApp.hostName()));
                }
                finally {
                    DeployWebAppTask.startAppService(this.webApp);
                }
                iWebApp = this.webApp;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return iWebApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void deployArtifacts() {
        if (this.artifacts.stream().anyMatch(artifact -> artifact.getDeployType() == null)) {
            throw new AzureToolkitRuntimeException("missing deployment type for some artifacts.");
        }
        List<WebAppArtifact> artifactsOneDeploy = this.artifacts.stream().filter(artifact -> artifact.getDeployType() != null).collect(Collectors.toList());
        artifactsOneDeploy.forEach(resource -> this.webApp.deploy(resource.getDeployType(), resource.getFile(), resource.getPath()));
    }

    private static void stopAppService(IWebApp target) {
        AzureMessager.getMessager().info(STOP_APP);
        target.stop();
        try {
            TimeUnit.SECONDS.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AzureMessager.getMessager().info(STOP_APP_DONE);
    }

    private static void startAppService(IWebApp target) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)target.state(), (CharSequence)RUNNING)) {
            AzureMessager.getMessager().info(START_APP);
            target.start();
            AzureMessager.getMessager().info(START_APP_DONE);
        }
    }

    static {
        DeployWebAppTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployWebAppTask.java", DeployWebAppTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.microsoft.azure.toolkit.lib.appservice.task.DeployWebAppTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.service.IWebApp"), 48);
    }
}

