/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.appservice;

import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebApp;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DockerImageType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AppServiceUtils {
    public static List<PricingTier> getAvailablePricingTiers(OperatingSystem operatingSystem) {
        ArrayList<PricingTier> result = new ArrayList<PricingTier>(PricingTier.values());
        if (operatingSystem == OperatingSystem.LINUX || operatingSystem == OperatingSystem.DOCKER) {
            result.remove(PricingTier.PREMIUM_P1);
            result.remove(PricingTier.PREMIUM_P2);
            result.remove(PricingTier.PREMIUM_P3);
        }
        return result;
    }

    public static DockerImageType getDockerImageType(String imageName, boolean hasCredential, String registryUrl) {
        if (StringUtils.isEmpty((CharSequence)imageName)) {
            return DockerImageType.NONE;
        }
        boolean isCustomRegistry = StringUtils.isNotEmpty((CharSequence)registryUrl);
        if (isCustomRegistry) {
            return hasCredential ? DockerImageType.PRIVATE_REGISTRY : DockerImageType.UNKNOWN;
        }
        return hasCredential ? DockerImageType.PRIVATE_DOCKER_HUB : DockerImageType.PUBLIC_DOCKER_HUB;
    }

    public static boolean isDockerAppService(IWebApp webapp) {
        return webapp != null && webapp.getRuntime() != null && webapp.getRuntime().isDocker();
    }
}

