/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service;

import com.microsoft.azure.toolkit.lib.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServiceUpdater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractAppServiceUpdater<T>
implements IAppServiceUpdater {
    private Optional<DiagnosticConfig> diagnosticConfig = null;
    private Optional<DockerConfiguration> dockerConfiguration = null;
    private Optional<Runtime> runtime = null;
    private Optional<PricingTier> pricingTier = null;
    private Optional<AppServicePlanEntity> appServicePlan = null;
    private final List<String> appSettingsToRemove = new ArrayList<String>();
    private final Map<String, String> appSettingsToAdd = new HashMap<String, String>();

    public IAppServiceUpdater withPlan(String appServicePlanId) {
        this.appServicePlan = Optional.of(((AppServicePlanEntity.AppServicePlanEntityBuilder)AppServicePlanEntity.builder().id(appServicePlanId)).build());
        return this;
    }

    public IAppServiceUpdater withPlan(String resourceGroup, String planName) {
        this.appServicePlan = Optional.of(((AppServicePlanEntity.AppServicePlanEntityBuilder)((AppServicePlanEntity.AppServicePlanEntityBuilder)AppServicePlanEntity.builder().resourceGroup(resourceGroup)).name(planName)).build());
        return this;
    }

    @Override
    public IAppServiceUpdater<T> withRuntime(Runtime runtime) {
        this.runtime = Optional.ofNullable(runtime);
        return this;
    }

    public IAppServiceUpdater withDockerConfiguration(DockerConfiguration dockerConfiguration) {
        this.dockerConfiguration = Optional.ofNullable(dockerConfiguration);
        return this;
    }

    public IAppServiceUpdater withoutAppSettings(String key) {
        this.appSettingsToRemove.add(key);
        return this;
    }

    public IAppServiceUpdater<T> withAppSettings(Map appSettings) {
        this.appSettingsToAdd.putAll(appSettings);
        return this;
    }

    @Override
    public IAppServiceUpdater<T> withDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
        this.diagnosticConfig = Optional.ofNullable(diagnosticConfig);
        return this;
    }

    public Optional<DiagnosticConfig> getDiagnosticConfig() {
        return this.diagnosticConfig;
    }

    public Optional<DockerConfiguration> getDockerConfiguration() {
        return this.dockerConfiguration;
    }

    public Optional<Runtime> getRuntime() {
        return this.runtime;
    }

    public Optional<PricingTier> getPricingTier() {
        return this.pricingTier;
    }

    public Optional<AppServicePlanEntity> getAppServicePlan() {
        return this.appServicePlan;
    }

    public List<String> getAppSettingsToRemove() {
        return this.appSettingsToRemove;
    }

    public Map<String, String> getAppSettingsToAdd() {
        return this.appSettingsToAdd;
    }
}

