/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.models.CsmPublishingProfileOptions;
import com.azure.resourcemanager.appservice.models.PublishingProfileFormat;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.arm.resources.ResourceId;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServiceBaseEntity;
import com.microsoft.azure.toolkit.lib.appservice.manager.AppServiceKuduManager;
import com.microsoft.azure.toolkit.lib.appservice.model.AppServiceFile;
import com.microsoft.azure.toolkit.lib.appservice.model.CommandOutput;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.ProcessInfo;
import com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.TunnelStatus;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppService;
import com.microsoft.azure.toolkit.lib.appservice.service.IFileClient;
import com.microsoft.azure.toolkit.lib.appservice.service.IProcessClient;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AbstractAzureManager;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.common.event.AzureOperationEvent;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Flux;

abstract class AbstractAppService<T extends WebAppBase, R extends AppServiceBaseEntity>
extends AbstractAzureManager<T>
implements IAppService<R>,
AzureOperationEvent.Source<AbstractAppService<T, R>> {
    protected static final String APP_SERVICE_ID_TEMPLATE = "/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Web/sites/%s";
    protected AppServiceKuduManager kuduManager;
    protected R entity;

    public AbstractAppService(@Nonnull String id) {
        super(id);
    }

    public AbstractAppService(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull String name) {
        super(subscriptionId, resourceGroup, name);
    }

    public AbstractAppService(@Nonnull WebSiteBase webSiteBase) {
        super(webSiteBase.id());
    }

    public AbstractAppService(@Nonnull T appService) {
        super(appService);
        this.entity = this.getEntityFromRemoteResource((WebAppBase)this.remote);
    }

    public AbstractAppService<T, R> refresh() {
        super.refresh();
        this.entity = Optional.ofNullable((WebAppBase)this.remote).map(this::getEntityFromRemoteResource).orElse(null);
        return this;
    }

    @Override
    public void start() {
        ((WebAppBase)this.remote()).start();
    }

    @Override
    public void stop() {
        ((WebAppBase)this.remote()).stop();
    }

    @Override
    public void restart() {
        ((WebAppBase)this.remote()).restart();
    }

    public String id() {
        return String.format(APP_SERVICE_ID_TEMPLATE, this.subscriptionId, this.resourceGroup, this.name);
    }

    @Nonnull
    public synchronized R entity() {
        if (this.entity == null) {
            this.entity = this.getEntityFromRemoteResource((WebAppBase)this.remote());
        }
        return this.entity;
    }

    @Override
    public String hostName() {
        return ((WebAppBase)this.remote()).defaultHostname();
    }

    @Override
    public String state() {
        return ((WebAppBase)this.remote()).state();
    }

    @Override
    public Runtime getRuntime() {
        return this.entity().getRuntime();
    }

    @Override
    public PublishingProfile getPublishingProfile() {
        return AppServiceUtils.fromPublishingProfile(((WebAppBase)this.remote()).getPublishingProfile());
    }

    @Override
    public DiagnosticConfig getDiagnosticConfig() {
        return AppServiceUtils.fromWebAppDiagnosticLogs(((WebAppBase)this.remote()).diagnosticLogsConfig());
    }

    @Override
    public Flux<String> streamAllLogsAsync() {
        return ((WebAppBase)this.remote()).streamAllLogsAsync();
    }

    @Override
    public Flux<ByteBuffer> getFileContent(String path) {
        return this.getFileClient().getFileContent(path);
    }

    @Override
    public List<? extends AppServiceFile> getFilesInDirectory(String dir) {
        return this.getFileClient().getFilesInDirectory(dir);
    }

    @Override
    public AppServiceFile getFileByPath(String path) {
        return this.getFileClient().getFileByPath(path);
    }

    @Override
    public void uploadFileToPath(String content, String path) {
        this.getFileClient().uploadFileToPath(content, path);
    }

    @Override
    public void createDirectory(String path) {
        this.getFileClient().createDirectory(path);
    }

    @Override
    public void deleteFile(String path) {
        this.getFileClient().deleteFile(path);
    }

    @Override
    public List<ProcessInfo> listProcess() {
        return this.getProcessClient().listProcess();
    }

    @Override
    public CommandOutput execute(String command, String dir) {
        return this.getProcessClient().execute(command, dir);
    }

    @Override
    public InputStream listPublishingProfileXmlWithSecrets() {
        ResourceId resourceId = ResourceId.fromString((String)this.id());
        String resourceName = StringUtils.equals((CharSequence)resourceId.resourceType(), (CharSequence)"slots") ? String.format("%s/slots/%s", resourceId.parent().name(), resourceId.name()) : resourceId.name();
        CsmPublishingProfileOptions csmPublishingProfileOptions = new CsmPublishingProfileOptions().withFormat(PublishingProfileFormat.FTP);
        return ((WebSiteManagementClient)((AppServiceManager)((WebAppBase)this.remote()).manager()).serviceClient()).getWebApps().listPublishingProfileXmlWithSecrets(resourceId.resourceGroupName(), resourceName, csmPublishingProfileOptions);
    }

    @Override
    public TunnelStatus getAppServiceTunnelStatus() {
        return this.getProcessClient().getAppServiceTunnelStatus();
    }

    public String name() {
        return this.name;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    protected IFileClient getFileClient() {
        return this.getKuduManager();
    }

    protected IProcessClient getProcessClient() {
        return this.getKuduManager();
    }

    protected AppServiceKuduManager getKuduManager() {
        if (this.kuduManager == null) {
            this.kuduManager = AppServiceKuduManager.getClient((WebAppBase)this.remote(), this);
        }
        return this.kuduManager;
    }

    @Nonnull
    protected abstract R getEntityFromRemoteResource(@Nonnull T var1);

    @Override
    @Nullable
    protected abstract T loadRemote();
}

