/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.service.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.arm.resources.ResourceId;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractAzureManager<T extends HasId> {
    protected boolean isRefreshed = false;
    @Nonnull
    protected final String name;
    @Nonnull
    protected final String resourceGroup;
    @Nonnull
    protected final String subscriptionId;
    protected T remote;

    public AbstractAzureManager(@Nonnull String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        this.name = resourceId.name();
        this.resourceGroup = resourceId.resourceGroupName();
        this.subscriptionId = resourceId.subscriptionId();
    }

    public AbstractAzureManager(@Nonnull String subscriptionId, @Nonnull String resourceGroup, @Nonnull String name) {
        this.name = name;
        this.resourceGroup = resourceGroup;
        this.subscriptionId = subscriptionId;
    }

    public AbstractAzureManager(@Nonnull T resource) {
        this(resource.id());
        this.remote = resource;
    }

    public final boolean exists() {
        if (Objects.isNull(this.remote) && !this.isRefreshed) {
            this.refresh();
        }
        return Objects.nonNull(this.remote);
    }

    public synchronized AbstractAzureManager<T> refresh() {
        try {
            this.remote = this.loadRemote();
            this.isRefreshed = true;
        }
        catch (ManagementException e) {
            if (404 == e.getResponse().getStatusCode()) {
                this.remote = null;
                this.isRefreshed = true;
            }
            throw e;
        }
        return this;
    }

    @Nonnull
    protected final T remote() {
        if (!this.exists()) {
            throw new AzureToolkitRuntimeException(String.format("Target resource %s does not exist.", this.name));
        }
        return this.remote;
    }

    @Nullable
    protected abstract T loadRemote();
}

