/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServicePlanConfig;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class CreateOrUpdateAppServicePlanTask
extends AzureTask<IAppServicePlan> {
    private static final String CREATE_APP_SERVICE_PLAN = "Creating app service plan %s...";
    private static final String CREATE_APP_SERVICE_PLAN_DONE = "Successfully created app service plan %s.";
    private static final String CREATE_NEW_APP_SERVICE_PLAN = "createNewAppServicePlan";
    private AppServicePlanConfig config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="appservice|plan.create_update", params={"this.config.servicePlanName()"}, type=AzureOperation.Type.SERVICE)
    public IAppServicePlan execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureAppService az = (AzureAppService)((AzureAppService)Azure.az(AzureAppService.class)).subscription(this.config.subscriptionId());
            IAppServicePlan appServicePlan = az.appServicePlan(this.config.servicePlanResourceGroup(), this.config.servicePlanName());
            String servicePlanName = this.config.servicePlanName();
            if (!appServicePlan.exists()) {
                AzureMessager.getMessager().info(String.format(CREATE_APP_SERVICE_PLAN, servicePlanName));
                AzureTelemetry.getActionContext().setProperty(CREATE_NEW_APP_SERVICE_PLAN, String.valueOf(true));
                if (this.config.os() == null) {
                    throw new AzureToolkitRuntimeException("Missing required configuration for 'runtime.os'.");
                }
                if (this.config.region() == null) {
                    throw new AzureToolkitRuntimeException("Missing required configuration for 'region'.");
                }
                if (this.config.pricingTier() == null) {
                    throw new AzureToolkitRuntimeException("Missing required configuration for 'pricingTier'.");
                }
                appServicePlan.create().withName(servicePlanName).withResourceGroup(this.config.servicePlanResourceGroup()).withPricingTier(this.config.pricingTier()).withRegion(this.config.region()).withOperatingSystem(this.config.os()).commit();
                AzureMessager.getMessager().info(String.format(CREATE_APP_SERVICE_PLAN_DONE, appServicePlan.name()));
            } else {
                if (this.config.region() != null && !Objects.equals(this.config.region(), Region.fromName((String)appServicePlan.entity().getRegion()))) {
                    AzureMessager.getMessager().warning(String.format("Skip region update for existing service plan '%s' since it is not allowed.", appServicePlan.name()));
                }
                if (this.config.pricingTier() != null) {
                    appServicePlan.update().withPricingTier(this.config.pricingTier()).commit();
                }
            }
            IAppServicePlan iAppServicePlan = appServicePlan;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return iAppServicePlan;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public CreateOrUpdateAppServicePlanTask(AppServicePlanConfig config) {
        this.config = config;
    }

    static {
        CreateOrUpdateAppServicePlanTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CreateOrUpdateAppServicePlanTask.java", CreateOrUpdateAppServicePlanTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateAppServicePlanTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan"), 31);
    }
}

