/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServicePlanConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebApp;
import com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateAppServicePlanTask;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import com.microsoft.azure.toolkit.lib.resource.task.CreateResourceGroupTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.publisher.Flux;

public class CreateOrUpdateWebAppTask
extends AzureTask<IWebApp> {
    private static final String CREATE_NEW_WEB_APP = "createNewWebApp";
    private static final String CREATE_WEBAPP = "Creating web app %s...";
    private static final String CREATE_WEB_APP_DONE = "Successfully created Web App %s.";
    private static final String UPDATE_WEBAPP = "Updating target Web App %s...";
    private static final String UPDATE_WEBAPP_DONE = "Successfully updated Web App %s.";
    private final AppServiceConfig config;
    private final List<AzureTask<?>> subTasks;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public CreateOrUpdateWebAppTask(AppServiceConfig config) {
        this.config = config;
        this.subTasks = this.initTasks();
    }

    private List<AzureTask<?>> initTasks() {
        ArrayList tasks = new ArrayList();
        tasks.add((AzureTask<?>)new CreateResourceGroupTask(this.config.subscriptionId(), this.config.resourceGroup(), this.config.region()));
        if (StringUtils.isNotBlank((CharSequence)this.config.servicePlanResourceGroup()) && !StringUtils.equalsIgnoreCase((CharSequence)this.config.servicePlanResourceGroup(), (CharSequence)this.config.resourceGroup())) {
            tasks.add((AzureTask<?>)new CreateResourceGroupTask(this.config.subscriptionId(), this.config.servicePlanResourceGroup(), this.config.region()));
        }
        AzureString title = AzureString.format((String)"Create new web app({0})", (Object[])new Object[]{this.config.appName()});
        tasks.add(new AzureTask(title, () -> {
            IWebApp target = ((AzureAppService)((AzureAppService)Azure.az(AzureAppService.class)).subscription(this.config.subscriptionId())).webapp(this.config.resourceGroup(), this.config.appName());
            if (!target.exists()) {
                return this.create();
            }
            return this.update(target);
        }));
        return tasks;
    }

    @AzureOperation(name="webapp.create", params={"this.config.appName()"}, type=AzureOperation.Type.SERVICE)
    private IWebApp create() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureTelemetry.getActionContext().setProperty(CREATE_NEW_WEB_APP, String.valueOf(true));
            AzureMessager.getMessager().info(String.format(CREATE_WEBAPP, this.config.appName()));
            AzureAppService az = (AzureAppService)((AzureAppService)Azure.az(AzureAppService.class)).subscription(this.config.subscriptionId());
            IWebApp webapp = az.webapp(this.config.resourceGroup(), this.config.appName());
            AppServicePlanConfig servicePlanConfig = this.config.getServicePlanConfig();
            if (StringUtils.isBlank((CharSequence)servicePlanConfig.servicePlanResourceGroup())) {
                servicePlanConfig.servicePlanResourceGroup(this.config.resourceGroup());
            }
            if (StringUtils.isBlank((CharSequence)servicePlanConfig.servicePlanName())) {
                servicePlanConfig.servicePlanName(String.format("asp-%s", this.config.appName()));
            }
            IAppServicePlan appServicePlan = new CreateOrUpdateAppServicePlanTask(servicePlanConfig).execute();
            IWebApp result = webapp.create().withName(this.config.appName()).withResourceGroup(this.config.resourceGroup()).withPlan(appServicePlan.id()).withRuntime(this.getRuntime(this.config.runtime())).withDockerConfiguration(this.getDockerConfiguration(this.config.runtime())).withAppSettings(this.config.appSettings()).commit();
            AzureMessager.getMessager().info(String.format(CREATE_WEB_APP_DONE, result.name()));
            IWebApp iWebApp = result;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return iWebApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="webapp.update", params={"this.config.appName()"}, type=AzureOperation.Type.SERVICE)
    private IWebApp update(IWebApp webApp) {
        IWebApp iWebApp = webApp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)iWebApp);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AzureMessager.getMessager().info(String.format(UPDATE_WEBAPP, webApp.name()));
            IAppServicePlan currentPlan = webApp.plan();
            AppServicePlanConfig servicePlanConfig = this.config.getServicePlanConfig();
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{servicePlanConfig.servicePlanResourceGroup(), servicePlanConfig.servicePlanName()})) {
                servicePlanConfig.servicePlanResourceGroup(currentPlan.resourceGroup());
                servicePlanConfig.servicePlanName(currentPlan.name());
            } else if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{servicePlanConfig.servicePlanResourceGroup(), servicePlanConfig.servicePlanName()})) {
                if (StringUtils.isBlank((CharSequence)servicePlanConfig.servicePlanResourceGroup())) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)servicePlanConfig.servicePlanName(), (CharSequence)currentPlan.name())) {
                        servicePlanConfig.servicePlanResourceGroup(currentPlan.resourceGroup());
                    } else {
                        servicePlanConfig.servicePlanResourceGroup(this.config.resourceGroup());
                    }
                } else if (StringUtils.isBlank((CharSequence)servicePlanConfig.servicePlanName())) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)servicePlanConfig.servicePlanResourceGroup(), (CharSequence)currentPlan.resourceGroup())) {
                        servicePlanConfig.servicePlanName(currentPlan.name());
                    } else {
                        servicePlanConfig.servicePlanName(String.format("asp-%s", this.config.appName()));
                    }
                }
            }
            IAppServicePlan appServicePlan = new CreateOrUpdateAppServicePlanTask(servicePlanConfig).execute();
            IWebApp result = webApp.update().withPlan(appServicePlan.id()).withRuntime(this.getRuntime(this.config.runtime())).withDockerConfiguration(this.getDockerConfiguration(this.config.runtime())).withAppSettings((Map)ObjectUtils.firstNonNull((Object[])new Map[]{this.config.appSettings(), new HashMap()})).commit();
            AzureMessager.getMessager().info(String.format(UPDATE_WEBAPP_DONE, webApp.name()));
            IWebApp iWebApp2 = result;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return iWebApp2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private DockerConfiguration getDockerConfiguration(RuntimeConfig runtime) {
        if (runtime != null && OperatingSystem.DOCKER == runtime.os()) {
            return ((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)DockerConfiguration.builder().userName(runtime.username())).password(runtime.password())).registryUrl(runtime.registryUrl())).image(runtime.image())).startUpCommand(runtime.startUpCommand())).build();
        }
        return null;
    }

    private Runtime getRuntime(RuntimeConfig runtime) {
        if (runtime != null && OperatingSystem.DOCKER != runtime.os()) {
            return Runtime.getRuntime(runtime.os(), runtime.webContainer(), runtime.javaVersion());
        }
        if (runtime != null && OperatingSystem.DOCKER == runtime.os()) {
            return Runtime.getRuntime(OperatingSystem.DOCKER, WebContainer.JAVA_OFF, JavaVersion.OFF);
        }
        return null;
    }

    @AzureOperation(name="webapp.create_update", params={"this.config.appName()"}, type=AzureOperation.Type.SERVICE)
    public IWebApp execute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            IWebApp iWebApp = (IWebApp)Flux.fromStream(this.subTasks.stream().map(t -> t.getSupplier().get())).last().block();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return iWebApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static {
        CreateOrUpdateWebAppTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CreateOrUpdateWebAppTask.java", CreateOrUpdateWebAppTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "create", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.service.IWebApp"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "update", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask", "com.microsoft.azure.toolkit.lib.appservice.service.IWebApp", "webApp", "", "com.microsoft.azure.toolkit.lib.appservice.service.IWebApp"), 98);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateWebAppTask", "", "", "", "com.microsoft.azure.toolkit.lib.appservice.service.IWebApp"), 159);
    }
}

