/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.toolkit.lib.legacy.function.template.BindingTemplate;
import com.microsoft.azure.toolkit.lib.legacy.function.template.BindingsTemplate;
import com.microsoft.azure.toolkit.lib.legacy.function.template.FunctionTemplate;
import com.microsoft.azure.toolkit.lib.legacy.function.template.FunctionTemplates;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FunctionUtils {
    private static final String LOAD_TEMPLATES_FAIL = "Failed to load all function templates.";
    private static final String LOAD_BINDING_TEMPLATES_FAIL = "Failed to load function binding template.";
    private static final String INVALID_FUNCTION_EXTENSION_VERSION = "FUNCTIONS_EXTENSION_VERSION is empty or invalid, please check the configuration";

    public static FunctionExtensionVersion parseFunctionExtensionVersion(String version) throws AzureExecutionException {
        return Arrays.stream(FunctionExtensionVersion.values()).filter(versionEnum -> StringUtils.equalsIgnoreCase((CharSequence)versionEnum.getVersion(), (CharSequence)version)).findFirst().orElseThrow(() -> new AzureExecutionException(INVALID_FUNCTION_EXTENSION_VERSION));
    }

    public static BindingTemplate loadBindingTemplate(String type) {
        BindingTemplate bindingTemplate;
        block8: {
            InputStream is = FunctionUtils.class.getResourceAsStream("/bindings.json");
            try {
                String bindingsJsonStr = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                BindingsTemplate bindingsTemplate = (BindingsTemplate)new ObjectMapper().readValue(bindingsJsonStr, BindingsTemplate.class);
                bindingTemplate = bindingsTemplate.getBindingTemplateByName(type);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    AzureMessager.getMessager().warning(LOAD_BINDING_TEMPLATES_FAIL);
                    return null;
                }
            }
            is.close();
        }
        return bindingTemplate;
    }

    public static List<FunctionTemplate> loadAllFunctionTemplates() throws AzureExecutionException {
        List<FunctionTemplate> list;
        block8: {
            InputStream is = FunctionUtils.class.getResourceAsStream("/templates.json");
            try {
                String templatesJsonStr = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                list = FunctionUtils.parseTemplateJson(templatesJsonStr);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    AzureMessager.getMessager().error(LOAD_TEMPLATES_FAIL);
                    throw new AzureExecutionException(LOAD_TEMPLATES_FAIL, (Throwable)e);
                }
            }
            is.close();
        }
        return list;
    }

    private static List<FunctionTemplate> parseTemplateJson(String templateJson) throws IOException {
        FunctionTemplates templates = (FunctionTemplates)new ObjectMapper().readValue(templateJson, FunctionTemplates.class);
        return templates.getTemplates();
    }
}

