/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.ResourceNameAvailabilityInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.models.CheckNameResourceTypes;
import com.azure.resourcemanager.appservice.models.ResourceNameAvailabilityRequest;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.AzureService;
import com.microsoft.azure.toolkit.lib.SubscriptionScoped;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure1;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure11;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure13;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure15;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure17;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure19;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure21;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure23;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure3;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure5;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure7;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService$AjcClosure9;
import com.microsoft.azure.toolkit.lib.appservice.entity.AppServicePlanEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionAppEntity;
import com.microsoft.azure.toolkit.lib.appservice.entity.WebAppEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IWebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.cache.Preload;
import com.microsoft.azure.toolkit.lib.common.entity.CheckNameAvailabilityResultEntity;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AzureAppService
extends SubscriptionScoped<AzureAppService>
implements AzureService {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;

    public AzureAppService() {
        super(AzureAppService::new);
    }

    private AzureAppService(@Nonnull List<Subscription> subscriptions) {
        super(AzureAppService::new, subscriptions);
    }

    @Cacheable(cacheName="appservice/functionapp/{}", key="$id")
    @AzureOperation(name="functionapp.get.id", params={"id"}, type=AzureOperation.Type.SERVICE)
    public IFunctionApp functionApp(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureAppService$AjcClosure1 azureAppService$AjcClosure1 = new AzureAppService$AjcClosure1(objectArray);
        return (IFunctionApp)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public IFunctionApp functionApp(String resourceGroup, String name) {
        return this.functionApp(this.getDefaultSubscription().getId(), resourceGroup, name);
    }

    @Cacheable(cacheName="appservice/{}/rg/{}/functionapp/{}", key="$sid/$rg/$name")
    @AzureOperation(name="functionapp.get.name|rg|sid", params={"name", "rg", "sid"}, type=AzureOperation.Type.SERVICE)
    public IFunctionApp functionApp(String sid, String rg, String name) {
        String string = sid;
        String string2 = rg;
        String string3 = name;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        AzureAppService$AjcClosure3 azureAppService$AjcClosure3 = new AzureAppService$AjcClosure3(objectArray2);
        return (IFunctionApp)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public IFunctionApp functionApp(FunctionAppEntity entity) {
        return StringUtils.isEmpty((CharSequence)entity.getId()) ? this.functionApp(entity.getSubscriptionId(), entity.getResourceGroup(), entity.getName()) : this.functionApp(entity.getId());
    }

    @Preload
    @AzureOperation(name="functionapp.list.subscription|selected", type=AzureOperation.Type.SERVICE)
    public List<IFunctionApp> functionApps(boolean ... force) {
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)blArray);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List<IFunctionApp> list = ((Stream)this.getSubscriptions().stream().parallel()).flatMap(subscription -> this.functionApps(subscription.getId(), force).stream()).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Cacheable(cacheName="appservice/{}/functionapps", key="$sid", condition="!(force&&force[0])")
    @AzureOperation(name="functionapp.list.subscription", params={"sid"}, type=AzureOperation.Type.SERVICE)
    private List<IFunctionApp> functionApps(String sid, boolean ... force) {
        String string = sid;
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)blArray);
        Object[] objectArray = new Object[]{this, string, blArray, joinPoint};
        AzureAppService$AjcClosure5 azureAppService$AjcClosure5 = new AzureAppService$AjcClosure5(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @Cacheable(cacheName="appservice/webapp/{}", key="$id")
    @AzureOperation(name="webapp.get.id", params={"id"}, type=AzureOperation.Type.SERVICE)
    public IWebApp webapp(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureAppService$AjcClosure7 azureAppService$AjcClosure7 = new AzureAppService$AjcClosure7(objectArray);
        return (IWebApp)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    public IWebApp webapp(String resourceGroup, String name) {
        return this.webapp(this.getDefaultSubscription().getId(), resourceGroup, name);
    }

    @Cacheable(cacheName="appservice/{}/rg/{}/webapp/{}", key="$sid/$rg/$name")
    @AzureOperation(name="webapp.get.name|rg|sid", params={"name", "rg", "sid"}, type=AzureOperation.Type.SERVICE)
    public IWebApp webapp(String sid, String rg, String name) {
        String string = sid;
        String string2 = rg;
        String string3 = name;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        AzureAppService$AjcClosure9 azureAppService$AjcClosure9 = new AzureAppService$AjcClosure9(objectArray2);
        return (IWebApp)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    public IWebApp webapp(WebAppEntity webAppEntity) {
        return StringUtils.isEmpty((CharSequence)webAppEntity.getId()) ? this.webapp(webAppEntity.getSubscriptionId(), webAppEntity.getResourceGroup(), webAppEntity.getName()) : this.webapp(webAppEntity.getId());
    }

    @Preload
    @AzureOperation(name="webapp.list.subscription|selected", type=AzureOperation.Type.SERVICE)
    public List<IWebApp> webapps(boolean ... force) {
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object)blArray);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List<IWebApp> list = ((Stream)this.getSubscriptions().stream().parallel()).flatMap(subscription -> this.webapps(subscription.getId(), force).stream()).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="appservice.check_name", params={"name"}, type=AzureOperation.Type.SERVICE)
    public CheckNameAvailabilityResultEntity checkNameAvailability(String subscriptionId, String name) {
        String string = subscriptionId;
        String string2 = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AppServiceManager azureResourceManager = this.getAppServiceManager(subscriptionId);
            ResourceNameAvailabilityInner result = ((WebSiteManagementClient)((AppServiceManager)azureResourceManager.webApps().manager()).serviceClient()).getResourceProviders().checkNameAvailability(new ResourceNameAvailabilityRequest().withName(name).withType(CheckNameResourceTypes.MICROSOFT_WEB_SITES));
            CheckNameAvailabilityResultEntity checkNameAvailabilityResultEntity = new CheckNameAvailabilityResultEntity(result.nameAvailable().booleanValue(), result.reason().toString(), result.message());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return checkNameAvailabilityResultEntity;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Cacheable(cacheName="appservice/{}/webapps", key="$sid", condition="!(force&&force[0])")
    @AzureOperation(name="webapp.list.subscription", params={"sid"}, type=AzureOperation.Type.SERVICE)
    private List<IWebApp> webapps(String sid, boolean ... force) {
        String string = sid;
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)blArray);
        Object[] objectArray = new Object[]{this, string, blArray, joinPoint};
        AzureAppService$AjcClosure11 azureAppService$AjcClosure11 = new AzureAppService$AjcClosure11(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    @Nonnull
    @AzureOperation(name="webapp|runtime.list.os|version", params={"os.getValue()", "version.getValue()"}, type=AzureOperation.Type.SERVICE)
    public List<Runtime> listWebAppRuntimes(@Nonnull OperatingSystem os, @Nonnull JavaVersion version) {
        OperatingSystem operatingSystem = os;
        JavaVersion javaVersion = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this), (Object)((Object)operatingSystem), (Object)javaVersion);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List<Runtime> list = Runtime.WEBAPP_RUNTIME.stream().filter(runtime -> Objects.equals((Object)os, (Object)runtime.getOperatingSystem()) && Objects.equals(version, runtime.getJavaVersion())).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Cacheable(cacheName="appservice/plan/{}", key="$id")
    @AzureOperation(name="appservice|plan.get.id", params={"id"}, type=AzureOperation.Type.SERVICE)
    public IAppServicePlan appServicePlan(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureAppService$AjcClosure13 azureAppService$AjcClosure13 = new AzureAppService$AjcClosure13(objectArray);
        return (IAppServicePlan)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    public IAppServicePlan appServicePlan(String resourceGroup, String name) {
        return this.appServicePlan(this.getDefaultSubscription().getId(), resourceGroup, name);
    }

    @Cacheable(cacheName="appservice/{}/rg/{}/plan/{}", key="$sid/$rg/$name")
    @AzureOperation(name="appservice|plan.get.name|rg|sid", params={"name", "rg", "sid"}, type=AzureOperation.Type.SERVICE)
    public IAppServicePlan appServicePlan(String sid, String rg, String name) {
        String string = sid;
        String string2 = rg;
        String string3 = name;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        AzureAppService$AjcClosure15 azureAppService$AjcClosure15 = new AzureAppService$AjcClosure15(objectArray2);
        return (IAppServicePlan)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    public IAppServicePlan appServicePlan(AppServicePlanEntity entity) {
        return StringUtils.isEmpty((CharSequence)entity.getId()) ? this.appServicePlan(entity.getSubscriptionId(), entity.getResourceGroup(), entity.getName()) : this.appServicePlan(entity.getId());
    }

    @Preload
    @AzureOperation(name="appservice|plan.list.subscription|selected", type=AzureOperation.Type.SERVICE)
    public List<IAppServicePlan> appServicePlans(boolean ... force) {
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this), (Object)blArray);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List<IAppServicePlan> list = ((Stream)this.getSubscriptions().stream().parallel()).flatMap(subscription -> this.appServicePlans(subscription.getId(), force).stream()).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Cacheable(cacheName="appservice/{}/plans", key="$sid", condition="!(force&&force[0])")
    @AzureOperation(name="appservice|plan.list.subscription", params={"sid"}, type=AzureOperation.Type.SERVICE)
    public List<IAppServicePlan> appServicePlans(String sid, boolean ... force) {
        String string = sid;
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)blArray);
        Object[] objectArray = new Object[]{this, string, blArray, joinPoint};
        AzureAppService$AjcClosure17 azureAppService$AjcClosure17 = new AzureAppService$AjcClosure17(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    @Cacheable(cacheName="appservice/rg/{}/plans", key="$rg", condition="!(force&&force[0])")
    @AzureOperation(name="appservice|plan.list.rg", params={"rg"}, type=AzureOperation.Type.SERVICE)
    public List<IAppServicePlan> appServicePlansByResourceGroup(String rg, boolean ... force) {
        String string = rg;
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)blArray);
        Object[] objectArray = new Object[]{this, string, blArray, joinPoint};
        AzureAppService$AjcClosure19 azureAppService$AjcClosure19 = new AzureAppService$AjcClosure19(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    @Deprecated
    @Cacheable(cacheName="appservice/slot/{}", key="$id")
    @AzureOperation(name="appservice|deployment.get.id", params={"id"}, type=AzureOperation.Type.SERVICE)
    public IWebAppDeploymentSlot deploymentSlot(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureAppService$AjcClosure21 azureAppService$AjcClosure21 = new AzureAppService$AjcClosure21(objectArray);
        return (IWebAppDeploymentSlot)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure21.linkClosureAndJoinPoint(69648));
    }

    @Cacheable(cacheName="appservice/{}/manager", key="$sid")
    @AzureOperation(name="appservice.get_client.subscription", params={"sid"}, type=AzureOperation.Type.SERVICE)
    public AppServiceManager getAppServiceManager(String sid) {
        String string = sid;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureAppService$AjcClosure23 azureAppService$AjcClosure23 = new AzureAppService$AjcClosure23(objectArray);
        return (AppServiceManager)CacheManager.aspectOf().aroundCacheable(azureAppService$AjcClosure23.linkClosureAndJoinPoint(69648));
    }

    private HttpPipelinePolicy getUserAgentPolicy(String userAgent) {
        return (httpPipelineCallContext, httpPipelineNextPolicy) -> {
            String previousUserAgent = httpPipelineCallContext.getHttpRequest().getHeaders().getValue("User-Agent");
            httpPipelineCallContext.getHttpRequest().setHeader("User-Agent", String.format("%s %s", userAgent, previousUserAgent));
            return httpPipelineNextPolicy.process();
        };
    }

    public String name() {
        return "Microsoft.Web/sites";
    }

    static {
        AzureAppService.ajc$preClinit();
    }

    static final /* synthetic */ IFunctionApp functionApp_aroundBody0(AzureAppService ajc$this, String id, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            FunctionApp functionApp = new FunctionApp(id, ajc$this.getAppServiceManager(Utils.getSubscriptionId(id)));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return functionApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ IFunctionApp functionApp_aroundBody2(AzureAppService ajc$this, String sid, String rg, String name, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            FunctionApp functionApp = new FunctionApp(sid, rg, name, ajc$this.getAppServiceManager(sid));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return functionApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ List functionApps_aroundBody4(AzureAppService ajc$this, String sid, boolean[] force, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AppServiceManager azureResourceManager = ajc$this.getAppServiceManager(sid);
            List list = ((Stream)azureResourceManager.functionApps().list().stream().parallel()).filter(functionAppBasic -> StringUtils.containsIgnoreCase((CharSequence)((SiteInner)functionAppBasic.innerModel()).kind(), (CharSequence)"functionapp")).map(functionAppBasic -> new FunctionApp((WebSiteBase)functionAppBasic, azureResourceManager)).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ IWebApp webapp_aroundBody6(AzureAppService ajc$this, String id, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            WebApp webApp = new WebApp(id, ajc$this.getAppServiceManager(Utils.getSubscriptionId(id)));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ IWebApp webapp_aroundBody8(AzureAppService ajc$this, String sid, String rg, String name, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            WebApp webApp = new WebApp(sid, rg, name, ajc$this.getAppServiceManager(sid));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ List webapps_aroundBody10(AzureAppService ajc$this, String sid, boolean[] force, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AppServiceManager azureResourceManager = ajc$this.getAppServiceManager(sid);
            List list = ((Stream)azureResourceManager.webApps().list().stream().parallel()).filter(webAppBasic -> !StringUtils.containsIgnoreCase((CharSequence)((SiteInner)webAppBasic.innerModel()).kind(), (CharSequence)"functionapp")).map(webAppBasic -> new WebApp((WebSiteBase)webAppBasic, azureResourceManager)).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ IAppServicePlan appServicePlan_aroundBody12(AzureAppService ajc$this, String id, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AppServicePlan appServicePlan = new AppServicePlan(id, ajc$this.getAppServiceManager(Utils.getSubscriptionId(id)));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return appServicePlan;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ IAppServicePlan appServicePlan_aroundBody14(AzureAppService ajc$this, String sid, String rg, String name, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AppServicePlan appServicePlan = new AppServicePlan(sid, rg, name, ajc$this.getAppServiceManager(sid));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return appServicePlan;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ List appServicePlans_aroundBody16(AzureAppService ajc$this, String sid, boolean[] force, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AppServiceManager azureResourceManager = ajc$this.getAppServiceManager(sid);
            List list = ((Stream)azureResourceManager.appServicePlans().list().stream().parallel()).map(appServicePlan -> new AppServicePlan((com.azure.resourcemanager.appservice.models.AppServicePlan)appServicePlan, azureResourceManager)).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ List appServicePlansByResourceGroup_aroundBody18(AzureAppService ajc$this, String rg, boolean[] force, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List list = ((Stream)ajc$this.getSubscriptions().stream().parallel()).map(subscription -> this.getAppServiceManager(subscription.getId())).flatMap(azureResourceManager -> azureResourceManager.appServicePlans().listByResourceGroup(rg).stream().map(appServicePlan -> new AppServicePlan((com.azure.resourcemanager.appservice.models.AppServicePlan)appServicePlan, (AppServiceManager)azureResourceManager))).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ IWebAppDeploymentSlot deploymentSlot_aroundBody20(AzureAppService ajc$this, String id, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            WebAppDeploymentSlot webAppDeploymentSlot = new WebAppDeploymentSlot(id, ajc$this.getAppServiceManager(Utils.getSubscriptionId(id)));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webAppDeploymentSlot;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ AppServiceManager getAppServiceManager_aroundBody22(AzureAppService ajc$this, String sid, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
            AzureConfiguration config = Azure.az().config();
            String userAgent = config.getUserAgent();
            HttpLogDetailLevel logLevel = Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE);
            AzureProfile azureProfile = new AzureProfile(null, sid, account.getEnvironment());
            AppServiceManager appServiceManager = ((AppServiceManager.Configurable)((AppServiceManager.Configurable)((AppServiceManager.Configurable)AppServiceManager.configure().withHttpClient(AzureService.getDefaultHttpClient())).withLogLevel(logLevel)).withPolicy(ajc$this.getUserAgentPolicy(userAgent))).authenticate(account.getTokenCredential(sid), azureProfile);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return appServiceManager;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureAppService.java", AzureAppService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "functionApp", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String", "id", "", "com.microsoft.azure.toolkit.lib.appservice.service.IFunctionApp"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "functionApp", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String:java.lang.String:java.lang.String", "sid:rg:name", "", "com.microsoft.azure.toolkit.lib.appservice.service.IFunctionApp"), 71);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "appServicePlan", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String", "id", "", "com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan"), 157);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "appServicePlan", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String:java.lang.String:java.lang.String", "sid:rg:name", "", "com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan"), 167);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "appServicePlans", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "[Z", "force", "", "java.util.List"), 178);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "appServicePlans", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String:[Z", "sid:force", "", "java.util.List"), 186);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "appServicePlansByResourceGroup", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String:[Z", "rg:force", "", "java.util.List"), 195);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploymentSlot", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String", "id", "", "com.microsoft.azure.toolkit.lib.appservice.service.IWebAppDeploymentSlot"), 206);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAppServiceManager", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String", "sid", "", "com.azure.resourcemanager.appservice.AppServiceManager"), 213);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "functionApps", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "[Z", "force", "", "java.util.List"), 82);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("82", "functionApps", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String:[Z", "sid:force", "", "java.util.List"), 90);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "webapp", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String", "id", "", "com.microsoft.azure.toolkit.lib.appservice.service.IWebApp"), 101);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "webapp", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String:java.lang.String:java.lang.String", "sid:rg:name", "", "com.microsoft.azure.toolkit.lib.appservice.service.IWebApp"), 111);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "webapps", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "[Z", "force", "", "java.util.List"), 122);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkNameAvailability", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String:java.lang.String", "subscriptionId:name", "", "com.microsoft.azure.toolkit.lib.common.entity.CheckNameAvailabilityResultEntity"), 129);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("82", "webapps", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "java.lang.String:[Z", "sid:force", "", "java.util.List"), 139);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listWebAppRuntimes", "com.microsoft.azure.toolkit.lib.appservice.AzureAppService", "com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem:com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion", "os:version", "", "java.util.List"), 149);
    }
}

