/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class Runtime {
    private static final Pattern LINUX_FX_VERSION_PATTERN = Pattern.compile("(?i)(JAVA|TOMCAT|JBOSSEAP)\\|((.*)-)?(.+)");
    public static final Runtime WINDOWS_JAVA8 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_SE, JavaVersion.JAVA_8);
    public static final Runtime WINDOWS_JAVA11 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_SE, JavaVersion.JAVA_11);
    public static final Runtime WINDOWS_JAVA8_TOMCAT9 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_9, JavaVersion.JAVA_8);
    public static final Runtime WINDOWS_JAVA8_TOMCAT85 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_85, JavaVersion.JAVA_8);
    public static final Runtime WINDOWS_JAVA11_TOMCAT9 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_9, JavaVersion.JAVA_11);
    public static final Runtime WINDOWS_JAVA11_TOMCAT85 = new Runtime(OperatingSystem.WINDOWS, WebContainer.TOMCAT_85, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA8 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_SE, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA11 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_SE, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA8_TOMCAT9 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_9, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA8_TOMCAT85 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_85, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA8_JBOSS7 = new Runtime(OperatingSystem.LINUX, WebContainer.JBOSS_7, JavaVersion.JAVA_8);
    public static final Runtime LINUX_JAVA11_JBOSS7 = new Runtime(OperatingSystem.LINUX, WebContainer.JBOSS_7, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA11_TOMCAT9 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_9, JavaVersion.JAVA_11);
    public static final Runtime LINUX_JAVA11_TOMCAT85 = new Runtime(OperatingSystem.LINUX, WebContainer.TOMCAT_85, JavaVersion.JAVA_11);
    public static final Runtime FUNCTION_WINDOWS_JAVA8 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_OFF, JavaVersion.JAVA_8);
    public static final Runtime FUNCTION_WINDOWS_JAVA11 = new Runtime(OperatingSystem.WINDOWS, WebContainer.JAVA_OFF, JavaVersion.JAVA_11);
    public static final Runtime FUNCTION_LINUX_JAVA8 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_OFF, JavaVersion.JAVA_8);
    public static final Runtime FUNCTION_LINUX_JAVA11 = new Runtime(OperatingSystem.LINUX, WebContainer.JAVA_OFF, JavaVersion.JAVA_11);
    public static final Runtime DOCKER = new Runtime(OperatingSystem.DOCKER, null, null);
    public static final List<Runtime> WEBAPP_RUNTIME = Collections.unmodifiableList(Arrays.asList(WINDOWS_JAVA8, WINDOWS_JAVA11, WINDOWS_JAVA8_TOMCAT9, WINDOWS_JAVA8_TOMCAT85, WINDOWS_JAVA11_TOMCAT9, WINDOWS_JAVA11_TOMCAT85, LINUX_JAVA8, LINUX_JAVA11, LINUX_JAVA8_TOMCAT9, LINUX_JAVA8_TOMCAT85, LINUX_JAVA11_JBOSS7, LINUX_JAVA8_JBOSS7, LINUX_JAVA11_TOMCAT9, LINUX_JAVA11_TOMCAT85));
    public static final List<Runtime> FUNCTION_APP_RUNTIME = Collections.unmodifiableList(Arrays.asList(FUNCTION_LINUX_JAVA8, FUNCTION_LINUX_JAVA11, FUNCTION_WINDOWS_JAVA8, FUNCTION_WINDOWS_JAVA11));
    private static final List<Runtime> values = Collections.unmodifiableList(new ArrayList(new HashSet(ListUtils.union(WEBAPP_RUNTIME, FUNCTION_APP_RUNTIME))));
    private OperatingSystem operatingSystem;
    private WebContainer webContainer;
    private JavaVersion javaVersion;

    public static Runtime getRuntime(OperatingSystem operatingSystem, WebContainer webContainer, JavaVersion javaVersion) {
        Runtime standardRuntime = Runtime.values().stream().filter(runtime -> Objects.equals((Object)runtime.operatingSystem, (Object)operatingSystem)).filter(runtime -> Objects.equals(runtime.webContainer, webContainer)).filter(runtime -> Objects.equals(runtime.javaVersion, javaVersion)).findFirst().orElse(null);
        if (standardRuntime != null) {
            return standardRuntime;
        }
        return new Runtime(operatingSystem, webContainer, javaVersion);
    }

    public static Runtime getRuntimeFromLinuxFxVersion(String linuxFxVersion) {
        Matcher matcher = LINUX_FX_VERSION_PATTERN.matcher(linuxFxVersion);
        if (!matcher.matches()) {
            return Runtime.getRuntime(OperatingSystem.LINUX, WebContainer.JAVA_OFF, JavaVersion.OFF);
        }
        String javaVersion = matcher.group(4);
        String webContainer = StringUtils.isEmpty((CharSequence)matcher.group(3)) ? matcher.group(1) : String.format("%s %s", matcher.group(1), matcher.group(3)).trim();
        return Runtime.getRuntime(OperatingSystem.LINUX, WebContainer.fromString(webContainer), JavaVersion.fromString(javaVersion));
    }

    public static List<Runtime> values() {
        return values;
    }

    public boolean isWindows() {
        return Objects.equals((Object)this.operatingSystem, (Object)OperatingSystem.WINDOWS);
    }

    public boolean isLinux() {
        return Objects.equals((Object)this.operatingSystem, (Object)OperatingSystem.LINUX);
    }

    public boolean isDocker() {
        return Objects.equals((Object)this.operatingSystem, (Object)OperatingSystem.DOCKER);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Runtime)) {
            return false;
        }
        Runtime runtime = (Runtime)o;
        return this.operatingSystem == runtime.operatingSystem && Objects.equals(this.webContainer, runtime.webContainer) && Objects.equals(this.javaVersion, runtime.javaVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operatingSystem, this.webContainer, this.javaVersion});
    }

    public String toString() {
        if (this.isDocker()) {
            return "Docker";
        }
        return Stream.of(new Object[]{this.getOperatingSystem(), this.getJavaVersion(), this.getWebContainer()}).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining("|"));
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public WebContainer getWebContainer() {
        return this.webContainer;
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public void setWebContainer(WebContainer webContainer) {
        this.webContainer = webContainer;
    }

    public void setJavaVersion(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
    }

    public Runtime() {
    }

    public Runtime(OperatingSystem operatingSystem, WebContainer webContainer, JavaVersion javaVersion) {
        this.operatingSystem = operatingSystem;
        this.webContainer = webContainer;
        this.javaVersion = javaVersion;
    }
}

