/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsEntity;
import com.microsoft.azure.toolkit.lib.applicationinsights.task.GetOrCreateApplicationInsightsTask;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServiceUpdater;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateAppServicePlanTask;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.ResourceGroup;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import com.microsoft.azure.toolkit.lib.resource.task.CreateResourceGroupTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class CreateOrUpdateFunctionAppTask
extends AzureTask<IFunctionAppBase<?>> {
    public static final String APPINSIGHTS_INSTRUMENTATION_KEY = "APPINSIGHTS_INSTRUMENTATIONKEY";
    private static final String APPLICATION_INSIGHTS_CREATE_FAILED = "Unable to create the Application Insights for the Function App due to error %s. Please use the Azure Portal to manually create and configure the Application Insights if needed.";
    private static final String CREATE_FUNCTION_APP = "Creating function app %s...";
    private static final String CREATE_FUNCTION_APP_DONE = "Successfully created function app %s.";
    private static final String CREATE_NEW_FUNCTION_APP = "isCreateNewFunctionApp";
    private static final String UPDATE_FUNCTION_APP = "Updating target Function App %s...";
    private static final String UPDATE_FUNCTION_DONE = "Successfully updated Function App %s.";
    private static final String FUNCTIONS_WORKER_RUNTIME_NAME = "FUNCTIONS_WORKER_RUNTIME";
    private static final String FUNCTIONS_WORKER_RUNTIME_VALUE = "java";
    private static final String SET_FUNCTIONS_WORKER_RUNTIME = "Set function worker runtime to java.";
    private static final String CUSTOMIZED_FUNCTIONS_WORKER_RUNTIME_WARNING = "App setting `FUNCTIONS_WORKER_RUNTIME` doesn't meet the requirement of Azure Java Functions, the value should be `java`.";
    private static final String FUNCTIONS_EXTENSION_VERSION_NAME = "FUNCTIONS_EXTENSION_VERSION";
    private static final String FUNCTIONS_EXTENSION_VERSION_VALUE = "~3";
    private static final String SET_FUNCTIONS_EXTENSION_VERSION = "Functions extension version isn't configured, setting up the default value.";
    private static final String FUNCTION_APP_NOT_EXIST_FOR_SLOT = "The Function App specified in pom.xml does not exist. Please make sure the Web App name is correct.";
    private static final String FUNCTION_SLOT_CREATE_START = "The specified function slot does not exist. Creating a new slot...";
    private static final String FUNCTION_SLOT_CREATED = "Successfully created the function slot: %s.";
    private static final String FUNCTION_SLOT_UPDATE = "Updating the specified function slot...";
    private static final String FUNCTION_SLOT_UPDATE_DONE = "Successfully updated the function slot: %s.";
    public static final JavaVersion DEFAULT_FUNCTION_JAVA_VERSION = JavaVersion.JAVA_8;
    private final FunctionAppConfig functionAppConfig;
    private final List<AzureTask<?>> tasks = new ArrayList();
    private ResourceGroup resourceGroup;
    private IAppServicePlan appServicePlan;
    private ApplicationInsightsEntity applicationInsights;
    private IFunctionAppBase<?> functionApp;

    public CreateOrUpdateFunctionAppTask(@Nonnull FunctionAppConfig config) {
        this.functionAppConfig = config;
        this.initTasks();
    }

    private void initTasks() {
        IFunctionApp functionApp = ((AzureAppService)((AzureAppService)Azure.az(AzureAppService.class)).subscription(this.functionAppConfig.subscriptionId())).functionApp(this.functionAppConfig.resourceGroup(), this.functionAppConfig.appName());
        this.registerSubTask((AzureTask)this.getResourceGroupTask(), result -> {
            this.resourceGroup = result;
        });
        this.registerSubTask(this.getServicePlanTask(), result -> {
            this.appServicePlan = result;
        });
        if (!this.functionAppConfig.disableAppInsights() && !this.functionAppConfig.appSettings().containsKey(APPINSIGHTS_INSTRUMENTATION_KEY)) {
            if (StringUtils.isNotEmpty((CharSequence)this.functionAppConfig.appInsightsKey())) {
                this.applicationInsights = ApplicationInsightsEntity.builder().instrumentationKey(this.functionAppConfig.appInsightsKey()).build();
            } else if (StringUtils.isNotEmpty((CharSequence)this.functionAppConfig.appInsightsInstance()) || !functionApp.exists()) {
                this.registerSubTask(this.getApplicationInsightsTask(), result -> {
                    this.applicationInsights = result;
                });
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.functionAppConfig.deploymentSlotName())) {
            AzureTask<IFunctionApp> functionTask = functionApp.exists() ? this.getUpdateFunctionAppTask(functionApp) : this.getCreateFunctionAppTask(functionApp);
            this.registerSubTask(functionTask, result -> {
                this.functionApp = result;
            });
        } else {
            IFunctionAppDeploymentSlot deploymentSlot = this.getFunctionDeploymentSlot(functionApp);
            AzureTask<IFunctionAppDeploymentSlot> slotTask = deploymentSlot.exists() ? this.getUpdateFunctionSlotTask(deploymentSlot) : this.getCreateFunctionSlotTask(deploymentSlot);
            this.registerSubTask(slotTask, result -> {
                this.functionApp = result;
            });
        }
    }

    private <T> void registerSubTask(AzureTask<T> task, Consumer<T> consumer) {
        this.tasks.add(new AzureTask(() -> {
            Object result = task.getSupplier().get();
            consumer.accept(result);
            return result;
        }));
    }

    private AzureTask<IFunctionApp> getCreateFunctionAppTask(IFunctionApp functionApp) {
        AzureString title = AzureString.format((String)"Create new app({0}) on subscription({1})", (Object[])new Object[]{this.functionAppConfig.appName(), this.functionAppConfig.subscriptionId()});
        return new AzureTask(title, () -> {
            AzureTelemetry.getActionContext().setProperty(CREATE_NEW_FUNCTION_APP, String.valueOf(true));
            AzureMessager.getMessager().info(String.format(CREATE_FUNCTION_APP, this.functionAppConfig.appName()));
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            Optional.ofNullable(this.applicationInsights).ifPresent(insights -> appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, this.applicationInsights.getInstrumentationKey()));
            IFunctionApp result = functionApp.create().withName(this.functionAppConfig.appName()).withResourceGroup(this.resourceGroup.getName()).withPlan(this.appServicePlan.id()).withRuntime(this.getRuntime(this.functionAppConfig.runtime())).withDockerConfiguration(this.getDockerConfiguration(this.functionAppConfig.runtime())).withAppSettings(appSettings).commit();
            AzureMessager.getMessager().info(String.format(CREATE_FUNCTION_APP_DONE, result.name()));
            return result;
        });
    }

    private Map<String, String> processAppSettingsWithDefaultValue() {
        Map<String, String> appSettings = this.functionAppConfig.appSettings();
        this.setDefaultAppSetting(appSettings, FUNCTIONS_WORKER_RUNTIME_NAME, SET_FUNCTIONS_WORKER_RUNTIME, FUNCTIONS_WORKER_RUNTIME_VALUE, CUSTOMIZED_FUNCTIONS_WORKER_RUNTIME_WARNING);
        this.setDefaultAppSetting(appSettings, FUNCTIONS_EXTENSION_VERSION_NAME, SET_FUNCTIONS_EXTENSION_VERSION, FUNCTIONS_EXTENSION_VERSION_VALUE, null);
        return appSettings;
    }

    private void setDefaultAppSetting(Map<String, String> result, String settingName, String settingIsEmptyMessage, String defaultValue, String warningMessage) {
        String setting = result.get(settingName);
        if (StringUtils.isEmpty((CharSequence)setting)) {
            AzureMessager.getMessager().info(settingIsEmptyMessage);
            result.put(settingName, defaultValue);
            return;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)setting, (CharSequence)defaultValue) && StringUtils.isNotEmpty((CharSequence)warningMessage)) {
            AzureMessager.getMessager().warning(warningMessage);
        }
    }

    private AzureTask<IFunctionApp> getUpdateFunctionAppTask(IFunctionApp functionApp) {
        AzureString title = AzureString.format((String)"Update function app({0})", (Object[])new Object[]{this.functionAppConfig.appName()});
        return new AzureTask(title, () -> {
            AzureMessager.getMessager().info(String.format(UPDATE_FUNCTION_APP, functionApp.name()));
            IAppServiceUpdater<? extends IFunctionApp> update = functionApp.update();
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            if (this.functionAppConfig.disableAppInsights()) {
                update.withoutAppSettings(APPINSIGHTS_INSTRUMENTATION_KEY);
            } else if (this.applicationInsights != null) {
                appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, this.applicationInsights.getInstrumentationKey());
            }
            IFunctionApp result = update.withPlan(this.appServicePlan.id()).withRuntime(this.getRuntime(this.functionAppConfig.runtime())).withDockerConfiguration(this.getDockerConfiguration(this.functionAppConfig.runtime())).withAppSettings(appSettings).commit();
            AzureMessager.getMessager().info(String.format(UPDATE_FUNCTION_DONE, functionApp.name()));
            return result;
        });
    }

    private AzureTask<IFunctionAppDeploymentSlot> getCreateFunctionSlotTask(IFunctionAppDeploymentSlot deploymentSlot) {
        AzureString title = AzureString.format((String)"Create new slot({0}) on function app ({1})", (Object[])new Object[]{this.functionAppConfig.deploymentSlotName(), this.functionAppConfig.appName()});
        return new AzureTask(title, () -> {
            AzureMessager.getMessager().info(FUNCTION_SLOT_CREATE_START);
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            Optional.ofNullable(this.applicationInsights).ifPresent(insights -> appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, this.applicationInsights.getInstrumentationKey()));
            IFunctionAppDeploymentSlot result = deploymentSlot.create().withAppSettings(appSettings).withConfigurationSource(this.functionAppConfig.deploymentSlotConfigurationSource()).withName(this.functionAppConfig.deploymentSlotName()).commit();
            AzureMessager.getMessager().info(String.format(FUNCTION_SLOT_CREATED, result.name()));
            return result;
        });
    }

    private AzureTask<IFunctionAppDeploymentSlot> getUpdateFunctionSlotTask(IFunctionAppDeploymentSlot deploymentSlot) {
        AzureString title = AzureString.format((String)"Update function deployment slot({0})", (Object[])new Object[]{this.functionAppConfig.deploymentSlotName()});
        return new AzureTask(title, () -> {
            AzureMessager.getMessager().info(FUNCTION_SLOT_UPDATE);
            Map<String, String> appSettings = this.processAppSettingsWithDefaultValue();
            IFunctionAppDeploymentSlot.Updater update = deploymentSlot.update();
            if (this.functionAppConfig.disableAppInsights()) {
                update.withoutAppSettings(APPINSIGHTS_INSTRUMENTATION_KEY);
            } else if (this.applicationInsights != null) {
                appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, this.applicationInsights.getInstrumentationKey());
            }
            IFunctionAppDeploymentSlot result = update.withAppSettings(appSettings).commit();
            AzureMessager.getMessager().info(String.format(FUNCTION_SLOT_UPDATE_DONE, result.name()));
            return deploymentSlot;
        });
    }

    private IFunctionAppDeploymentSlot getFunctionDeploymentSlot(IFunctionApp functionApp) {
        if (!functionApp.exists()) {
            throw new AzureToolkitRuntimeException(FUNCTION_APP_NOT_EXIST_FOR_SLOT);
        }
        return functionApp.deploymentSlot(this.functionAppConfig.deploymentSlotName());
    }

    private AzureTask<ApplicationInsightsEntity> getApplicationInsightsTask() {
        return new AzureTask(() -> {
            try {
                String name = (String)StringUtils.firstNonEmpty((CharSequence[])new String[]{this.functionAppConfig.appInsightsInstance(), this.functionAppConfig.appName()});
                return (ApplicationInsightsEntity)new GetOrCreateApplicationInsightsTask(this.functionAppConfig.subscriptionId(), this.functionAppConfig.resourceGroup(), this.functionAppConfig.region(), name).getSupplier().get();
            }
            catch (Exception e) {
                AzureMessager.getMessager().warning(String.format(APPLICATION_INSIGHTS_CREATE_FAILED, e.getMessage()));
                return null;
            }
        });
    }

    private CreateResourceGroupTask getResourceGroupTask() {
        return new CreateResourceGroupTask(this.functionAppConfig.subscriptionId(), this.functionAppConfig.resourceGroup(), this.functionAppConfig.region());
    }

    private CreateOrUpdateAppServicePlanTask getServicePlanTask() {
        return new CreateOrUpdateAppServicePlanTask(this.functionAppConfig.getServicePlanConfig());
    }

    private Runtime getRuntime(RuntimeConfig runtime) {
        return Runtime.getRuntime(runtime.os(), WebContainer.JAVA_OFF, OperatingSystem.DOCKER != runtime.os() ? runtime.javaVersion() : JavaVersion.OFF);
    }

    private DockerConfiguration getDockerConfiguration(RuntimeConfig runtime) {
        if (OperatingSystem.DOCKER == runtime.os()) {
            return ((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)((DockerConfiguration.DockerConfigurationBuilder)DockerConfiguration.builder().userName(runtime.username())).password(runtime.password())).registryUrl(runtime.registryUrl())).image(runtime.image())).startUpCommand(runtime.startUpCommand())).build();
        }
        return null;
    }

    public IFunctionAppBase<?> execute() {
        this.tasks.forEach(t -> t.getSupplier().get());
        return this.functionApp;
    }
}

