/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.microsoft.azure.toolkit.lib.AbstractAzureResourceModule;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan$AjcClosure1;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan$AjcClosure3;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan$AjcClosure5;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan$AjcClosure7;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.event.AzureOperationEvent;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureAppServicePlan
extends AbstractAzureResourceModule<AppServicePlan>
implements AzureOperationEvent.Source<AzureAppServicePlan> {
    private static final Logger log;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public AzureAppServicePlan() {
        super(AzureAppServicePlan::new);
    }

    private AzureAppServicePlan(@Nonnull List<Subscription> subscriptions) {
        super(AzureAppServicePlan::new, subscriptions);
    }

    @AzureOperation(name="service.refresh.service", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void refresh() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            try {
                CacheManager.evictCache((String)"appservice/{}/plans", (String)"<ALL>");
            }
            catch (ExecutionException e) {
                log.warn("failed to evict cache", (Throwable)e);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public String name() {
        return "App Service Plan";
    }

    @Cacheable(cacheName="appservice/{}/plans", key="$subscriptionId", condition="!(force&&force[0])")
    @AzureOperation(name="appservice.list_plans.subscription", params={"subscriptionId"}, type=AzureOperation.Type.SERVICE)
    public List<AppServicePlan> list(@NotNull String subscriptionId, boolean ... force) {
        String string = subscriptionId;
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)blArray);
        Object[] objectArray = new Object[]{this, string, blArray, joinPoint};
        AzureAppServicePlan$AjcClosure1 azureAppServicePlan$AjcClosure1 = new AzureAppServicePlan$AjcClosure1(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(azureAppServicePlan$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Cacheable(cacheName="appservice/rg/{}/plans", key="$rg", condition="!(force&&force[0])")
    @AzureOperation(name="appservice.list_plans.rg", params={"rg"}, type=AzureOperation.Type.SERVICE)
    public List<AppServicePlan> appServicePlansByResourceGroup(String rg, boolean ... force) {
        String string = rg;
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)blArray);
        Object[] objectArray = new Object[]{this, string, blArray, joinPoint};
        AzureAppServicePlan$AjcClosure3 azureAppServicePlan$AjcClosure3 = new AzureAppServicePlan$AjcClosure3(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(azureAppServicePlan$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Cacheable(cacheName="appservice/{}/rg/{}/plan/{}", key="$subscriptionId/$resourceGroup/$name")
    @AzureOperation(name="appservice.get_plan.plan|rg", params={"name", "resourceGroup"}, type=AzureOperation.Type.SERVICE)
    @NotNull
    public AppServicePlan get(@NotNull String subscriptionId, @NotNull String resourceGroup, @NotNull String name) {
        String string = subscriptionId;
        String string2 = resourceGroup;
        String string3 = name;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        AzureAppServicePlan$AjcClosure5 azureAppServicePlan$AjcClosure5 = new AzureAppServicePlan$AjcClosure5(objectArray2);
        return (AppServicePlan)CacheManager.aspectOf().aroundCacheable(azureAppServicePlan$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @Cacheable(cacheName="appservice/{}/manager", key="$subscriptionId")
    @AzureOperation(name="appservice.get_client.subscription", params={"subscriptionId"}, type=AzureOperation.Type.SERVICE)
    AppServiceManager getAppServiceManager(String subscriptionId) {
        String string = subscriptionId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureAppServicePlan$AjcClosure7 azureAppServicePlan$AjcClosure7 = new AzureAppServicePlan$AjcClosure7(objectArray);
        return (AppServiceManager)CacheManager.aspectOf().aroundCacheable(azureAppServicePlan$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    static {
        AzureAppServicePlan.ajc$preClinit();
        log = LoggerFactory.getLogger(AzureAppServicePlan.class);
    }

    static final /* synthetic */ List list_aroundBody0(AzureAppServicePlan ajc$this, String subscriptionId, boolean[] force, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AppServiceManager azureResourceManager = ajc$this.getAppServiceManager(subscriptionId);
            List list = ((Stream)azureResourceManager.appServicePlans().list().stream().parallel()).map(appServicePlan -> (AppServicePlan)this.get(appServicePlan.id())).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ List appServicePlansByResourceGroup_aroundBody2(AzureAppServicePlan ajc$this, String rg, boolean[] force, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List list = ((Stream)ajc$this.getSubscriptions().stream().parallel()).map(subscription -> this.getAppServiceManager(subscription.getId())).flatMap(azureResourceManager -> azureResourceManager.appServicePlans().listByResourceGroup(rg).stream().map(appServicePlan -> new AppServicePlan((com.azure.resourcemanager.appservice.models.AppServicePlan)appServicePlan, (AppServiceManager)azureResourceManager))).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ AppServicePlan get_aroundBody4(AzureAppServicePlan ajc$this, String subscriptionId, String resourceGroup, String name, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AppServicePlan appServicePlan = new AppServicePlan(subscriptionId, resourceGroup, name, ajc$this.getAppServiceManager(subscriptionId));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return appServicePlan;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ AppServiceManager getAppServiceManager_aroundBody6(AzureAppServicePlan ajc$this, String subscriptionId, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AppServiceManager appServiceManager = (AppServiceManager)AzureAppServicePlan.getResourceManager((String)subscriptionId, AppServiceManager::configure, AppServiceManager.Configurable::authenticate);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return appServiceManager;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureAppServicePlan.java", AzureAppServicePlan.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan", "", "", "", "void"), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "list", "com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan", "java.lang.String:[Z", "subscriptionId:force", "", "java.util.List"), 53);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "appServicePlansByResourceGroup", "com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan", "java.lang.String:[Z", "rg:force", "", "java.util.List"), 62);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan", "java.lang.String:java.lang.String:java.lang.String", "subscriptionId:resourceGroup:name", "", "com.microsoft.azure.toolkit.lib.appservice.service.impl.AppServicePlan"), 74);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getAppServiceManager", "com.microsoft.azure.toolkit.lib.appservice.AzureAppServicePlan", "java.lang.String", "subscriptionId", "", "com.azure.resourcemanager.appservice.AppServiceManager"), 81);
    }
}

