/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.microsoft.azure.toolkit.lib.AbstractAzureResourceModule;
import com.microsoft.azure.toolkit.lib.appservice.AzureWebApp$AjcClosure1;
import com.microsoft.azure.toolkit.lib.appservice.AzureWebApp$AjcClosure3;
import com.microsoft.azure.toolkit.lib.appservice.AzureWebApp$AjcClosure5;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp;
import com.microsoft.azure.toolkit.lib.common.cache.CacheManager;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.event.AzureOperationEvent;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureWebApp
extends AbstractAzureResourceModule<WebApp>
implements AzureOperationEvent.Source<AzureWebApp> {
    private static final Logger log;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public AzureWebApp() {
        super(AzureWebApp::new);
    }

    private AzureWebApp(@Nonnull List<Subscription> subscriptions) {
        super(AzureWebApp::new, subscriptions);
    }

    @Cacheable(cacheName="appservice/{}/webapps", key="$sid", condition="!(force&&force[0])")
    @AzureOperation(name="webapp.list_apps.subscription", params={"sid"}, type=AzureOperation.Type.SERVICE)
    public List<WebApp> list(@NotNull String sid, boolean ... force) {
        String string = sid;
        boolean[] blArray = force;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)blArray);
        Object[] objectArray = new Object[]{this, string, blArray, joinPoint};
        AzureWebApp$AjcClosure1 azureWebApp$AjcClosure1 = new AzureWebApp$AjcClosure1(objectArray);
        return (List)CacheManager.aspectOf().aroundCacheable(azureWebApp$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Cacheable(cacheName="appservice/{}/rg/{}/webapp/{}", key="$sid/$rg/$name")
    @AzureOperation(name="webapp.get_app.app|rg", params={"name", "rg"}, type=AzureOperation.Type.SERVICE)
    @NotNull
    public WebApp get(@NotNull String sid, @NotNull String rg, @NotNull String name) {
        String string = sid;
        String string2 = rg;
        String string3 = name;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        AzureWebApp$AjcClosure3 azureWebApp$AjcClosure3 = new AzureWebApp$AjcClosure3(objectArray2);
        return (WebApp)CacheManager.aspectOf().aroundCacheable(azureWebApp$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Nonnull
    @AzureOperation(name="webapp.list_runtimes.os|version", params={"os.getValue()", "version.getValue()"}, type=AzureOperation.Type.SERVICE)
    public List<Runtime> listWebAppRuntimes(@Nonnull OperatingSystem os, @Nonnull JavaVersion version) {
        OperatingSystem operatingSystem = os;
        JavaVersion javaVersion = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)((Object)operatingSystem), (Object)javaVersion);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            List<Runtime> list = Runtime.WEBAPP_RUNTIME.stream().filter(runtime -> Objects.equals((Object)os, (Object)runtime.getOperatingSystem()) && Objects.equals(version, runtime.getJavaVersion())).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Cacheable(cacheName="appservice/{}/manager", key="$subscriptionId")
    @AzureOperation(name="appservice.get_client.subscription", params={"subscriptionId"}, type=AzureOperation.Type.SERVICE)
    AppServiceManager getAppServiceManager(String subscriptionId) {
        String string = subscriptionId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        AzureWebApp$AjcClosure5 azureWebApp$AjcClosure5 = new AzureWebApp$AjcClosure5(objectArray);
        return (AppServiceManager)CacheManager.aspectOf().aroundCacheable(azureWebApp$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @AzureOperation(name="service.refresh.service", params={"this.name()"}, type=AzureOperation.Type.SERVICE)
    public void refresh() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            try {
                CacheManager.evictCache((String)"appservice/{}/webapps", (String)"<ALL>");
            }
            catch (ExecutionException e) {
                log.warn("failed to evict cache", (Throwable)e);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public String name() {
        return "Azure WebApp";
    }

    static {
        AzureWebApp.ajc$preClinit();
        log = LoggerFactory.getLogger(AzureWebApp.class);
    }

    static final /* synthetic */ List list_aroundBody0(AzureWebApp ajc$this, String sid, boolean[] force, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AppServiceManager azureResourceManager = ajc$this.getAppServiceManager(sid);
            List list = ((Stream)azureResourceManager.webApps().list().stream().parallel()).filter(webAppBasic -> !StringUtils.containsIgnoreCase((CharSequence)((SiteInner)webAppBasic.innerModel()).kind(), (CharSequence)"functionapp")).map(webAppBasic -> (WebApp)this.get(webAppBasic.id())).collect(Collectors.toList());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ WebApp get_aroundBody2(AzureWebApp ajc$this, String sid, String rg, String name, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            WebApp webApp = new WebApp(sid, rg, name, ajc$this.getAppServiceManager(sid));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return webApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    static final /* synthetic */ AppServiceManager getAppServiceManager_aroundBody4(AzureWebApp ajc$this, String subscriptionId, JoinPoint joinPoint) {
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            AppServiceManager appServiceManager = (AppServiceManager)AzureWebApp.getResourceManager((String)subscriptionId, AppServiceManager::configure, AppServiceManager.Configurable::authenticate);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return appServiceManager;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AzureWebApp.java", AzureWebApp.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "list", "com.microsoft.azure.toolkit.lib.appservice.AzureWebApp", "java.lang.String:[Z", "sid:force", "", "java.util.List"), 43);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "com.microsoft.azure.toolkit.lib.appservice.AzureWebApp", "java.lang.String:java.lang.String:java.lang.String", "sid:rg:name", "", "com.microsoft.azure.toolkit.lib.appservice.service.impl.WebApp"), 55);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listWebAppRuntimes", "com.microsoft.azure.toolkit.lib.appservice.AzureWebApp", "com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem:com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion", "os:version", "", "java.util.List"), 61);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getAppServiceManager", "com.microsoft.azure.toolkit.lib.appservice.AzureWebApp", "java.lang.String", "subscriptionId", "", "com.azure.resourcemanager.appservice.AppServiceManager"), 70);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "com.microsoft.azure.toolkit.lib.appservice.AzureWebApp", "", "", "", "void"), 76);
    }
}

